package com.ajb.car;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.ajb.car.schedule.ScheduledTaskService;
import com.ajb.car.vo.common.CommonResult;
import com.ajb.car.vo.zhima.quotation.QuotationRequestVO;
import com.ajb.car.vo.zhima.quotation.QuotationResponse;


@RestController
public class CarController {
	@Autowired
	private ScheduledTaskService taskService;
	
	@RequestMapping("/quotations")
	public Object synch(@RequestBody QuotationRequestVO loginRequestVO) throws Exception{				
		QuotationResponse quotationResponse = new QuotationResponse();

		try
		{
			DateFormat fmt =new SimpleDateFormat("yyyy-MM-dd");
			Date begin = fmt.parse(loginRequestVO.getBegindate());
			
			Date end = fmt.parse(loginRequestVO.getEnddate());
			
			quotationResponse = taskService.synchQuotaion(begin,end);
		}catch (Exception ex){
			quotationResponse.setCommonResult(new CommonResult(false, "Error! begindate and enddate format yyyy-MM-dd!ex:{\"begindate\":\"2018-06-10\",\"enddate\":\"2018-06-10\"}"));	
		}finally{
		}
		quotationResponse.setCommonResult(new CommonResult(true, "Success!"));
		return quotationResponse;
	}
}