package com.ajb.car.entity.quotation;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
  车船税
*/

@Entity
@Table(name="ag_po_quotation_tax")
public class AgPoQuotationTax implements java.io.Serializable {

private static final long serialVersionUID = 1L;

	// 编号id
	private Long id;

	// 报价单编号id
	private Long quotationId;

	// 车辆id
	private Long quotationVehicleId;

	// 车船税类型编码
	private String vehKind;

	// 完税人
	private String payerName;

	// 电话
	private String telephone;

	private BigDecimal taxAmount;

	private String taxPayer;

	// 支付状态0：支付，-1未支付
	private Integer taxPayable;

	// 是否是个人
	private Integer isPerson;

	// 证件类型
	private String certType;

	// 证件号码
	private String certCode;

	// 地址
	private String regAddr;

	// 承载量
	private String loadCapicity;

	// 税款所属期起
	private Date startDate;

	// 税款所属期止
	private Date endDate;

	private String backDateFrom;

	private String backDateTo;

	private String lateDateTo;

	private String lateDateFrom;

	// 完税状态
	private String taxState;

	// 创建日期
	private Date createdAt;

	// 创建人
	private Long createdBy;

	// 修改时间
	private Date updatedAt;

	// 修改人
	private Long updatedBy;

	/** ?? 编号id,???? ag_po_quotation_tax.id */
	@Id
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name="id")
	public Long getId(){
		return this.id;
	}
	/** ?? 编号id,???? ag_po_quotation_tax.id */
	public void setId(Long id){
		this.id = id;
	}
	/** ?? 报价单编号id,???? ag_po_quotation_tax.quotation_id */
	@Column(name="quotation_id")
	public Long getQuotationId(){
		return this.quotationId;
	}
	/** ?? 报价单编号id,???? ag_po_quotation_tax.quotation_id */
	public void setQuotationId(Long quotationId){
		this.quotationId = quotationId;
	}
	/** ?? 车辆id,???? ag_po_quotation_tax.quotation_vehicle_id */
	@Column(name="quotation_vehicle_id")
	public Long getQuotationVehicleId(){
		return this.quotationVehicleId;
	}
	/** ?? 车辆id,???? ag_po_quotation_tax.quotation_vehicle_id */
	public void setQuotationVehicleId(Long quotationVehicleId){
		this.quotationVehicleId = quotationVehicleId;
	}
	/** ?? 车船税类型编码,???? ag_po_quotation_tax.veh_kind */
	@Column(name="veh_kind")
	public String getVehKind(){
		return this.vehKind;
	}
	/** ?? 车船税类型编码,???? ag_po_quotation_tax.veh_kind */
	public void setVehKind(String vehKind){
		this.vehKind = vehKind;
	}
	/** ?? 完税人,???? ag_po_quotation_tax.payer_name */
	@Column(name="payer_name")
	public String getPayerName(){
		return this.payerName;
	}
	/** ?? 完税人,???? ag_po_quotation_tax.payer_name */
	public void setPayerName(String payerName){
		this.payerName = payerName;
	}
	/** ?? 电话,???? ag_po_quotation_tax.telephone */
	@Column(name="telephone")
	public String getTelephone(){
		return this.telephone;
	}
	/** ?? 电话,???? ag_po_quotation_tax.telephone */
	public void setTelephone(String telephone){
		this.telephone = telephone;
	}
	@Column(name="tax_amount")
	public BigDecimal getTaxAmount(){
		return this.taxAmount;
	}
	public void setTaxAmount(BigDecimal taxAmount){
		this.taxAmount = taxAmount;
	}
	@Column(name="tax_payer")
	public String getTaxPayer(){
		return this.taxPayer;
	}
	public void setTaxPayer(String taxPayer){
		this.taxPayer = taxPayer;
	}
	/** ?? 支付状态0：支付，-1未支付,???? ag_po_quotation_tax.tax_payable */
	@Column(name="tax_payable")
	public Integer getTaxPayable(){
		return this.taxPayable;
	}
	/** ?? 支付状态0：支付，-1未支付,???? ag_po_quotation_tax.tax_payable */
	public void setTaxPayable(Integer taxPayable){
		this.taxPayable = taxPayable;
	}
	/** ?? 是否是个人,???? ag_po_quotation_tax.is_person */
	@Column(name="is_person")
	public Integer getIsPerson(){
		return this.isPerson;
	}
	/** ?? 是否是个人,???? ag_po_quotation_tax.is_person */
	public void setIsPerson(Integer isPerson){
		this.isPerson = isPerson;
	}
	/** ?? 证件类型,???? ag_po_quotation_tax.cert_type */
	@Column(name="cert_type")
	public String getCertType(){
		return this.certType;
	}
	/** ?? 证件类型,???? ag_po_quotation_tax.cert_type */
	public void setCertType(String certType){
		this.certType = certType;
	}
	/** ?? 证件号码,???? ag_po_quotation_tax.cert_code */
	@Column(name="cert_code")
	public String getCertCode(){
		return this.certCode;
	}
	/** ?? 证件号码,???? ag_po_quotation_tax.cert_code */
	public void setCertCode(String certCode){
		this.certCode = certCode;
	}
	/** ?? 地址,???? ag_po_quotation_tax.reg_addr */
	@Column(name="reg_addr")
	public String getRegAddr(){
		return this.regAddr;
	}
	/** ?? 地址,???? ag_po_quotation_tax.reg_addr */
	public void setRegAddr(String regAddr){
		this.regAddr = regAddr;
	}
	/** ?? 承载量,???? ag_po_quotation_tax.load_capicity */
	@Column(name="load_capicity")
	public String getLoadCapicity(){
		return this.loadCapicity;
	}
	/** ?? 承载量,???? ag_po_quotation_tax.load_capicity */
	public void setLoadCapicity(String loadCapicity){
		this.loadCapicity = loadCapicity;
	}
	/** ?? 税款所属期起,???? ag_po_quotation_tax.start_date */
	@Column(name="start_date")
	public Date getStartDate(){
		return this.startDate;
	}
	/** ?? 税款所属期起,???? ag_po_quotation_tax.start_date */
	public void setStartDate(Date startDate){
		this.startDate = startDate;
	}
	/** ?? 税款所属期止,???? ag_po_quotation_tax.end_date */
	@Column(name="end_date")
	public Date getEndDate(){
		return this.endDate;
	}
	/** ?? 税款所属期止,???? ag_po_quotation_tax.end_date */
	public void setEndDate(Date endDate){
		this.endDate = endDate;
	}
	@Column(name="back_date_from")
	public String getBackDateFrom(){
		return this.backDateFrom;
	}
	public void setBackDateFrom(String backDateFrom){
		this.backDateFrom = backDateFrom;
	}
	@Column(name="back_date_to")
	public String getBackDateTo(){
		return this.backDateTo;
	}
	public void setBackDateTo(String backDateTo){
		this.backDateTo = backDateTo;
	}
	@Column(name="late_date_to")
	public String getLateDateTo(){
		return this.lateDateTo;
	}
	public void setLateDateTo(String lateDateTo){
		this.lateDateTo = lateDateTo;
	}
	@Column(name="late_date_from")
	public String getLateDateFrom(){
		return this.lateDateFrom;
	}
	public void setLateDateFrom(String lateDateFrom){
		this.lateDateFrom = lateDateFrom;
	}
	/** ?? 完税状态,???? ag_po_quotation_tax.tax_state */
	@Column(name="tax_state")
	public String getTaxState(){
		return this.taxState;
	}
	/** ?? 完税状态,???? ag_po_quotation_tax.tax_state */
	public void setTaxState(String taxState){
		this.taxState = taxState;
	}
	/** ?? 创建日期,???? ag_po_quotation_tax.created_at */
	@Column(name="created_at")
	public Date getCreatedAt(){
		return this.createdAt;
	}
	/** ?? 创建日期,???? ag_po_quotation_tax.created_at */
	public void setCreatedAt(Date createdAt){
		this.createdAt = createdAt;
	}
	/** ?? 创建人,???? ag_po_quotation_tax.created_by */
	@Column(name="created_by")
	public Long getCreatedBy(){
		return this.createdBy;
	}
	/** ?? 创建人,???? ag_po_quotation_tax.created_by */
	public void setCreatedBy(Long createdBy){
		this.createdBy = createdBy;
	}
	/** ?? 修改时间,???? ag_po_quotation_tax.updated_at */
	@Column(name="updated_at")
	public Date getUpdatedAt(){
		return this.updatedAt;
	}
	/** ?? 修改时间,???? ag_po_quotation_tax.updated_at */
	public void setUpdatedAt(Date updatedAt){
		this.updatedAt = updatedAt;
	}
	/** ?? 修改人,???? ag_po_quotation_tax.updated_by */
	@Column(name="updated_by")
	public Long getUpdatedBy(){
		return this.updatedBy;
	}
	/** ?? 修改人,???? ag_po_quotation_tax.updated_by */
	public void setUpdatedBy(Long updatedBy){
		this.updatedBy = updatedBy;
	}
}