package com.ajb.car.quotation.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.apimessage.AgTransVehicleMsgOrigin;
import com.ajb.car.quotation.repositories.AgTransVehicleMsgOriginRepository;
import com.ajb.car.quotation.service.AgTransVehicleMsgOriginService;

@Service("agTransVehicleMsgOriginService")
public class AgTransVehicleMsgOriginServiceImpl implements AgTransVehicleMsgOriginService{
	@Autowired
	private AgTransVehicleMsgOriginRepository agTransVehicleMsgOriginRepo;

	public AgTransVehicleMsgOrigin save(AgTransVehicleMsgOrigin obj){
		return agTransVehicleMsgOriginRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agTransVehicleMsgOriginRepo.delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgTransVehicleMsgOrigin update(AgTransVehicleMsgOrigin obj) {
		return agTransVehicleMsgOriginRepo.saveAndFlush(obj);
	}

	public AgTransVehicleMsgOrigin findById(Long id){
		return agTransVehicleMsgOriginRepo.findOne(id);
	}
	
	public Page<AgTransVehicleMsgOrigin> findByObjPageable(AgTransVehicleMsgOrigin obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgTransVehicleMsgOrigin> ex = Example.of(obj, matcher); 
		return agTransVehicleMsgOriginRepo.findAll(ex,pageable);
	}
	
	public List<AgTransVehicleMsgOrigin> findByObjSortable(AgTransVehicleMsgOrigin obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgTransVehicleMsgOrigin> ex = Example.of(obj, matcher); 
		return agTransVehicleMsgOriginRepo.findAll(ex,sort);
	}
}