package com.ajb.car.vo.common;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/***
 * 返回结果封装
 * 
 * @author fan
 *
 */
public class JsonResult implements Serializable {
	private static final long serialVersionUID = 1L;
	private boolean success;
	private String message;
	private Object data;

	public  JsonResult(){}
	
	public  JsonResult(boolean success,String msg,Object data){
		this.success=success;
		this.message=msg;
		this.data=data;
	}
	
	public  JsonResult(boolean success,String msg){
		this.success=success;
		this.message=msg;
		this.data=null;
	}
	
	private JsonResult(String msg, Object data) {
		this.message=msg;
		this.success=true;
		this.data=data;
	}

	public Object getData() {
		return data;
	}

	public String getMessage() {
		return message;
	}

	public boolean isSuccess() {
		return success;
	}

	public  JsonResult ofSuccess(String msg, Object data) {
		return  new JsonResult(msg, data) ;
	}
	
	public void setData(Object data) {
		this.data = data;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public void setSuccess(boolean success) {
		this.success = success;
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void addResult(Object responseVO){
		Class c = responseVO.getClass();
		Method getMethod = null;
		try {
			Class[] classArr = null;
			getMethod = c.getMethod("getCommonResult", classArr);
		} catch (NoSuchMethodException | SecurityException e1) {
			e1.printStackTrace();
		}

		CommonResult commonResult = null;
		if(getMethod != null){
			try {
				Object[] objectArr = null;
				commonResult = (CommonResult)getMethod.invoke(responseVO, objectArr);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
				e.printStackTrace();
			}
		}
		if(commonResult != null){
			this.success = commonResult.isSuccess();
			this.message = commonResult.getMessage();
		}else{
			this.success = false;
			this.message = "未知异常！";
		}
		
		Method setMethod = null;
		try {
			setMethod = c.getMethod("setCommonResult", CommonResult.class);
		} catch (NoSuchMethodException | SecurityException e) {
			e.printStackTrace();
		}
		if(setMethod != null){
			CommonResult args = null;
			try {
				setMethod.invoke(responseVO, args);
			} catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
}
