package com.ajb.car.metadata.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.meta.AgMdCodeType;
import com.ajb.car.metadata.repositories.AgMdCodeTypeRepository;
import com.ajb.car.metadata.service.AgMdCodeTypeService;

@Service("agMdCodeTypeService")
public class AgMdCodeTypeServiceImpl implements AgMdCodeTypeService{
	@Autowired
	private AgMdCodeTypeRepository agMdCodeTypeRepo;

	public AgMdCodeType save(AgMdCodeType obj){
		return agMdCodeTypeRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agMdCodeTypeRepo .delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgMdCodeType update(AgMdCodeType obj) {
		return agMdCodeTypeRepo.saveAndFlush(obj);
	}

	public AgMdCodeType findById(Long id){
		return agMdCodeTypeRepo.findOne(id);
	}
	
	public Page<AgMdCodeType> findByObjPageable(AgMdCodeType obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgMdCodeType> ex = Example.of(obj, matcher); 
		return agMdCodeTypeRepo.findAll(ex,pageable);
	}
	
	public List<AgMdCodeType> findByObjSortable(AgMdCodeType obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgMdCodeType> ex = Example.of(obj, matcher); 
		return agMdCodeTypeRepo.findAll(ex,sort);
	}
}