package com.ajb.global.authorize;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.ajb.global.authorize.service.AuthorizeService;
import com.ajb.global.authorize.vo.CheckTokenRequestVO;
import com.ajb.car.vo.common.JsonResult;
import com.ajb.global.authorize.vo.CheckTokenResponseVO;
import com.ajb.global.authorize.vo.ObtainTokenRequestVO;
import com.ajb.global.authorize.vo.ObtainTokenResponseVO;

@RestController
@RequestMapping("/authorize")
public class AuthorizeController {
	@Autowired
	private AuthorizeService authorizeService;
	
	@RequestMapping("/obtainToken")
	public Object obtainToken(@RequestBody ObtainTokenRequestVO requestVO){
		JsonResult result = new JsonResult();
		ObtainTokenResponseVO responseVO = authorizeService.obtainToken(requestVO);

		result.setData(responseVO);
		return result;
	}
	
	@RequestMapping("/checkToken")
	public Object checkToken(@RequestBody CheckTokenRequestVO requestVO){
		JsonResult result = new JsonResult();
		CheckTokenResponseVO responseVO = authorizeService.checkToken(requestVO);

		result.setData(responseVO);
		return result;
	}

}
