package com.ajb.web.quotation.impl;

import java.math.BigDecimal;
import java.util.Date;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ajb.car.entity.quotation.AgPoQuotation;
import com.ajb.car.entity.quotation.AgPoQuotationConfirm;
import com.ajb.car.entity.quotation.AgPoQuotationCover;
import com.ajb.car.entity.quotation.AgPoQuotationTax;
import com.ajb.car.entity.quotation.AgPoQuotationVehicle;
import com.ajb.car.entity.quotation.AgPoQuotationVehicleRelation;
import com.ajb.car.quotation.service.AgPoQuotationService;
import com.ajb.car.quotation.service.AgPoQuotationTaxService;
import com.ajb.car.quotation.service.AgPoQuotationConfirmService;
import com.ajb.car.quotation.service.AgPoQuotationVehicleService;
import com.ajb.car.quotation.service.AgPoQuotationCoverService;
import com.ajb.car.quotation.service.AgPoQuotationVehicleRelationService;
import com.ajb.car.vo.quotation.AgPoQuotationRequestVO;
import com.ajb.car.vo.zhima.quotation.Applicant;
import com.ajb.car.vo.zhima.quotation.Claimant;
import com.ajb.car.vo.zhima.quotation.ConfirmInfo;

import com.ajb.car.vo.zhima.quotation.Priceinfo;
import com.ajb.car.vo.zhima.quotation.TcCoverages;

import com.ajb.car.vo.zhima.quotation.VehInfo;
import com.ajb.car.vo.zhima.quotation.VsltaxInfo;
import com.ajb.web.quotation.AgPoQuotationWebService;

@Service("agPoQuotationWebService")
public class AgPoQuotationWebServiceImpl implements AgPoQuotationWebService {

	@Autowired
	private AgPoQuotationService agPoQuotationService;
	
	@Autowired
	private AgPoQuotationVehicleService agPoQuotationVehicleService;
	
	@Autowired
	AgPoQuotationConfirmService agPoQuotationConfirmService;
	
	@Autowired
	AgPoQuotationTaxService agPoQuotationTaxService;
	
	@Autowired
	AgPoQuotationCoverService	agPoQuotationCoverService;
	
	@Autowired
	AgPoQuotationVehicleRelationService agPoQuotationVehicleRelationService;
	
	@Transactional
	@Override
	public void saveAgPoQuotationAndConfirm(Date quotationDate,Priceinfo priceinfo,ConfirmInfo confirmInfo) {
		//车辆，保险范围，申请人，受益人
		AgPoQuotation quotation = saveAgPoQuotationNoTrans(quotationDate,priceinfo);
		
		//保存确认单
		saveAgPoQuotationConfirmNoTrans(confirmInfo,quotation);	
		
		//保存确认单
		saveAgPoQuotationVehicleTaxNoTrans(priceinfo.getVsltaxInfo(),priceinfo.getVsltax(),quotation);	
	}
	
	@Transactional
	@Override
	public AgPoQuotation saveAgPoQuotation(Date quotationDate,Priceinfo priceinfo) {
		return saveAgPoQuotationNoTrans(quotationDate,priceinfo);
	}
	
	private AgPoQuotation saveAgPoQuotationNoTrans(Date quotationDate,Priceinfo priceinfo) {		
		Long quotationVehicleId = 0L;
		//保存车辆信息
		//TODO如果存在直接取回，先check exist
		AgPoQuotationVehicle agPoQuotationVehicle = new AgPoQuotationVehicle();
		agPoQuotationVehicle = initAgPoQuotationVehicleData(priceinfo.getVehInfo());
		agPoQuotationVehicle = agPoQuotationVehicleService.save(agPoQuotationVehicle);
		quotationVehicleId = agPoQuotationVehicle.getId();
		//保存quotation
		AgPoQuotation agPoQuotation = new AgPoQuotation();
		agPoQuotation = AgPoQuotationConverter.initAgPoQuotationData(priceinfo,quotationVehicleId);
		agPoQuotation = agPoQuotationService.save(agPoQuotation);
		agPoQuotation.setQuoteVersion(quotationDate);
		
		Long quotationId = agPoQuotation.getId();
		
		//保存商业险
		//保存交强险
		saveAgPoQuotationCoveragesData(priceinfo,quotationId,quotationVehicleId);		
		
		//申请人
		AgPoQuotationVehicleRelation agPoQuotationVehicleRelation = new AgPoQuotationVehicleRelation();
		agPoQuotationVehicleRelation = initAgPoQuotationVehicleRelationApplicantData(priceinfo.getApplicant(),quotationId);
		
		agPoQuotationVehicleRelationService.save(agPoQuotationVehicleRelation);
		//收益人
		agPoQuotationVehicleRelation = new AgPoQuotationVehicleRelation();
		agPoQuotationVehicleRelation = initAgPoQuotationVehicleRelationClaimantData(priceinfo.getClaimant(),quotationId);
		
		agPoQuotationVehicleRelationService.save(agPoQuotationVehicleRelation);
		
		return agPoQuotation;
	}
	private AgPoQuotationVehicleRelation initAgPoQuotationVehicleRelationApplicantData(Applicant applicant,Long quotationId)
	{
		AgPoQuotationVehicleRelation agPoQuotationVehicleRelation = new AgPoQuotationVehicleRelation();
		agPoQuotationVehicleRelation.setQuotationId(quotationId);
		agPoQuotationVehicleRelation.setName(applicant.getName());
		agPoQuotationVehicleRelation.setIdNo(applicant.getCertCode());
		agPoQuotationVehicleRelation.setIdType(1L);
		agPoQuotationVehicleRelation.setIdTypeName(applicant.getCertType());
		agPoQuotationVehicleRelation.setAddress(applicant.getAddress());
		agPoQuotationVehicleRelation.setTelephone(applicant.getTel());
		agPoQuotationVehicleRelation.setNationality(applicant.getNatureType());
		agPoQuotationVehicleRelation.setVehicleRelationId(1L);
		agPoQuotationVehicleRelation.setCreatedAt(new Date());
		agPoQuotationVehicleRelation.setCreatedBy(-1L);
		agPoQuotationVehicleRelation.setCustomerId(-1L);
		return agPoQuotationVehicleRelation;
	}
	private AgPoQuotationVehicleRelation initAgPoQuotationVehicleRelationClaimantData(Claimant claimant,Long quotationId)
	{
		AgPoQuotationVehicleRelation agPoQuotationVehicleRelation = new AgPoQuotationVehicleRelation();
		agPoQuotationVehicleRelation.setQuotationId(quotationId);
		agPoQuotationVehicleRelation.setName(claimant.getName());
		agPoQuotationVehicleRelation.setIdNo(claimant.getCertCode());
		agPoQuotationVehicleRelation.setIdType(1L);
		agPoQuotationVehicleRelation.setIdTypeName(claimant.getCertType());
		agPoQuotationVehicleRelation.setAddress(claimant.getAddress());
		agPoQuotationVehicleRelation.setTelephone(claimant.getTel());
		agPoQuotationVehicleRelation.setNationality(claimant.getNatureType());
		agPoQuotationVehicleRelation.setVehicleRelationId(5L);
		agPoQuotationVehicleRelation.setCreatedAt(new Date());
		agPoQuotationVehicleRelation.setCreatedBy(-1L);
		agPoQuotationVehicleRelation.setCustomerId(-1L);
		return agPoQuotationVehicleRelation;
	}
	private void saveAgPoQuotationCoveragesData(Priceinfo priceinfo,Long quotationId,Long quotationVehicleId)
	{
		AgPoQuotationCover agPoQuotationCover = null;
		//商业险--车损
		if (priceinfo.getBzCoverages().getDamageLossCoverage()!=null)
		{
			agPoQuotationCover = new AgPoQuotationCover();
			agPoQuotationCover.setCount(priceinfo.getBzCoverages().getDamageLossCoverage().getCount());
			agPoQuotationCover.setCoverAmount(priceinfo.getBzCoverages().getDamageLossCoverage().getSumInsured());
			agPoQuotationCover.setCoverName("机动车损失保险");
			//agPoQuotationCover.setDiscountRate(priceinfo.getBzCoverages().getDamageLossCoverage().get);
			agPoQuotationCover.setFloatingRate(BigDecimal.valueOf(priceinfo.getBzCoverages().getDamageLossCoverage().getFloatingRate()));
			agPoQuotationCover.setPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getDamageLossCoverage().getPolicyPremium()));
			agPoQuotationCover.setStandardPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getDamageLossCoverage().getStandardPremium()));
			//agPoQuotationCover.setTax(priceinfo.getBzCoverages().getDamageLossCoverage().get);
			agPoQuotationCover.setQuotationId(quotationId);
			agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
			agPoQuotationCover.setVehicleClauseId(1L);
			agPoQuotationCover.setClauseCategory("M");
			agPoQuotationCover.setClauseCode(priceinfo.getBzCoverages().getDamageLossCoverage().getKind());
			agPoQuotationCover.setClauseDescription("机动车损失保险");
			agPoQuotationCover.setCreatedAt(new Date());
			agPoQuotationCover.setCreatedBy(-1L);
			
			System.out.println("机动车损失保险getPremium," + agPoQuotationCover.getPremium());
			
			agPoQuotationCoverService.save(agPoQuotationCover);
		}
		
		//交强险
		if (priceinfo.getTcCoverages()!=null)
		{
			agPoQuotationCover = new AgPoQuotationCover();
			agPoQuotationCover = initAgPoQuotationTcCoveragesData(priceinfo.getTcCoverages(),quotationId,quotationVehicleId);
			agPoQuotationCover.setCreatedAt(new Date());
			agPoQuotationCover.setCreatedBy(-1L);
			
			System.out.println("交强险getPremium," + agPoQuotationCover.getPremium());
			
			agPoQuotationCoverService.save(agPoQuotationCover);
		}
		
		//商业险--车身划痕损失险	
		if (priceinfo.getBzCoverages().getCarBodyPaintCoverage()!=null)
		{
			agPoQuotationCover = new AgPoQuotationCover();
			agPoQuotationCover.setCount(priceinfo.getBzCoverages().getCarBodyPaintCoverage().getCount());
			agPoQuotationCover.setCoverAmount(priceinfo.getBzCoverages().getCarBodyPaintCoverage().getSumInsured());
			agPoQuotationCover.setCoverName("车身划痕损失险");
			//agPoQuotationCover.setDiscountRate(priceinfo.getBzCoverages().getCarBodyPaintCoverage().get);
			agPoQuotationCover.setFloatingRate(BigDecimal.valueOf(priceinfo.getBzCoverages().getCarBodyPaintCoverage().getFloatingRate()));
			agPoQuotationCover.setPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getCarBodyPaintCoverage().getPolicyPremium()));
			agPoQuotationCover.setStandardPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getCarBodyPaintCoverage().getStandardPremium()));
			//agPoQuotationCover.setTax(priceinfo.getBzCoverages().getCarBodyPaintCoverage().get);
			agPoQuotationCover.setQuotationId(quotationId);
			agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
			agPoQuotationCover.setVehicleClauseId(7L);
			agPoQuotationCover.setClauseCategory("M");
			agPoQuotationCover.setClauseCode(priceinfo.getBzCoverages().getCarBodyPaintCoverage().getKind());
			agPoQuotationCover.setClauseDescription("车身划痕损失险");	
			agPoQuotationCover.setCreatedAt(new Date());
			agPoQuotationCover.setCreatedBy(-1L);
			System.out.println("车身划痕损失险getPremium," + agPoQuotationCover.getPremium());
			agPoQuotationCoverService.save(agPoQuotationCover);
		}
		
		//商业险--车漆面三则免赔
		if (priceinfo.getBzCoverages().getCarBodyPaintExemptDeductibleSpecialClause()!=null)
		{
			agPoQuotationCover = new AgPoQuotationCover();
			agPoQuotationCover.setCount(priceinfo.getBzCoverages().getCarBodyPaintExemptDeductibleSpecialClause().getCount());
			agPoQuotationCover.setCoverAmount(priceinfo.getBzCoverages().getCarBodyPaintExemptDeductibleSpecialClause().getSumInsured());
			agPoQuotationCover.setCoverName("车身划痕损失险免赔");
			//agPoQuotationCover.setDiscountRate(priceinfo.getBzCoverages().getCarBodyPaintCoverage().get);
			agPoQuotationCover.setFloatingRate(BigDecimal.valueOf(priceinfo.getBzCoverages().getCarBodyPaintExemptDeductibleSpecialClause().getFloatingRate()));
			agPoQuotationCover.setPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getCarBodyPaintExemptDeductibleSpecialClause().getPolicyPremium()));
			agPoQuotationCover.setStandardPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getCarBodyPaintExemptDeductibleSpecialClause().getStandardPremium()));
			//agPoQuotationCover.setTax(priceinfo.getBzCoverages().getCarBodyPaintExemptDeductibleSpecialClause().get);
			agPoQuotationCover.setQuotationId(quotationId);
			agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
			agPoQuotationCover.setVehicleClauseId(7L);
			agPoQuotationCover.setClauseCategory("A");
			agPoQuotationCover.setClauseCode(priceinfo.getBzCoverages().getCarBodyPaintExemptDeductibleSpecialClause().getKind());
			agPoQuotationCover.setClauseDescription("车身划痕损失险免赔");
			agPoQuotationCover.setCreatedAt(new Date());
			agPoQuotationCover.setCreatedBy(-1L);
			System.out.println("车身划痕损失险免赔getPremium," + agPoQuotationCover.getPremium());
			agPoQuotationCoverService.save(agPoQuotationCover);
		}

		//商业险--不计免赔率险
		if (priceinfo.getBzCoverages().getDamageLossExemptDeductibleSpecialClause()!=null)
		{
			agPoQuotationCover = new AgPoQuotationCover();
			agPoQuotationCover.setCount(priceinfo.getBzCoverages().getDamageLossExemptDeductibleSpecialClause().getCount());
			agPoQuotationCover.setCoverAmount(priceinfo.getBzCoverages().getDamageLossExemptDeductibleSpecialClause().getSumInsured());
			agPoQuotationCover.setCoverName("机动车损失不计免赔保险");
			//agPoQuotationCover.setDiscountRate(priceinfo.getBzCoverages().getDamageLossExemptDeductibleSpecialClause().get);
			agPoQuotationCover.setFloatingRate(BigDecimal.valueOf(priceinfo.getBzCoverages().getDamageLossExemptDeductibleSpecialClause().getFloatingRate()));
			agPoQuotationCover.setPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getDamageLossExemptDeductibleSpecialClause().getPolicyPremium()));
			agPoQuotationCover.setStandardPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getDamageLossExemptDeductibleSpecialClause().getStandardPremium()));
			//agPoQuotationCover.setTax(priceinfo.getBzCoverages().getDamageLossExemptDeductibleSpecialClause().get);
			agPoQuotationCover.setQuotationId(quotationId);
			agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
			agPoQuotationCover.setVehicleClauseId(6L);
			agPoQuotationCover.setClauseCategory("A");
			agPoQuotationCover.setClauseCode(priceinfo.getBzCoverages().getDamageLossExemptDeductibleSpecialClause().getKind());
			agPoQuotationCover.setClauseDescription("机动车损失不计免赔保险");	
			agPoQuotationCover.setCreatedAt(new Date());
			agPoQuotationCover.setCreatedBy(-1L);
			System.out.println("机动车损失不计免赔保险getPremium," + agPoQuotationCover.getPremium());
			agPoQuotationCoverService.save(agPoQuotationCover);
		}
		//商业险--第三者责任险
		if (priceinfo.getBzCoverages().getThirdPartyLiabilityCoverage()!=null)
		{
			agPoQuotationCover = new AgPoQuotationCover();
			agPoQuotationCover.setCount(priceinfo.getBzCoverages().getThirdPartyLiabilityCoverage().getCount());
			agPoQuotationCover.setCoverAmount(priceinfo.getBzCoverages().getThirdPartyLiabilityCoverage().getSumInsured());
			agPoQuotationCover.setCoverName("机动车第三者责任保险");
			//agPoQuotationCover.setDiscountRate(priceinfo.getBzCoverages().getThirdPartyLiabilityCoverage().get);
			agPoQuotationCover.setFloatingRate(BigDecimal.valueOf(priceinfo.getBzCoverages().getThirdPartyLiabilityCoverage().getFloatingRate()));
			agPoQuotationCover.setPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getThirdPartyLiabilityCoverage().getPolicyPremium()));
			agPoQuotationCover.setStandardPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getThirdPartyLiabilityCoverage().getStandardPremium()));
			//agPoQuotationCover.setTax(priceinfo.getBzCoverages().getThirdPartyLiabilityCoverage().get);
			agPoQuotationCover.setQuotationId(quotationId);
			agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
			agPoQuotationCover.setClauseCategory("M");
			agPoQuotationCover.setVehicleClauseId(2L);
			agPoQuotationCover.setClauseCode(priceinfo.getBzCoverages().getThirdPartyLiabilityCoverage().getKind());
			agPoQuotationCover.setClauseDescription("机动车第三者责任保险");	
			agPoQuotationCover.setCreatedAt(new Date());
			agPoQuotationCover.setCreatedBy(-1L);
			System.out.println("机动车第三者责任保险getPremium," + agPoQuotationCover.getPremium());
			agPoQuotationCoverService.save(agPoQuotationCover);
		}
		//商业险--第三者责任险免赔
		if (priceinfo.getBzCoverages().getThirdPartyLiabilityExemptDeductibleSpecialClause()!=null)
		{
			agPoQuotationCover = new AgPoQuotationCover();
			agPoQuotationCover.setCount(priceinfo.getBzCoverages().getThirdPartyLiabilityExemptDeductibleSpecialClause().getCount());
			agPoQuotationCover.setCoverAmount(priceinfo.getBzCoverages().getThirdPartyLiabilityExemptDeductibleSpecialClause().getSumInsured());
			agPoQuotationCover.setCoverName("机动车第三者责任保险");
			//agPoQuotationCover.setDiscountRate(priceinfo.getBzCoverages().getThirdPartyLiabilityExemptDeductibleSpecialClause().get);
			agPoQuotationCover.setFloatingRate(BigDecimal.valueOf(priceinfo.getBzCoverages().getThirdPartyLiabilityExemptDeductibleSpecialClause().getFloatingRate()));
			agPoQuotationCover.setPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getThirdPartyLiabilityExemptDeductibleSpecialClause().getPolicyPremium()));
			agPoQuotationCover.setStandardPremium(BigDecimal.valueOf(priceinfo.getBzCoverages().getThirdPartyLiabilityExemptDeductibleSpecialClause().getStandardPremium()));
			//agPoQuotationCover.setTax(priceinfo.getBzCoverages().getThirdPartyLiabilityExemptDeductibleSpecialClause().get);
			agPoQuotationCover.setQuotationId(quotationId);
			agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
			agPoQuotationCover.setVehicleClauseId(2L);
			agPoQuotationCover.setClauseCategory("A");
			agPoQuotationCover.setClauseCode(priceinfo.getBzCoverages().getThirdPartyLiabilityExemptDeductibleSpecialClause().getKind());
			agPoQuotationCover.setClauseDescription("机动车第三者责任不计免赔率险");	
			agPoQuotationCover.setCreatedAt(new Date());
			agPoQuotationCover.setCreatedBy(-1L);
			System.out.println("机动车第三者责任不计免赔率险getPremium," + agPoQuotationCover.getPremium());
			agPoQuotationCoverService.save(agPoQuotationCover);
		}
	}
	
	private AgPoQuotationCover initAgPoQuotationTcCoveragesData(TcCoverages tcCoverages,Long quotationId,Long quotationVehicleId)
	{
		AgPoQuotationCover agPoQuotationCover = new AgPoQuotationCover();
		BeanUtils.copyProperties(tcCoverages.getTRAFFICCOMPULSORYPRODUCT(),agPoQuotationCover);
		agPoQuotationCover.setCount(tcCoverages.getTRAFFICCOMPULSORYPRODUCT().getCount());
		agPoQuotationCover.setCoverAmount(tcCoverages.getTRAFFICCOMPULSORYPRODUCT().getSumInsured());
		agPoQuotationCover.setCoverName("交通强制险");
		//agPoQuotationCover.setDiscountRate(tcCoverages.getTRAFFICCOMPULSORYPRODUCT().get);
		agPoQuotationCover.setFloatingRate(BigDecimal.valueOf(tcCoverages.getTRAFFICCOMPULSORYPRODUCT().getFloatingRate()));
		agPoQuotationCover.setPremium(BigDecimal.valueOf(tcCoverages.getTRAFFICCOMPULSORYPRODUCT().getPolicyPremium()));
		agPoQuotationCover.setStandardPremium(BigDecimal.valueOf(tcCoverages.getTRAFFICCOMPULSORYPRODUCT().getStandardPremium()));
		//agPoQuotationCover.setTax(tcCoverages.getTRAFFICCOMPULSORYPRODUCT().get);
		agPoQuotationCover.setQuotationId(quotationId);
		agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
		agPoQuotationCover.setVehicleClauseId(18L);
		agPoQuotationCover.setClauseCategory("T");
		agPoQuotationCover.setClauseCode(tcCoverages.getTRAFFICCOMPULSORYPRODUCT().getKind());
		agPoQuotationCover.setClauseDescription("交通强制险");
		agPoQuotationCover.setCreatedAt(new Date());
		agPoQuotationCover.setCreatedBy(-1L);
		
		return agPoQuotationCover;
	}
	
	private AgPoQuotationVehicle initAgPoQuotationVehicleData(VehInfo vehInfo)
	{
		AgPoQuotationVehicle agPoQuotationVehicle = new AgPoQuotationVehicle();
		BeanUtils.copyProperties(vehInfo, agPoQuotationVehicle);

		agPoQuotationVehicle.setIsNewCar(vehInfo.getIsNewCar());
	
		//agPoQuotationVehicle.vehInfo.getNewCarFlag();
		//agPoQuotationVehicle.vehInfo.getInsuranceFlag();
		agPoQuotationVehicle.setVehicleBrand(vehInfo.getModelNumber());
		agPoQuotationVehicle.setVehicleCode(vehInfo.getModelSerialCode());
		//车架号非空
		agPoQuotationVehicle.setFrameNumber(vehInfo.getFrameNumber());
		agPoQuotationVehicle.setLicenseType(vehInfo.getPlateType());
		//引擎号非空
		agPoQuotationVehicle.setEngineNo(vehInfo.getEngineNumber());
		//初登日期非空
		agPoQuotationVehicle.setFirstRegistrationDate(vehInfo.getFirstRegistrationDate());
		//车牌号非空
		agPoQuotationVehicle.setPlateNo(vehInfo.getRegistrationNumber());
		agPoQuotationVehicle.setVehicleCategory(vehInfo.getCategory());
		agPoQuotationVehicle.setOwner(vehInfo.getLicenseOwner());
		agPoQuotationVehicle.setOriginCertiType(vehInfo.getLicenseOwnerCertType());
		agPoQuotationVehicle.setOwnerCertiCode(vehInfo.getLicenseOwnerCertCode());
		agPoQuotationVehicle.setOwnerNature(vehInfo.getOwnerNature());
		agPoQuotationVehicle.setModelCharacterNumber(vehInfo.getModelCharacterNumber());
		//vehInfo.getAttribute;
		//vehInfo.getBizAttribute;
		//vehInfo.getBizCategory;
		agPoQuotationVehicle.setVehicleUseType(vehInfo.getUse());
		agPoQuotationVehicle.setPriceNewcar(vehInfo.getPurchasePrice());
		agPoQuotationVehicle.setReferencePrice(vehInfo.getKindPrice());
		agPoQuotationVehicle.setCurrentPrice(vehInfo.getCurrentValue());
		agPoQuotationVehicle.setSeatCapacity(vehInfo.getSeatCapacity());
		agPoQuotationVehicle.setCarryingCapacity(vehInfo.getCarryingCapacity());
		agPoQuotationVehicle.setFuelType(vehInfo.getGlassType());
		agPoQuotationVehicle.setDispacementPower(vehInfo.getEngineSize());
		agPoQuotationVehicle.setIsPayoffLoan(vehInfo.getLoanVehicleFlag());
		agPoQuotationVehicle.setBrandmakeModel(vehInfo.getBrand());
		agPoQuotationVehicle.setDriveArea(vehInfo.getDrivingArea());
		agPoQuotationVehicle.setDispacementPower(vehInfo.getVehiclePower());
		//vehInfo.getVehiclePowerJY;
		agPoQuotationVehicle.setFuelType(vehInfo.getFuelType());
		agPoQuotationVehicle.setIsTransfered(vehInfo.getSpecialCarFlag());
		agPoQuotationVehicle.setPurchaseInvoiceDate(vehInfo.getPurchaseinvoicesDate());
		agPoQuotationVehicle.setModelIdCode(vehInfo.getModelIdCode());
		agPoQuotationVehicle.setPlatformModelCode(vehInfo.getPlatformModelCode());
		agPoQuotationVehicle.setVehicleUseType(vehInfo.getVehicleUsageDetail());
		//agPoQuotationVehiclevehInfo.getIllegalNumLastYear;
		//agPoQuotationVehicle.setvehInfo.getTcDesignedAge;
		//vehInfo.getAnnualMileage;
		//vehInfo.getSpecvtype;
		//vehInfo.getInstalment;
		//vehInfo.getDesignedAge;
		//vehInfo.getDepreciatedExpireAge;
		agPoQuotationVehicle.setPlateColor(vehInfo.getPlateColor());
		//agPoQuotationVehicle.vehInfo.getManufacturer;
		agPoQuotationVehicle.setBodyColor(vehInfo.getBodyColor());
		//vehInfo.getProducePlaceType;
		agPoQuotationVehicle.setIndustryVehicleCode(vehInfo.getIndustryVehicleCode());
		agPoQuotationVehicle.setPlatformBrand(vehInfo.getPlatformBrand());
		agPoQuotationVehicle.setBrandCode(vehInfo.getBrandCode());
		//vehInfo.getSeries;
		//vehInfo.getSeriesCode;
		agPoQuotationVehicle.setCarName(vehInfo.getCarName());
		//vehInfo.getNoticeType;
		agPoQuotationVehicle.setTradeCode(vehInfo.getTradeCode());
		
		//agPoQuotationVehicle.setActualYearsUsed(vehInfo.get);
		agPoQuotationVehicle.setCreatedAt(new Date());
		agPoQuotationVehicle.setCreatedBy(-1L);
		return agPoQuotationVehicle;
	}
	private void saveAgPoQuotationConfirmNoTrans(ConfirmInfo confirmInfo, AgPoQuotation quotation) {
		// TODO Auto-generated method stub
		AgPoQuotationConfirm agPoQuotationConfirm = new AgPoQuotationConfirm();		
		agPoQuotationConfirm = initAgPoQuotationConfirmData(confirmInfo);
		agPoQuotationConfirm.setQuotationId(quotation.getId());
		agPoQuotationConfirm.setQuotationVehicleId(quotation.getQuoteVehicleId());
		agPoQuotationConfirmService.save(agPoQuotationConfirm);
	}
	private AgPoQuotationConfirm initAgPoQuotationConfirmData(ConfirmInfo confirmInfo)
	{
		AgPoQuotationConfirm agPoQuotationConfirm = new AgPoQuotationConfirm();
		BeanUtils.copyProperties(confirmInfo, agPoQuotationConfirm);
		agPoQuotationConfirm.setCreatedAt(new Date());
		agPoQuotationConfirm.setCreatedBy(-1L);
		return agPoQuotationConfirm;
	}
	private void saveAgPoQuotationVehicleTaxNoTrans(VsltaxInfo vsltaxInfo,Double taxAmount,AgPoQuotation quotation) {
		// TODO Auto-generated method stub
		AgPoQuotationTax agPoQuotationTax = new AgPoQuotationTax();	
		BeanUtils.copyProperties(vsltaxInfo, agPoQuotationTax);
		agPoQuotationTax.setTaxAmount(BigDecimal.valueOf(taxAmount));
		agPoQuotationTax.setQuotationId(quotation.getId());
		agPoQuotationTax.setQuotationVehicleId(quotation.getQuoteVehicleId());
		agPoQuotationTax.setCreatedAt(new Date());
		agPoQuotationTax.setCreatedBy(-1L);
		agPoQuotationTaxService.save(agPoQuotationTax);
	}
	@Transactional
	@Override
	public void saveAgPoQuotationConfirm(ConfirmInfo confirmInfo,AgPoQuotation quotation) {
		// TODO Auto-generated method stub
		saveAgPoQuotationConfirmNoTrans(confirmInfo,quotation);
	}

	@Override
	public AgPoQuotationRequestVO queryAgPoQuotation(Long quotationId) {		
		AgPoQuotationRequestVO agPoQuotationRequestVO = new AgPoQuotationRequestVO();
		AgPoQuotation agPoQuotation = agPoQuotationService.findById(quotationId);
		BeanUtils.copyProperties(agPoQuotation, agPoQuotationRequestVO);
		return agPoQuotationRequestVO;
		
		
	}
}