package com.ajb.global.config;

import java.util.Date;

import com.ajb.car.entity.apimessage.AgTransVehicleMsgOrigin;
import com.ajb.car.metadata.service.SystemConfigService;
import com.ajb.car.quotation.service.AgTransVehicleMsgOriginService;
import com.ajb.car.vo.zhima.TokenZhiMa;
import com.ajb.common.utils.http.HttpHelpZhiMa;
import com.ajb.common.utils.string.CommonUtil;
import com.alibaba.fastjson.JSON;

/**
 * 获取芝麻车险访问连接
 * @author Simon Cheng
 *
 */
public class ZhimaConnection {
	
	private static String auth2ParamProduction = "";
	private static String hostURL = "";
	private static String tokenMethod = "";
	private static String token = "";
	
	private static ZhimaConnection zhimaConnection = null;
	
	public static synchronized ZhimaConnection getInstance(){
		if (zhimaConnection == null)
		{
	        SystemConfigService systemConfigService = (SystemConfigService)SpringContextUtil.getBean("systemConfigService");
			
			zhimaConnection = new ZhimaConnection();
			auth2ParamProduction = systemConfigService.getSingleConfigValue("LinkerSoftAPITokenAuth2Param");
			hostURL = systemConfigService.getSingleConfigValue("LinkerSoftAPIHostURL");
			tokenMethod = systemConfigService.getSingleConfigValue("LinkerSoftAPITokenMethod");
		}
		return zhimaConnection;
	}

	public static String getAuth2ParamProduction() {
		getInstance();
		return auth2ParamProduction;
	}

	public static String getHostURL() {
		getInstance();
		return hostURL;
	}

	public static String getTokenMethod() {
		getInstance();
		return tokenMethod;
	}
	
	/**
	 * 获取芝麻API接口的token
	 * @param urlQuery
	 * @param queryParams
	 * @return
	 */
	private static TokenZhiMa getToken(String urlQuery,String queryParams)
	{
		TokenZhiMa returnToken = (TokenZhiMa)HttpHelpZhiMa.getToken(urlQuery,queryParams);
		return returnToken;
	}
	
	public static String getToken()
	{
		getInstance();
		if (CommonUtil.isNullOrBlank(token))
		{
			TokenZhiMa returnToken = (TokenZhiMa)getToken(hostURL + tokenMethod, auth2ParamProduction);
			
			token = returnToken.getDatas().getTokenInfo().getToken();
		}
		return token;
	}
	
	public static String refreshToken()
	{
		getInstance();
		TokenZhiMa returnToken = (TokenZhiMa)getToken(hostURL + tokenMethod, auth2ParamProduction);
		token = returnToken.getDatas().getTokenInfo().getToken();
		return token;
	}
	public static <T> T postUrlMap2JavaBean(String urlQuery,String queryParams, Class<T> beanClass)
	{
		T t = postUrlMap2JavaBean(urlQuery, queryParams,  getToken(), beanClass);
		return t;
	}
	public static <T> T postUrlMap2JavaBean(String urlQuery,String queryParams, String token,Class<T> beanClass)
	{
		T t = HttpHelpZhiMa.postUrlMap2JavaBean(urlQuery,queryParams,token,beanClass);
		//写原始消息入表
		AgTransVehicleMsgOrigin agtransvehiclemsgorigin = new AgTransVehicleMsgOrigin();				
		agtransvehiclemsgorigin = initOriginMessage(ZhimaConnection.getHostURL(),urlQuery,queryParams,"Post",JSON.toJSONString(t));
		AgTransVehicleMsgOriginService carZhiMaService = (AgTransVehicleMsgOriginService)SpringContextUtil.getBean("agTransVehicleMsgOriginService");
		carZhiMaService.save(agtransvehiclemsgorigin);
		return t;
	}
	public static <T> T getUrlMap2JavaBean(String urlQuery, Class<T> beanClass)
	{
		T t = getUrlMap2JavaBean(urlQuery,getToken(),beanClass);
		
		return t;
	}
	public static <T> T getUrlMap2JavaBean(String urlQuery, String token,Class<T> beanClass)
	{
		T t = HttpHelpZhiMa.getUrlMap2JavaBean(urlQuery,token,beanClass);
		//写原始消息入表
		AgTransVehicleMsgOrigin agtransvehiclemsgorigin = new AgTransVehicleMsgOrigin();				
		agtransvehiclemsgorigin = initOriginMessage(ZhimaConnection.getHostURL(),urlQuery,"","Get",JSON.toJSONString(t));
		AgTransVehicleMsgOriginService carZhiMaService = (AgTransVehicleMsgOriginService)SpringContextUtil.getBean("agTransVehicleMsgOriginService");
		carZhiMaService.save(agtransvehiclemsgorigin);
		return t;		
	}
	
	/**
	 * 记录请求log，初始化日志项
	 * @param requestHost
	 * @param requestMethod
	 * @param requestParams
	 * @param requestType
	 * @param responseMessage
	 * @return
	 */
	private static AgTransVehicleMsgOrigin initOriginMessage(final String requestHost,final String requestMethod,final String requestParams,final String requestType,final String responseMessage)
	{
		AgTransVehicleMsgOrigin agtransvehiclemsgorigin = new AgTransVehicleMsgOrigin();
		
		agtransvehiclemsgorigin.setQuoteProviderId(2L);
		agtransvehiclemsgorigin.setQuoteProviderType("V");
		agtransvehiclemsgorigin.setQuoteProvider("芝麻");
		agtransvehiclemsgorigin.setRequestHost(requestHost);
		agtransvehiclemsgorigin.setRequestParams(requestParams);
		agtransvehiclemsgorigin.setRequestMethod(requestMethod);
		agtransvehiclemsgorigin.setRequestType(requestType);
		agtransvehiclemsgorigin.setRequestDate(new Date());
		agtransvehiclemsgorigin.setUserId(36);
		agtransvehiclemsgorigin.setUserName("simon");
		agtransvehiclemsgorigin.setResponseMessage(responseMessage);
		
		return agtransvehiclemsgorigin;
	}
}
