package com.ajb.car.quotation.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.quotation.AgPoQuotationConfirm;
import com.ajb.car.quotation.repositories.AgPoQuotationConfirmRepository;
import com.ajb.car.quotation.service.AgPoQuotationConfirmService;

@Service("agPoQuotationConfirmService")
public class AgPoQuotationConfirmServiceImpl implements AgPoQuotationConfirmService{
	@Autowired
	private AgPoQuotationConfirmRepository agPoQuotationConfirmRepo;

	public AgPoQuotationConfirm save(AgPoQuotationConfirm obj){
		return agPoQuotationConfirmRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agPoQuotationConfirmRepo.delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgPoQuotationConfirm update(AgPoQuotationConfirm obj) {
		return agPoQuotationConfirmRepo.saveAndFlush(obj);
	}

	public AgPoQuotationConfirm findById(Long id){
		return agPoQuotationConfirmRepo.findOne(id);
	}
	
	public Page<AgPoQuotationConfirm> findByObjPageable(AgPoQuotationConfirm obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationConfirm> ex = Example.of(obj, matcher); 
		return agPoQuotationConfirmRepo.findAll(ex,pageable);
	}
	
	public List<AgPoQuotationConfirm> findByObjSortable(AgPoQuotationConfirm obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotationConfirm> ex = Example.of(obj, matcher); 
		return agPoQuotationConfirmRepo.findAll(ex,sort);
	}
}