package com.ajb.car.vo.quotation;

import java.util.Date;
import java.math.BigDecimal;

/**
  报价单表
*/

public class AgPoQuotationRequestVO implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private Long id;
	// 报价单号
	private String quoteNo;
	// 报价单
	private Date quoteVersion;
	// 报价车辆id, FK ag_po_quotation_vehicle.id
	private Long quoteVehicleId;
	// 1:YES=新保, 2:No=续保
	private Integer isRenewal;
	// 0:单商业,1:单交强,2:关联出单
	private Integer quoteType;
	// 0=open临时报价 1=confirm确认报价 2=completed保险公司确认 3=cancelled 4=overdue 9=error
	private Integer quoteStatus;
	// I=Insurer V=Vendor O=Other
	private String quoteProviderType;
	// FK ag_acl_insurer.id or ag_acl_vendor.id
	private Long quoteProviderId;
	// 请求报价客户id
	private Long customerId;
	// 车牌号
	private String plateNo;
	// 客户手机
	private String customerMobile;
	
	private String customerMobileMask;
	// 客户名称
	private String customerName;
	// 币种
	private String currency;
	// 总保费
	private BigDecimal totalPremium;
	// 总折扣金额
	private BigDecimal totalDiscount;
	// 总佣金
	private BigDecimal totalCharge;
	// 车船税
	private BigDecimal vehicleTax;
	// 交强险状态0 无报价1 正常报价2 无法报价

	private Integer compulsoryStatus;
	// 交强险报价信息说明
	private String compulsoryMessage;
	// 交强险保费
	private BigDecimal compulsoryPremium;
	// 交强险折扣金额
	private BigDecimal compulsoryDiscount;
	// 交强险期开始日期
	private Date compulsoryStart;
	// 交强险期截止日期
	private Date compulsoryEnd;
	// 交强险佣金
	private BigDecimal compulsoryCharge;
	// 商业险状态0 无报价1 正常报价2 无法报价

	private Integer businessInsuranceStatus;
	// 商业险报价信息说明
	private String businessInsuranceMessage;
	// 商业险保费
	private BigDecimal businessInsurancePremium;
	// 商业险费率
	private BigDecimal businessInsuranceFloatingRate;
	// 商业险折扣金额
	private BigDecimal businessInsuranceDiscount;
	// 商业险开始日期
	private Date businessInsuranceStart;
	// 商业险截止日期
	private Date businessInsuranceEnd;
	// 商业险佣金
	private BigDecimal businessInsuranceCharge;
	// 归属部门
	private String departmentBelong;
	// 归属人
	private String departmentBelonger;
	// 经办人
	private String operator;
	// 渠道代码
	private String channelCode;
	// 团单号
	private String groupNumber;
	// 出单机构
	private String issueAssociation;
	// 创建时间
	private Date createdAt;
	// 创建人
	private Long createdBy;
	// 修改时间
	private Date updatedAt;
	// 修改人
	private Long updatedBy;

	public void setId(Long id){
		this.id = id;
	}
	public Long getId(){
		return this.id;
	}

	/** ?? 报价单号,???? ag_po_quotation.quote_no */
	public void setQuoteNo(String quoteNo){
		this.quoteNo = quoteNo;
	}
	/** ?? 报价单号,???? ag_po_quotation.quote_no */
	public String getQuoteNo(){
		return this.quoteNo;
	}

	/** ?? 报价单,???? ag_po_quotation.quote_version */
	public void setQuoteVersion(Date quoteVersion){
		this.quoteVersion = quoteVersion;
	}
	/** ?? 报价单,???? ag_po_quotation.quote_version */
	public Date getQuoteVersion(){
		return this.quoteVersion;
	}

	/** ?? 报价车辆id, FK ag_po_quotation_vehicle.id,???? ag_po_quotation.quote_vehicle_id */
	public void setQuoteVehicleId(Long quoteVehicleId){
		this.quoteVehicleId = quoteVehicleId;
	}
	/** ?? 报价车辆id, FK ag_po_quotation_vehicle.id,???? ag_po_quotation.quote_vehicle_id */
	public Long getQuoteVehicleId(){
		return this.quoteVehicleId;
	}

	/** ?? 1:YES=新保, 2:No=续保,???? ag_po_quotation.is_renewal */
	public void setIsRenewal(Integer isRenewal){
		this.isRenewal = isRenewal;
	}
	/** ?? 1:YES=新保, 2:No=续保,???? ag_po_quotation.is_renewal */
	public Integer getIsRenewal(){
		return this.isRenewal;
	}

	/** ?? 0:单商业,1:单交强,2:关联出单,???? ag_po_quotation.quote_type */
	public void setQuoteType(Integer quoteType){
		this.quoteType = quoteType;
	}
	/** ?? 0:单商业,1:单交强,2:关联出单,???? ag_po_quotation.quote_type */
	public Integer getQuoteType(){
		return this.quoteType;
	}

	/** ?? 0=open临时报价 1=confirm确认报价 2=completed保险公司确认 3=cancelled 4=overdue 9=error,???? ag_po_quotation.quote_status */
	public void setQuoteStatus(Integer quoteStatus){
		this.quoteStatus = quoteStatus;
	}
	/** ?? 0=open临时报价 1=confirm确认报价 2=completed保险公司确认 3=cancelled 4=overdue 9=error,???? ag_po_quotation.quote_status */
	public Integer getQuoteStatus(){
		return this.quoteStatus;
	}

	/** ?? I=Insurer V=Vendor O=Other,???? ag_po_quotation.quote_provider_type */
	public void setQuoteProviderType(String quoteProviderType){
		this.quoteProviderType = quoteProviderType;
	}
	/** ?? I=Insurer V=Vendor O=Other,???? ag_po_quotation.quote_provider_type */
	public String getQuoteProviderType(){
		return this.quoteProviderType;
	}

	/** ?? FK ag_acl_insurer.id or ag_acl_vendor.id,???? ag_po_quotation.quote_provider_id */
	public void setQuoteProviderId(Long quoteProviderId){
		this.quoteProviderId = quoteProviderId;
	}
	/** ?? FK ag_acl_insurer.id or ag_acl_vendor.id,???? ag_po_quotation.quote_provider_id */
	public Long getQuoteProviderId(){
		return this.quoteProviderId;
	}

	/** ?? 请求报价客户id,???? ag_po_quotation.customer_id */
	public void setCustomerId(Long customerId){
		this.customerId = customerId;
	}
	/** ?? 请求报价客户id,???? ag_po_quotation.customer_id */
	public Long getCustomerId(){
		return this.customerId;
	}

	/** ?? 车牌号,???? ag_po_quotation.plate_no */
	public void setPlateNo(String plateNo){
		this.plateNo = plateNo;
	}
	/** ?? 车牌号,???? ag_po_quotation.plate_no */
	public String getPlateNo(){
		return this.plateNo;
	}

	/** ?? 客户手机,???? ag_po_quotation.customer_mobile */
	public void setCustomerMobile(String customerMobile){
		this.customerMobile = customerMobile;
	}
	/** ?? 客户手机,???? ag_po_quotation.customer_mobile */
	public String getCustomerMobile(){
		return this.customerMobile;
	}

	/** ?? 客户名称,???? ag_po_quotation.customer_name */
	public void setCustomerName(String customerName){
		this.customerName = customerName;
	}
	/** ?? 客户名称,???? ag_po_quotation.customer_name */
	public String getCustomerName(){
		return this.customerName;
	}

	/** ?? 币种,???? ag_po_quotation.currency */
	public void setCurrency(String currency){
		this.currency = currency;
	}
	/** ?? 币种,???? ag_po_quotation.currency */
	public String getCurrency(){
		return this.currency;
	}

	/** ?? 总保费,???? ag_po_quotation.total_premium */
	public void setTotalPremium(BigDecimal totalPremium){
		this.totalPremium = totalPremium;
	}
	/** ?? 总保费,???? ag_po_quotation.total_premium */
	public BigDecimal getTotalPremium(){
		return this.totalPremium;
	}

	/** ?? 总折扣金额,???? ag_po_quotation.total_discount */
	public void setTotalDiscount(BigDecimal totalDiscount){
		this.totalDiscount = totalDiscount;
	}
	/** ?? 总折扣金额,???? ag_po_quotation.total_discount */
	public BigDecimal getTotalDiscount(){
		return this.totalDiscount;
	}

	/** ?? 总佣金,???? ag_po_quotation.total_charge */
	public void setTotalCharge(BigDecimal totalCharge){
		this.totalCharge = totalCharge;
	}
	/** ?? 总佣金,???? ag_po_quotation.total_charge */
	public BigDecimal getTotalCharge(){
		return this.totalCharge;
	}

	/** ?? 车船税,???? ag_po_quotation.vehicle_tax */
	public void setVehicleTax(BigDecimal vehicleTax){
		this.vehicleTax = vehicleTax;
	}
	/** ?? 车船税,???? ag_po_quotation.vehicle_tax */
	public BigDecimal getVehicleTax(){
		return this.vehicleTax;
	}

	/** ?? 交强险状态0 无报价1 正常报价2 无法报价
,???? ag_po_quotation.compulsory_status */
	public void setCompulsoryStatus(Integer compulsoryStatus){
		this.compulsoryStatus = compulsoryStatus;
	}
	/** ?? 交强险状态0 无报价1 正常报价2 无法报价
,???? ag_po_quotation.compulsory_status */
	public Integer getCompulsoryStatus(){
		return this.compulsoryStatus;
	}

	/** ?? 交强险报价信息说明,???? ag_po_quotation.compulsory_message */
	public void setCompulsoryMessage(String compulsoryMessage){
		this.compulsoryMessage = compulsoryMessage;
	}
	/** ?? 交强险报价信息说明,???? ag_po_quotation.compulsory_message */
	public String getCompulsoryMessage(){
		return this.compulsoryMessage;
	}

	/** ?? 交强险保费,???? ag_po_quotation.compulsory_premium */
	public void setCompulsoryPremium(BigDecimal compulsoryPremium){
		this.compulsoryPremium = compulsoryPremium;
	}
	/** ?? 交强险保费,???? ag_po_quotation.compulsory_premium */
	public BigDecimal getCompulsoryPremium(){
		return this.compulsoryPremium;
	}

	/** ?? 交强险折扣金额,???? ag_po_quotation.compulsory_discount */
	public void setCompulsoryDiscount(BigDecimal compulsoryDiscount){
		this.compulsoryDiscount = compulsoryDiscount;
	}
	/** ?? 交强险折扣金额,???? ag_po_quotation.compulsory_discount */
	public BigDecimal getCompulsoryDiscount(){
		return this.compulsoryDiscount;
	}

	/** ?? 交强险期开始日期,???? ag_po_quotation.compulsory_start */
	public void setCompulsoryStart(Date compulsoryStart){
		this.compulsoryStart = compulsoryStart;
	}
	/** ?? 交强险期开始日期,???? ag_po_quotation.compulsory_start */
	public Date getCompulsoryStart(){
		return this.compulsoryStart;
	}

	/** ?? 交强险期截止日期,???? ag_po_quotation.compulsory_end */
	public void setCompulsoryEnd(Date compulsoryEnd){
		this.compulsoryEnd = compulsoryEnd;
	}
	/** ?? 交强险期截止日期,???? ag_po_quotation.compulsory_end */
	public Date getCompulsoryEnd(){
		return this.compulsoryEnd;
	}

	/** ?? 交强险佣金,???? ag_po_quotation.compulsory_charge */
	public void setCompulsoryCharge(BigDecimal compulsoryCharge){
		this.compulsoryCharge = compulsoryCharge;
	}
	/** ?? 交强险佣金,???? ag_po_quotation.compulsory_charge */
	public BigDecimal getCompulsoryCharge(){
		return this.compulsoryCharge;
	}

	/** ?? 商业险状态0 无报价1 正常报价2 无法报价
,???? ag_po_quotation.business_insurance_status */
	public void setBusinessInsuranceStatus(Integer businessInsuranceStatus){
		this.businessInsuranceStatus = businessInsuranceStatus;
	}
	/** ?? 商业险状态0 无报价1 正常报价2 无法报价
,???? ag_po_quotation.business_insurance_status */
	public Integer getBusinessInsuranceStatus(){
		return this.businessInsuranceStatus;
	}

	/** ?? 商业险报价信息说明,???? ag_po_quotation.business_insurance_message */
	public void setBusinessInsuranceMessage(String businessInsuranceMessage){
		this.businessInsuranceMessage = businessInsuranceMessage;
	}
	/** ?? 商业险报价信息说明,???? ag_po_quotation.business_insurance_message */
	public String getBusinessInsuranceMessage(){
		return this.businessInsuranceMessage;
	}

	/** ?? 商业险保费,???? ag_po_quotation.business_insurance_premium */
	public void setBusinessInsurancePremium(BigDecimal businessInsurancePremium){
		this.businessInsurancePremium = businessInsurancePremium;
	}
	/** ?? 商业险保费,???? ag_po_quotation.business_insurance_premium */
	public BigDecimal getBusinessInsurancePremium(){
		return this.businessInsurancePremium;
	}

	/** ?? 商业险费率,???? ag_po_quotation.business_insurance_floating_rate */
	public void setBusinessInsuranceFloatingRate(BigDecimal businessInsuranceFloatingRate){
		this.businessInsuranceFloatingRate = businessInsuranceFloatingRate;
	}
	/** ?? 商业险费率,???? ag_po_quotation.business_insurance_floating_rate */
	public BigDecimal getBusinessInsuranceFloatingRate(){
		return this.businessInsuranceFloatingRate;
	}

	/** ?? 商业险折扣金额,???? ag_po_quotation.business_insurance_discount */
	public void setBusinessInsuranceDiscount(BigDecimal businessInsuranceDiscount){
		this.businessInsuranceDiscount = businessInsuranceDiscount;
	}
	/** ?? 商业险折扣金额,???? ag_po_quotation.business_insurance_discount */
	public BigDecimal getBusinessInsuranceDiscount(){
		return this.businessInsuranceDiscount;
	}

	/** ?? 商业险开始日期,???? ag_po_quotation.business_insurance_start */
	public void setBusinessInsuranceStart(Date businessInsuranceStart){
		this.businessInsuranceStart = businessInsuranceStart;
	}
	/** ?? 商业险开始日期,???? ag_po_quotation.business_insurance_start */
	public Date getBusinessInsuranceStart(){
		return this.businessInsuranceStart;
	}

	/** ?? 商业险截止日期,???? ag_po_quotation.business_insurance_end */
	public void setBusinessInsuranceEnd(Date businessInsuranceEnd){
		this.businessInsuranceEnd = businessInsuranceEnd;
	}
	/** ?? 商业险截止日期,???? ag_po_quotation.business_insurance_end */
	public Date getBusinessInsuranceEnd(){
		return this.businessInsuranceEnd;
	}

	/** ?? 商业险佣金,???? ag_po_quotation.business_insurance_charge */
	public void setBusinessInsuranceCharge(BigDecimal businessInsuranceCharge){
		this.businessInsuranceCharge = businessInsuranceCharge;
	}
	/** ?? 商业险佣金,???? ag_po_quotation.business_insurance_charge */
	public BigDecimal getBusinessInsuranceCharge(){
		return this.businessInsuranceCharge;
	}

	/** ?? 归属部门,???? ag_po_quotation.department_belong */
	public void setDepartmentBelong(String departmentBelong){
		this.departmentBelong = departmentBelong;
	}
	/** ?? 归属部门,???? ag_po_quotation.department_belong */
	public String getDepartmentBelong(){
		return this.departmentBelong;
	}

	/** ?? 归属人,???? ag_po_quotation.department_belonger */
	public void setDepartmentBelonger(String departmentBelonger){
		this.departmentBelonger = departmentBelonger;
	}
	/** ?? 归属人,???? ag_po_quotation.department_belonger */
	public String getDepartmentBelonger(){
		return this.departmentBelonger;
	}

	/** ?? 经办人,???? ag_po_quotation.operator */
	public void setOperator(String operator){
		this.operator = operator;
	}
	/** ?? 经办人,???? ag_po_quotation.operator */
	public String getOperator(){
		return this.operator;
	}

	/** ?? 渠道代码,???? ag_po_quotation.channel_code */
	public void setChannelCode(String channelCode){
		this.channelCode = channelCode;
	}
	/** ?? 渠道代码,???? ag_po_quotation.channel_code */
	public String getChannelCode(){
		return this.channelCode;
	}

	/** ?? 团单号,???? ag_po_quotation.group_number */
	public void setGroupNumber(String groupNumber){
		this.groupNumber = groupNumber;
	}
	/** ?? 团单号,???? ag_po_quotation.group_number */
	public String getGroupNumber(){
		return this.groupNumber;
	}

	/** ?? 出单机构,???? ag_po_quotation.issue_association */
	public void setIssueAssociation(String issueAssociation){
		this.issueAssociation = issueAssociation;
	}
	/** ?? 出单机构,???? ag_po_quotation.issue_association */
	public String getIssueAssociation(){
		return this.issueAssociation;
	}

	/** ?? 创建时间,???? ag_po_quotation.created_at */
	public void setCreatedAt(Date createdAt){
		this.createdAt = createdAt;
	}
	/** ?? 创建时间,???? ag_po_quotation.created_at */
	public Date getCreatedAt(){
		return this.createdAt;
	}

	/** ?? 创建人,???? ag_po_quotation.created_by */
	public void setCreatedBy(Long createdBy){
		this.createdBy = createdBy;
	}
	/** ?? 创建人,???? ag_po_quotation.created_by */
	public Long getCreatedBy(){
		return this.createdBy;
	}

	/** ?? 修改时间,???? ag_po_quotation.updated_at */
	public void setUpdatedAt(Date updatedAt){
		this.updatedAt = updatedAt;
	}
	/** ?? 修改时间,???? ag_po_quotation.updated_at */
	public Date getUpdatedAt(){
		return this.updatedAt;
	}

	/** ?? 修改人,???? ag_po_quotation.updated_by */
	public void setUpdatedBy(Long updatedBy){
		this.updatedBy = updatedBy;
	}
	/** ?? 修改人,???? ag_po_quotation.updated_by */
	public Long getUpdatedBy(){
		return this.updatedBy;
	}
	public String getCustomerMobileMask() {
		return customerMobileMask;
	}
	public void setCustomerMobileMask(String customerMobileMask) {
		this.customerMobileMask = customerMobileMask;
	}

}