package com.ajb.web.zhima.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.quotation.AgPoQuotation;
import com.ajb.car.metadata.service.SystemConfigService;
import com.ajb.car.quotation.service.AgPoQuotationService;
import com.ajb.car.vo.zhima.policy.PolicyInfo;
import com.ajb.car.vo.zhima.policy.PolicyResponse;
import com.ajb.car.vo.zhima.quotation.QuotationDetail;
import com.ajb.car.vo.zhima.quotation.QuotationResponse;
import com.ajb.common.utils.string.CommonUtil;
import com.ajb.global.config.ZhimaConnection;
import com.ajb.web.quotation.AgPoQuotationWebService;
import com.ajb.web.zhima.ZhimaDataSyncService;

/**
 * 同步芝麻车险报价数据
 * @author Simon Cheng
 *
 */
@Service("zhimaDataSyncService")
public class ZhimaDataSyncServiceImpl implements ZhimaDataSyncService{
	
	@Autowired
	private SystemConfigService systemConfigService;
	
	@Autowired
	AgPoQuotationWebService	agPoQuotationWebService;
	
	@Autowired
	AgPoQuotationService	agPoQuotationService;
	
	//报价列表查询
	private static String queryQuotationURLScopeParam = "";
	private static String queryQuotationMethod = "";
	//获取报价单详情
	private static String queryQuotationDetailMethod = "";
	
	/**
	 * 同步报价数据
	 * @param begin
	 * @param end
	 * @return
	 * @throws InterruptedException
	 */
	@Override
	public QuotationResponse synchQuotaion(Date begin,Date end) throws InterruptedException {
		queryQuotationMethod = systemConfigService.getSingleConfigValue("LinkerSoftAPIQueryQuotationMethod");
		queryQuotationURLScopeParam = systemConfigService.getSingleConfigValue("LinkerSoftAPIQueryQuotationURLScopeParam");
		
		queryQuotationDetailMethod = systemConfigService.getSingleConfigValue("LinkerSoftAPIQueryQuotationDetailMethod");		

		String startTime = CommonUtil.dateParseString(begin,"yyyy-MM-dd");
		String endTime = CommonUtil.dateParseString(end,"yyyy-MM-dd");

		return syncPolicyList(startTime,endTime);
	}

	/**
	 * 同步芝麻报价数据
	 * @param startTime
	 * @param endTime
	 * @param token
	 * @return
	 */
	private QuotationResponse syncPolicyList(String startTime,String endTime)
	{
		QuotationResponse quotationResponse;
		quotationResponse = new QuotationResponse();
		QuotationResponse quotationResponsePage = new QuotationResponse();
		Integer start = 0;
		Integer total = 0;
		Integer size = 15;
		
		//询价单列表,按状态,1,2,3
		PolicyResponse policyList = null;
		policyList = queryListOnePage(startTime,endTime,start);

		total = Integer.parseInt(policyList.getDatas().getPolicyPage().getTotal());
		System.out.println("Total:" + total);
		quotationResponse.setTotal(total);
		while(start < total)
		{
			quotationResponsePage = new QuotationResponse();
			//分页，开始行，页行数queryQuotationURLParam
			System.out.println("start:" + start);
			policyList = queryListOnePage(startTime,endTime,start);
			
			quotationResponsePage = displayList(policyList.getDatas().getPolicyPage().getRows());	
			
			quotationResponse.setTotalPremium(quotationResponse.getTotalPremium().add(quotationResponsePage.getTotalPremium()));
			quotationResponse.setBzPremium(quotationResponse.getBzPremium().add(quotationResponsePage.getBzPremium()));
			quotationResponse.setTcPremium(quotationResponse.getTcPremium().add(quotationResponsePage.getTcPremium()));
			quotationResponse.setTsltax(quotationResponse.getTsltax().add(quotationResponsePage.getTsltax()));
			quotationResponse.setAllCharge(quotationResponse.getAllCharge().add(quotationResponsePage.getAllCharge()));

			if (start > 0 && (start + size > total))
			{
				break;
			}else
			{
				start = start + size;
			}
		}
		
		return quotationResponse;
	}
	/**
	 * 同步一页数据
	 * @param startTime
	 * @param endTime
	 * @param start
	 * @param token
	 * @return
	 */
	private PolicyResponse queryListOnePage(String startTime,String endTime,Integer start)
	{
		String queryQuotationMethodStep = String.format(queryQuotationMethod, start.toString(),"15");
		queryQuotationURLScopeParam = String.format(queryQuotationURLScopeParam, startTime,endTime);
			
		PolicyResponse policyList = ZhimaConnection.postUrlMap2JavaBean(ZhimaConnection.getHostURL() + queryQuotationMethodStep, queryQuotationURLScopeParam, PolicyResponse.class);
		
		return policyList;		
	}
	/**
	 * 同步一页报价详情
	 * @param list
	 * @param token
	 * @return
	 */
	private QuotationResponse displayList(List<PolicyInfo> list)
	{	
		QuotationResponse quotationResponse = new QuotationResponse();
		String policyCode = null;
		Date quotationDate = null;
		BigDecimal totalPremium = new BigDecimal(0);
		BigDecimal bzPremium = new BigDecimal(0);
		BigDecimal tcPremium = new BigDecimal(0);
		BigDecimal vsltax = new BigDecimal(0);
		BigDecimal allCharge = new BigDecimal(0);
		for(int i = 0; i < list.size();i++)
		{
			policyCode = list.get(i).getPolicycode();
			quotationDate = list.get(i).getCreateDate();
			System.out.print(""+ list.get(i).getCarNumber());
			
			totalPremium = totalPremium.add(BigDecimal.valueOf(list.get(i).getTotalPremium()));
			bzPremium = bzPremium.add(BigDecimal.valueOf(list.get(i).getBzPremium()));
			tcPremium = tcPremium.add(BigDecimal.valueOf(list.get(i).getTcPremium()));
			vsltax = vsltax.add(BigDecimal.valueOf(list.get(i).getVsltax()));
			allCharge = allCharge.add(BigDecimal.valueOf(list.get(i).getAllCharge()));
			
			System.out.print("getTotalPremium," + list.get(i).getTotalPremium());
			System.out.print("getBzPremium," + list.get(i).getBzPremium());
			System.out.print("getTcPremium," + list.get(i).getTcPremium());
			System.out.print("getVsltax," + list.get(i).getVsltax());
			System.out.println("getAllCharge," + list.get(i).getAllCharge());

			//检查是否已经存在
			AgPoQuotation one = agPoQuotationService.findByQuoteNo(policyCode);
			if (one==null)
			{
				String queryQuotationDetailMethodNew = String.format(queryQuotationDetailMethod, policyCode);
				
				//QuotationDetail postConfirm = getComfirmationDetail(ZhimaConnection.getHostURL() + queryQuotationDetailMethodNew,null,token);
				
				QuotationDetail postConfirm = ZhimaConnection.getUrlMap2JavaBean(ZhimaConnection.getHostURL() + queryQuotationDetailMethodNew,QuotationDetail.class);
				
			    //写车辆信息,报价信息，coverages入表
				//agPoQuotationWebService.saveAgPoQuotation(postConfirm.getDatas().getPriceinfo());
				agPoQuotationWebService.saveAgPoQuotationAndConfirm(quotationDate,postConfirm.getDatas().getPriceinfo(),postConfirm.getDatas().getConfirmInfo());
				//写确认信息入表confirmInfo
				//agPoQuotationWebService.saveAgPoQuotationConfirm(postConfirm.getDatas().getConfirmInfo());
				
				/*System.out.print("" + postConfirm.getDatas().getPriceinfo().getVehInfo().getRegistrationNumber());
				System.out.print("getTotalPremium," + postConfirm.getDatas().getPriceinfo().getTotalPremium());
				System.out.print("getBzPremium," + postConfirm.getDatas().getPriceinfo().getBzPremium());
				System.out.print("getTcPremium," + postConfirm.getDatas().getPriceinfo().getTcPremium());
				System.out.print("getAllCharge," + postConfirm.getDatas().getPriceinfo().getAllCharge());
				System.out.println("getVsltax," + postConfirm.getDatas().getPriceinfo().getVsltax());
				System.out.print("getAllCharge," + postConfirm.getDatas().getPriceinfo().getAllCharge());	
				
				System.out.print("," + dateToString(list.get(i).getCreateDate()));
				System.out.println("");*/
			}
		}
		quotationResponse.setTotalPremium(totalPremium);
		quotationResponse.setBzPremium(bzPremium);
		quotationResponse.setTcPremium(tcPremium);
		quotationResponse.setTsltax(vsltax);
		quotationResponse.setAllCharge(allCharge);
		return quotationResponse;
	}
} 