package com.ajb.car.quotation.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.quotation.AgPoQuotation;
import com.ajb.car.quotation.repositories.AgPoQuotationRepository;
import com.ajb.car.quotation.service.AgPoQuotationService;

@Service("agPoQuotationService")
public class AgPoQuotationServiceImpl implements AgPoQuotationService{
	@Autowired
	private AgPoQuotationRepository agPoQuotationRepo;

	public AgPoQuotation save(AgPoQuotation obj){
		return agPoQuotationRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agPoQuotationRepo .delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgPoQuotation update(AgPoQuotation obj) {
		return agPoQuotationRepo.saveAndFlush(obj);
	}

	public AgPoQuotation findById(Long id){
		return agPoQuotationRepo.findOne(id);
	}
	
	public Page<AgPoQuotation> findByObjPageable(AgPoQuotation obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgPoQuotation> ex = Example.of(obj, matcher); 
		return agPoQuotationRepo.findAll(ex,pageable);
	}

	@Override
	public AgPoQuotation findByQuoteNo(String quoteNo) {
		// TODO Auto-generated method stub
		return agPoQuotationRepo.findByQuoteNo(quoteNo);
	}
}