package com.ajb.car.quotation.impl;

import java.math.BigDecimal;
import java.util.Date;

import com.ajb.car.entity.quotation.AgPoQuotation;
import com.ajb.car.entity.quotation.AgPoQuotationCover;
import com.ajb.car.vo.zhima.quotation.BzCoverages;
import com.ajb.car.vo.zhima.quotation.Priceinfo;

public class AgPoQuotationConverter {
	
	public static AgPoQuotation initAgPoQuotationData(Priceinfo priceinfo,Long quoteVehicleId)
	{
		AgPoQuotation agPoQuotation = new AgPoQuotation();
		agPoQuotation.setPlateNo(priceinfo.getCarNumber());
		agPoQuotation.setQuoteNo(priceinfo.getPolicycode());
		agPoQuotation.setQuoteVehicleId(quoteVehicleId);
		if (priceinfo.getVehInfo().getIsNewCar()=="1")
		{
			agPoQuotation.setIsRenewal(1);
		}else
		{
			agPoQuotation.setIsRenewal(2);
		}
		if (priceinfo.getHasbz()=="yes" && priceinfo.getHastc()=="yes")
		{
			agPoQuotation.setQuoteType(2);
		}else if (priceinfo.getHasbz()=="yes" && priceinfo.getHastc()!="yes")
		{
			agPoQuotation.setQuoteType(0);	
		}else if (priceinfo.getHasbz()!="yes" && priceinfo.getHastc()=="yes")
		{
			agPoQuotation.setQuoteType(1);	
		}

		agPoQuotation.setQuoteStatus(Integer.parseInt(priceinfo.getStatus()));
		agPoQuotation.setQuoteProviderType("V");
		agPoQuotation.setQuoteProviderId(2L);
		agPoQuotation.setCustomerId(-1L);
		agPoQuotation.setCustomerMobile(priceinfo.getApplicant().getTel());
		agPoQuotation.setCustomerName(priceinfo.getApplicant().getName());
		agPoQuotation.setCurrency("RMB");
		agPoQuotation.setTotalPremium(BigDecimal.valueOf(priceinfo.getTotalPremium()));
		agPoQuotation.setTotalCharge(BigDecimal.valueOf(priceinfo.getAllCharge()));		
		agPoQuotation.setCompulsoryStatus(priceinfo.getTcCoverageStatus());
		agPoQuotation.setCompulsoryMessage(priceinfo.getTcCoverageMsg());
		agPoQuotation.setCompulsoryPremium(BigDecimal.valueOf(priceinfo.getTcPremium()));
		agPoQuotation.setCompulsoryCharge(BigDecimal.valueOf(priceinfo.getTcCharge()));
		agPoQuotation.setCompulsoryStart(priceinfo.getTcStartTime());
		agPoQuotation.setVehicleTax(BigDecimal.valueOf(priceinfo.getVsltax()));
		java.util.Calendar Cal=java.util.Calendar.getInstance();    
		Date dateOper = priceinfo.getTcStartTime();
		Cal.setTime(dateOper);    

		Cal.add(java.util.Calendar.YEAR,1);    
		dateOper = Cal.getTime();

		agPoQuotation.setCompulsoryEnd(dateOper);
		agPoQuotation.setCompulsoryCharge(BigDecimal.valueOf(priceinfo.getTcCharge()));
		agPoQuotation.setBusinessInsuranceStatus(priceinfo.getBzCoverageStatus());
		agPoQuotation.setBusinessInsuranceMessage(priceinfo.getBzCoverageMsg());
		agPoQuotation.setBusinessInsurancePremium(BigDecimal.valueOf(priceinfo.getBzPremium()));
		agPoQuotation.setBusinessInsuranceFloatingRate(BigDecimal.valueOf(Double.valueOf(priceinfo.getBzFloatRatio())));
		agPoQuotation.setBusinessInsuranceCharge(BigDecimal.valueOf(priceinfo.getBzCharge()));
		agPoQuotation.setBusinessInsuranceStart(priceinfo.getBzStartTime());
		dateOper = priceinfo.getBzStartTime();
		Cal.setTime(dateOper);    

		Cal.add(java.util.Calendar.YEAR,1);    
		dateOper = Cal.getTime();
		agPoQuotation.setBusinessInsuranceEnd(dateOper);
		agPoQuotation.setBusinessInsuranceCharge(BigDecimal.valueOf(priceinfo.getBzCharge()));
		//agPoQuotation.setDepartmentBelong(priceinfo.get);
		//agPoQuotation.setDepartmentBelonger(priceinfo.);
		//agPoQuotation.setOperator(priceinfo.get);
		//agPoQuotation.setChannelCode(priceinfo.);
		//agPoQuotation.setGroupNumber(priceinfo.);
		//agPoQuotation.setIssueAssociation();
		agPoQuotation.setCreatedAt(new Date());
		agPoQuotation.setCreatedBy(-1L);
		
		return agPoQuotation;
	}

	public static AgPoQuotationCover initThirdPartyLiabilityExemptDeductibleSpecialClauseData(BzCoverages bzCoverages,Long quotationId,Long quotationVehicleId)
	{
		AgPoQuotationCover agPoQuotationCover = null;
		agPoQuotationCover = new AgPoQuotationCover();
		
		agPoQuotationCover.setQuotationId(quotationId);
		agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
		return agPoQuotationCover;
	}
	public static AgPoQuotationCover initDamageLossCoverageData(BzCoverages bzCoverages,Long quotationId,Long quotationVehicleId)
	{
		AgPoQuotationCover agPoQuotationCover = null;
		agPoQuotationCover = new AgPoQuotationCover();
		
		agPoQuotationCover.setQuotationId(quotationId);
		agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
		return agPoQuotationCover;
	}
	public static AgPoQuotationCover initCarBodyPaintCoverageData(BzCoverages bzCoverages,Long quotationId,Long quotationVehicleId)
	{
		AgPoQuotationCover agPoQuotationCover = null;
		agPoQuotationCover = new AgPoQuotationCover();
		
		agPoQuotationCover.setQuotationId(quotationId);
		agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
		return agPoQuotationCover;
	}
	public static AgPoQuotationCover initDamageLossExemptDeductibleSpecialClauseData(BzCoverages bzCoverages,Long quotationId,Long quotationVehicleId)
	{
		AgPoQuotationCover agPoQuotationCover = null;
		agPoQuotationCover = new AgPoQuotationCover();
		
		agPoQuotationCover.setQuotationId(quotationId);
		agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
		return agPoQuotationCover;
	}
	public static AgPoQuotationCover initCarBodyPaintExemptDeductibleSpecialClauseData(BzCoverages bzCoverages,Long quotationId,Long quotationVehicleId)
	{
		AgPoQuotationCover agPoQuotationCover = null;
		agPoQuotationCover = new AgPoQuotationCover();
		
		agPoQuotationCover.setQuotationId(quotationId);
		agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
		return agPoQuotationCover;
	}
	public static AgPoQuotationCover initThirdPartyLiabilityCoverageData(BzCoverages bzCoverages,Long quotationId,Long quotationVehicleId)
	{
		AgPoQuotationCover agPoQuotationCover = null;
		agPoQuotationCover = new AgPoQuotationCover();
		
		agPoQuotationCover.setQuotationId(quotationId);
		agPoQuotationCover.setQuotationVehicleId(quotationVehicleId);
		return agPoQuotationCover;
	}
}
