package com.ajb.car.metadata.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

import com.ajb.car.entity.meta.AgMdCode;
import com.ajb.car.metadata.repositories.AgMdCodeRepository;
import com.ajb.car.metadata.service.AgMdCodeService;

@Service("agMdCodeService")
public class AgMdCodeServiceImpl implements AgMdCodeService{
	@Autowired
	private AgMdCodeRepository agMdCodeRepo;

	public AgMdCode save(AgMdCode obj){
		return agMdCodeRepo.save(obj);
	}

	public Boolean delete(Long id) {
		try {
			agMdCodeRepo .delete(id);
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public AgMdCode update(AgMdCode obj) {
		return agMdCodeRepo.saveAndFlush(obj);
	}

	public AgMdCode findById(Long id){
		return agMdCodeRepo.findOne(id);
	}
	
	public Page<AgMdCode> findByObjPageable(AgMdCode obj,Pageable pageable){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgMdCode> ex = Example.of(obj, matcher); 
		return agMdCodeRepo.findAll(ex,pageable);
	}
	
	public List<AgMdCode> findByObjSortable(AgMdCode obj,Sort sort){
		ExampleMatcher matcher = ExampleMatcher.matching();
		Example<AgMdCode> ex = Example.of(obj, matcher); 
		return agMdCodeRepo.findAll(ex,sort);
	}

	@Override
	public AgMdCode getCodeByType(String type) {
		// TODO Auto-generated method stub
		return agMdCodeRepo.getCodeByType(type);
	}
}