package com.yd.api.practitioner;

import com.yd.api.practitioner.service.PractitionerBasicInfoService;
import com.yd.api.practitioner.service.PractitionerService;
import com.yd.api.practitioner.service.ScheduleTrackService;
import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.media.MediaGetReqVO;
import com.yd.api.practitioner.vo.media.MediaGetRespVO;
import com.yd.api.practitioner.vo.opportunity.*;
import com.yd.api.practitioner.vo.organization.OrganizationQueryRequestVO;
import com.yd.api.practitioner.vo.organization.OrganizationQueryResponseVO;
import com.yd.api.practitioner.vo.payscale.PayScalePdfRequestVO;
import com.yd.api.practitioner.vo.payscale.PayScalePdfResponseVO;
import com.yd.api.practitioner.vo.payscale.PayScaleQueryRequestVO;
import com.yd.api.practitioner.vo.payscale.PayScaleQueryResponseVO;
import com.yd.api.practitioner.vo.policy.PolicyListQueryRequestVO;
import com.yd.api.practitioner.vo.policy.PolicyListQueryResponseVO;
import com.yd.api.practitioner.vo.policy.policyinfoquery.PolicyInfoQueryRequestVO;
import com.yd.api.practitioner.vo.policy.policyinfoquery.PolicyInfoQueryResponseVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.recruit.*;
import com.yd.api.practitioner.vo.salestarget.*;
import com.yd.api.practitioner.vo.setting.*;
import com.yd.api.practitioner.vo.subordinate.SubordinateSystemMemberQueryRequestVO;
import com.yd.api.practitioner.vo.subordinate.SubordinateSystemMemberQueryResponseVO;
import com.yd.api.result.JsonResult;
import com.yd.dal.entity.practitioner.ScheduleTrack;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@Controller
@RestController
@RequestMapping("/practitioner")
public class PractitionerController {

    @Autowired
    private PractitionerService practitionerService;
    @Autowired
    private PractitionerBasicInfoService practitionerBasicInfoService;
    @Autowired
    private ScheduleTrackService scheduleTrackService;
    /**
     * 经纪人登录
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/login")
    public Object practitionerLogin(@RequestBody PractitionerLoginRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerLoginResponseVO responseVO = practitionerService.practitionerLogin(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人（排行榜） + （保费+佣金+件数）查询
     * @param  requestVO 请求数据
     * @return Object
     */
    @RequestMapping("/rank")
    public Object practitionerRank(@RequestBody PractitionerRankRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerRankResponseVO responseVO = practitionerService.practitionerRank(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-查询经纪人的个人设置
     * @param requestVO 请求数据
     * @return responseVO
     */
    @RequestMapping("/settingQuery")
    public Object settingQuery(@RequestBody SettingQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        SettingQueryResponseVO responseVO = practitionerService.settingQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人-保存经纪人的个人设置
     * @param requestVO 请求数据
     * @return responseVO
     */
    @RequestMapping("/settingSave")
    public Object mySettingSave(@RequestBody SettingSaveRequestVO requestVO) throws Exception {
        JsonResult result = new JsonResult();
        SettingSaveResponseVO responseVO = practitionerService.settingSave(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人-删除经纪人照片
     */
    @RequestMapping("/imgDelete")
    public Object imgDelete(@RequestBody ImgDeleteRequestVO requestVO){
        JsonResult result = new JsonResult();
        ImgDeleteResponseVO responseVO = practitionerService.imgDelete(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 微信-上传多媒体文件
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/mediaGet")
    public Object mediaGet(@RequestBody MediaGetReqVO requestVO){
        JsonResult result = new JsonResult();
        MediaGetRespVO responseVO = practitionerService.mediaGet(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /***
     * 经纪人-经纪人查询自己的商机
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/ownOpportunityQuery")
    public Object ownOpportunityQuery(@RequestBody OwnOpportunityQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        OwnOpportunityQueryResponseVO responseVO = practitionerService.ownOpportunityQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--新增增员
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/recruit")
    public Object recruit(@RequestBody RecruitRequestVO requestVO){
        JsonResult result = new JsonResult();
        RecruitResponseVO responseVO = practitionerService.recruit(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /***
     * 经纪人-经纪人查询自己的商机详情查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/ownOpportunityDetailQuery")
    public Object ownOpportunityDetailQuery(@RequestBody OwnOpportunityDetailQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        OwnOpportunityDetailQueryResponseVO responseVO = practitionerService.ownOpportunityDetailQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--新增增员记录
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/addRecruitTrack")
    public Object addRecruitTrack(@RequestBody AddRecruitTrackRequestVO requestVO){
        JsonResult result = new JsonResult();
        AddRecruitTrackResponseVO responseVO = practitionerService.addRecruitTrack(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长--增员记录查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/recruitTrackQuery")
    public Object recruitTrackQuery(@RequestBody RecruitTrackQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        RecruitTrackQueryResponseVO responseVO = practitionerService.recruitTrackQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长--增员列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/recruitListQuery")
    public Object recruitListQuery(@RequestBody RecruitListRequestVO requestVO){
        JsonResult result = new JsonResult();
        RecruitListResponseVO responseVO = practitionerService.recruitListQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-修改商机基本信息
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/ownOpportunityBasicInformationSave")
    public Object ownOpportunityBasicInformationSave(@RequestBody OwnOpportunityBasicInformationSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        OwnOpportunityBasicInformationSaveResponseVO responseVO = practitionerService.ownOpportunityBasicInformationSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-保存商机跟进,修改商机基本信息
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/ownOpportunityRecordSave")
    public Object ownOpportunityRecordSave(@RequestBody OwnOpportunityRecordSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        OwnOpportunityRecordSaveResponseVO responseVO = practitionerService.ownOpportunityRecordSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-ydLife查询此经纪人总分数  按年月周日 分别统计  新增商机个数  达成率
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/opportunityStatistics")
    public Object OpportunityStatistics(@RequestBody OpportunityStatisticsRequestVO requestVO){
        JsonResult result = new JsonResult();
        OpportunityStatisticsResponseVO responseVO = practitionerService.opportunityStatistics(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--设置增员目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialGoalsSetting")
    public Object potentialGoalsSetting(@RequestBody PotentialGoalsSettingRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialGoalsSettingResponseVO responseVO = practitionerService.potentialGoalsSetting(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-保存销售目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/salesTargetSave")
    public Object salesTargetSave(@RequestBody SalesTargetSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        SalesTargetSaveResponseVO responseVO = practitionerService.salesTargetSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--查询增员目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialGoalsQuery")
    public Object potentialGoalsQuery(@RequestBody PotentialGoalsQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialGoalsQueryResponseVO responseVO = practitionerService.potentialGoalsQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-查询销售目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/salesTargetQuery")
    public Object salesTargetQuery(@RequestBody SalesTargetQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        SalesTargetQueryResponseVO responseVO = practitionerService.salesTargetQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--查询增员目标活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialGoalsActionsQuery")
    public Object potentialGoalsActionsQuery(@RequestBody PotentialGoalsActionsQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialGoalsActionsQueryResponseVO responseVO = practitionerService.potentialGoalsActionsQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 经纪人-保存月均目标
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/salesTargetMonthSave")
    public Object salesTargetMonthSave(@RequestBody SalesTargetMonthSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        SalesTargetMonthSaveResponseVO responseVO = practitionerService.salesTargetMonthSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--更新增员目标活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialGoalsActionsUpdate")
    public Object potentialGoalsActionsUpdate(@RequestBody PotentialGoalsActionsUpdateRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialGoalsActionsUpdateResponseVO responseVO = practitionerService.potentialGoalsActionsUpdate(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 团队长-查看组员得分均值
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/teamActionsAverageQuery")
    public Object teamActionsAverageQuery(@RequestBody TeamActionsAverageQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        TeamActionsAverageQueryResponseVO responseVO = practitionerService.teamScoreAverageQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 团队长--查看目前活动量
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/potentialActivityQuery")
    public Object potentialActivityQuery(@RequestBody PotentialActivityQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PotentialActivityQueryResponseVO responseVO = practitionerService.potentialActivityQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 队员销售活动量列表
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/playerSalesActivityQuery")
    public Object playerSalesActivityQuery(@RequestBody PlayerSalesActivityQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PlayerSalesActivityQueryResponseVO responseVO = practitionerService.playerSalesActivityQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * 销售业绩预测  保费/佣金/件数  月季年
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/salesPerformanceForecastListQuery")
    public Object salesPerformanceForecastListQuery(@RequestBody SalesPerformanceForecastListQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        SalesPerformanceForecastListQueryResponseVO responseVO = practitionerService.salesPerformanceForecastListQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 体系团队成员信息查询
     * @param requestVO 请求数据
     * @return AnnouncementQueryResponseVO
     */
    @RequestMapping("/subordinateSystemMemberQuery")
    public Object subordinateSystemMemberQuery(@RequestBody SubordinateSystemMemberQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        SubordinateSystemMemberQueryResponseVO responseVO = practitionerService.subordinateSystemMemberQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人-查看自己销售活动量分值详情
     */
    @RequestMapping("salesScoreDetailQuery")
    public Object salesScoreDetailQuery (@RequestBody SalesScoreDetailQueryRequestVO requestVO ){
        JsonResult result = new JsonResult();
        SalesScoreDetailQueryResponseVO responseVO = practitionerService.salesScoreDetailQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
    /**
     * 经纪人保单列表查询接口
     * @param requestVO 请求信息
     * @return PolicyListQueryResponseVO
     */
    @RequestMapping("/policyListQuery")
    public Object practitionerPolicyListQuery(@RequestBody PolicyListQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PolicyListQueryResponseVO responseVO = practitionerBasicInfoService.policyListQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人保单详情查询接口
     * @param requestVO 请求信息
     * @return PolicyInfoQueryResponseVO
     */
    @RequestMapping("/policyInfoQuery")
    public Object policyInfoQuery(@RequestBody PolicyInfoQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PolicyInfoQueryResponseVO responseVO = practitionerBasicInfoService.policyInfoQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 经纪人薪资表查询接口
     * @param requestVO 请求信息
     * @return PolicyInfoQueryResponseVO
     */
    @RequestMapping("/payScaleListQuery")
    public Object payScaleListQuery(@RequestBody PayScaleQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        PayScaleQueryResponseVO responseVO = practitionerBasicInfoService.payScaleListQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }


    /**
     * 获取经纪人的薪资表
     * @param requestVO 请求信息
     * @return 返回信息
     */
    @PostMapping(value = "/payScalePdf")
    public Object payScalePdf(@RequestBody PayScalePdfRequestVO requestVO){
        JsonResult result = new JsonResult();
        PayScalePdfResponseVO responseVO =  practitionerBasicInfoService.payScalePdf(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * 申请专家支持
     * @param requestVO 请求信息
     * @return 返回信息
     */
    @PostMapping(value = "/applyForExpertSupport")
    public Object applyForExpertSupport(@RequestBody ApplyForExpertSupportRequestVO requestVO){
        JsonResult result = new JsonResult();
        ApplyForExpertSupportResponseVO responseVO =  practitionerService.applyForExpertSupport(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
    /**
     *
     * @param requestVO
     * @return
     */
    @RequestMapping("/organizationQuery")
    public Object organizationQuery(@RequestBody OrganizationQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        OrganizationQueryResponseVO responseVO = practitionerBasicInfoService.organizationQuery(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
    /**
     * 新建日程
     * @param schedule
     * @return
     */
    @RequestMapping("/addScheduleTrack")
    public Object addScheduleTrack(@RequestBody ScheduleTrack schedule){
        JsonResult result = scheduleTrackService.insert(schedule);
        return result;
    }

    /**
     * 根据经纪人id查询日程列表
     * @param params
     * @return
     */
    @RequestMapping("/queryScheduleTrackList")
    public Object queryScheduleTrackList(@RequestBody Map<String, String> params){
        Long practitionerId = Long.parseLong(params.get("practitionerId")) ;
        String trackDate = (String) params.get("trackDate");
        JsonResult result = scheduleTrackService.queryScheduleTrackList(practitionerId, trackDate);
        return result;
    }

}
