package com.yd.dal.service.practitioner;

import com.yd.dal.entity.practitioner.PractitionerBasicInfo;
import com.yd.dal.entity.practitioner.PractitionerRankInfo;

import java.util.List;

public interface PractitionerServiceDAL {
    /**
     * 线下--通过手机号码获取经纪人的基础信息
     * @param mobileNo
     * @return
     */
    PractitionerBasicInfo getPractitionerBasicInfoForOffline(String mobileNo);
    /**
     * 线上--通过手机号码获取经纪人的基础信息
     * @param mobileNo
     * @return
     */
    PractitionerBasicInfo getPractitionerBasicInfoForOnline(String mobileNo);

    /**
     * 线下--按照时间进行查询经纪人的排名统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForOffline(Integer time);

    /**
     * 线上--按照时间进行查询经纪人的排名统计信息
     * @param time 1-month,2-year
     * @return
     */
    List<PractitionerRankInfo> getPractitionerRankInfoForOnline(Integer time);
}
