package com.yd.dal.service.commission;

import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

import com.yd.dal.entity.commission.CommissionEGolden;
import com.yd.dal.mapper.commission.CommissionEGoldenMapper;
import com.yd.util.intercept.annotation.TargetDataSource;
import com.yd.util.intercept.commons.DataSourceKey;

import javax.annotation.Resource;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Simon
 * @version 1.0
 */
@Service("commissionEGoldenDA")
public class CommissionEGoldenDAImpl implements CommissionEGoldenDA {

    private static final Logger LOG = Logger.getLogger(CommissionEGoldenDAImpl.class);

    @Resource
    private CommissionEGoldenMapper commissionEGoldenMapper;

    /*
     * 按照手机号从EGolden DB中查询用户保单列表
     * 通过标签指定数据源：dataSourceKey = DataSourceKey.DB_EGOLDEN
     * (non-Javadoc)
     * @see com.yd.dataccess.service.commission.CommissionEGoldenDA#listSalesCommissionfromEGolden(java.lang.String)
     */
	@Override
	@TargetDataSource(dataSourceKey = DataSourceKey.DB_EGOLDEN)
	public List<CommissionEGolden> listSalesCommissionfromEGolden(String login) {
		
    	List<CommissionEGolden> destList = new ArrayList<CommissionEGolden>();

        destList = commissionEGoldenMapper.listSalesCommissionfromEGolden(login);

        return destList;
	}
}
