package com.yd.api.practitioner.service.impl;

import com.yd.api.practitioner.vo.login.PractitionerBasicInfo;
import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.rank.AclCustomerFortuneStatistics;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.rank.PractitionerInfoForAchievement;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclCustomerLog;
import com.yd.dal.entity.customer.CustomerFileUpload;
import com.yd.dal.entity.practitioner.PractitionerBasicInfoDAL;
import com.yd.dal.entity.practitioner.PractitionerInfo;
import com.yd.dal.entity.practitioner.PractitionerRankInfo;
import com.yd.dal.entity.practitioner.PractitionerSubordinateInfo;
import com.yd.dal.service.customer.AclCustomerLogDALService;
import com.yd.dal.service.customer.AclFileUploadDALService;
import com.yd.dal.service.meta.MdCodeDALService;
import com.yd.dal.service.practitioner.PractitionerDALService;
import com.yd.dal.service.practitioner.PractitionerSubordinateDALService;
import com.yd.util.config.ZHBErrorConfig;
import com.yd.util.deshandler.DESTypeHandler;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.google.common.base.Strings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@Service("practitionerService")
public class PractitionerServiceImpl implements com.yd.api.practitioner.service.PractitionerService {

    @Autowired
    private PractitionerDALService practitionerDALService;
    @Autowired
    private MdCodeDALService mdCodeDALService;
    @Autowired
    private AclFileUploadDALService aclFileUploadDALService;
    @Autowired
    private PractitionerSubordinateDALService practitionerSubordinateDALService;
    @Autowired
    private AclCustomerLogDALService aclCustomerLogDALService;

    @Override
    public PractitionerLoginResponseVO practitionerLogin(PractitionerLoginRequestVO requestVO) {
        PractitionerLoginResponseVO responseVO = new PractitionerLoginResponseVO();
        String mobileNo = requestVO.getMobileNo();
        //1、校验入参，电话号码不能为空
        if (Strings.isNullOrEmpty(mobileNo)) {
            String[] params = {"mobileNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", params)));
            return responseVO;
        }
        //2、检查是否在ag_acl_customer表中存在该用户，如果不存在就注册，然后直接抛错，该用户未注册为经纪人
        PractitionerInfo practitionerInfo = practitionerDALService.findPractitionerInfoByLogin(mobileNo);
        if(practitionerInfo != null){
            Long practitionerType = practitionerInfo.getPractitionerType();
            //处理特殊人员
            boolean isSpecial = false;
            String mobileSpecialStr = mdCodeDALService.findCodeByType("special_practitioner_mobile");
            if(!Strings.isNullOrEmpty(mobileSpecialStr)){
                List<String> mobileSpecials = Arrays.asList(mobileSpecialStr.split(","));
                isSpecial = mobileSpecials.contains(mobileNo);
            }
            if(28L == practitionerType || isSpecial){//只有寿险的经纪人和注册为经纪人的员工才能登录
                Long practitionerId = practitionerInfo.getPractitionerId();
                Long customerId = practitionerInfo.getCustomerId();
                PractitionerBasicInfo basicInfo = new PractitionerBasicInfo();
                BeanUtils.copyProperties(practitionerInfo,basicInfo);
                //获取头像
                Integer targetType = 1, targetUseFor = 1;
                CustomerFileUpload fileUpload = aclFileUploadDALService.findFilePathInfo(targetType,targetUseFor,practitionerId);
                String imagePath = (fileUpload != null) ? fileUpload.getFilePath() : null;
                basicInfo.setHeadImagePath(imagePath);
                //获取体系信息
                Long subordinateId = practitionerInfo.getSubordinateId();
                if(subordinateId != null){
                    PractitionerSubordinateInfo subordinateInfo = practitionerSubordinateDALService.findSubordinateInfo(subordinateId);
                    if(subordinateInfo != null){
                        basicInfo.setSubordinateName(subordinateInfo.getSubordinateName());
                        basicInfo.setSubordinateLeader(subordinateInfo.getSubordinateLeader());
                    }
                }
                //获取用户的登录次数
                List<AclCustomerLog> customerLogList = aclCustomerLogDALService.findLogInfoByCustomerId(customerId);
                int logTimes = (customerLogList.isEmpty()) ? 0 : customerLogList.size();
                //保存用户的登录记录
                aclCustomerLogDALService.saveCustomerLog(customerId,2);
                responseVO.setCustomerId(customerId);
                responseVO.setPractitionerId(practitionerId);
                responseVO.setPractitionerBasicInfo(basicInfo);
                responseVO.setLoginTimes(logTimes);
                responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
            }

        }else{
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830001")));
        }
        return responseVO;
    }

    @Override
    public PractitionerRankResponseVO practitionerRank(PractitionerRankRequestVO requestVO) {
        PractitionerRankResponseVO responseVO = new PractitionerRankResponseVO();
        String mobileNo = requestVO.getMobileNo();
        Integer type = requestVO.getType();
        Integer time = requestVO.getTime();
        Integer platform = requestVO.getPlatform();
        type = (type == null) ? 1 : type;//默认：保费
        time = (time == null) ? 1 : time;//默认：本月
        platform = (platform == null) ? 1 : platform;
        if(!Strings.isNullOrEmpty(mobileNo)){
            //查询该手机号码的经纪人id，是否存在
            PractitionerBasicInfoDAL practitionerBasicInfo = getPractitionerBasicInfo(mobileNo,platform);
            if(practitionerBasicInfo != null){
                String practitionerId = practitionerBasicInfo.getPractitionerId();
                if(!Strings.isNullOrEmpty(practitionerId)){
                    List<PractitionerRankInfo> rankInfoList = getPractitionerRankInfo(time,platform);
                    //按照指定类型排序
                    getPractitionerRankResult(responseVO,rankInfoList,type,practitionerId);
                    responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
                }
            }else{
                responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830001"))); //该经纪人不存在
            }
        }else{
            String [] param = {"mobileNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", param)));
        }
        return responseVO;
    }

    private List<PractitionerRankInfo> getPractitionerRankInfo(Integer time, Integer platform) {
        List<PractitionerRankInfo> rankInfoList;
        if(platform == 1){
            Long practitionerTypeId = 28L;
            rankInfoList = practitionerDALService.getPractitionerRankInfoForOnline(time,practitionerTypeId);
            //特殊人员处理
            String mobileSpecialStr = mdCodeDALService.findCodeByType("special_practitioner_mobile");
            if(!Strings.isNullOrEmpty(mobileSpecialStr)){
                List<String> mobileSpecials = Arrays.asList(mobileSpecialStr.split(","));
                List<PractitionerRankInfo> rankInfoListSpecials = practitionerDALService.getPractitionerRankInfoForSpecials(mobileSpecials,time);
                rankInfoList.addAll(rankInfoListSpecials);
            }
        }else{
            rankInfoList = practitionerDALService.getPractitionerRankInfoForOffline(time);
        }
        return rankInfoList;
    }

    private PractitionerBasicInfoDAL getPractitionerBasicInfo(String mobileNo, Integer platform) {
        PractitionerBasicInfoDAL practitionerBasicInfo;
        if(platform == 1){
            DESTypeHandler jpaCryptoConverter = new DESTypeHandler();
            mobileNo = jpaCryptoConverter.encode(mobileNo);
            practitionerBasicInfo = practitionerDALService.getPractitionerBasicInfoForOnline(mobileNo);
            if(practitionerBasicInfo != null){
                Long practitionerId = practitionerBasicInfo.getPractitionerIdForOnline();
                if(practitionerId != null){
                    practitionerBasicInfo.setPractitionerId(practitionerId.toString());
                }
            }
        }else{
            practitionerBasicInfo = practitionerDALService.getPractitionerBasicInfoForOffline(mobileNo);
        }
        return practitionerBasicInfo;
    }

    private void getPractitionerRankResult(PractitionerRankResponseVO responseVO, List<PractitionerRankInfo> rankInfoList, Integer type, String practitionerId) {
        PractitionerInfoForAchievement practitionerInfo = new PractitionerInfoForAchievement(0D,0D,0);
        List<AclCustomerFortuneStatistics> rankList = new ArrayList<>();
        if(!rankInfoList.isEmpty()){
            //排序---1-保费，2-佣金，3-件数
            if(2 == type){
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyc).reversed());
            }else if(3 == type){
                rankInfoList.sort(Comparator.comparingInt(PractitionerRankInfo::getCount).reversed());
            }else{
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyp).reversed());
            }
            AclCustomerFortuneStatistics fortuneStatistics;
            int rank = 1;
            Long practitionerIdForOnLine;
            String practitionerIdItem;
            for(PractitionerRankInfo practitionerItem : rankInfoList){
                //更新对象里面的内容，将PractitionerIdForOnLine里的信息赋值到PractitionerId
                practitionerIdForOnLine = practitionerItem.getPractitionerIdForOnLine();
                if(practitionerIdForOnLine != null){
                    practitionerItem.setPractitionerId(practitionerIdForOnLine.toString());
                }
                practitionerIdItem = practitionerItem.getPractitionerId();
                if(rank <= 10){//排名
                    fortuneStatistics = new AclCustomerFortuneStatistics();
                    BeanUtils.copyProperties(practitionerItem,fortuneStatistics);
                    fortuneStatistics.setSubordinateSystemName(practitionerItem.getSpcDivName());
                    fortuneStatistics.setRank(rank);
                    rankList.add(fortuneStatistics);
                }
                if(practitionerId.equals(practitionerIdItem)){//赋值
                    BeanUtils.copyProperties(practitionerItem,practitionerInfo);
                    practitionerInfo.setRank(rank);
                    if(rank > 10){
                        break;
                    }
                }
                rank ++;
            }
        }
        responseVO.setPractitionerInfo(practitionerInfo);
        responseVO.setRank(rankList);
    }
}
