package com.yd.dal.service.practitioner;

import com.yd.dal.entity.practitioner.PractitionerSubordinateInfo;
import com.yd.dal.mapper.practitioner.PractitionerSubordinateMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("practitionerSubordinateDALService")
public class PractitionerSubordinateDALService {

    @Autowired
    private PractitionerSubordinateMapper practitionerSubordinateMapper;
    /**
     * 根据体系ID获取体系相关信息
     * @param subordinateId 体系ID
     * @return
     */
    public PractitionerSubordinateInfo findSubordinateInfo(Long subordinateId) {
        PractitionerSubordinateInfo subordinateInfo = null;
        if(subordinateId != null){
            subordinateInfo = practitionerSubordinateMapper.findSubordinateInfo(subordinateId);
        }
        return subordinateInfo;
    }
}
