package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_practitioner_potential
 * @author 
 */
@Data
public class AclPractitionerPotential implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 姓名
     */
    private String name;

    /**
     * 年龄
     */
    private Long age;

    /**
     * 1=Male, 2=Female
     */
    private Integer gender;

    /**
     * 从业人员电话
     */
    private String mobileNo;

    /**
     * 从业人员微信号
     */
    private String wechatId;

    /**
     * 从业人员QQ号
     */
    private String qqId;

    /**
     * 其他联系方式
     */
    private String othersContacts;

    /**
     * 教育程度
     */
    private String educationLevel;

    /**
     * 介绍人
     */
    private String introducer;

    /**
     * 标签
     */
    private String tag;

    /**
     * 备注
     */
    private String remark;

    /**
     * FK ag_drop_master.id 来源
     */
    private Long resourceDropMasterId;

    /**
     * 简历附件
     */
    private String ossPathResume;

    /**
     * FK ag_acl_practitioner.id 指派团队长
     */
    private String practitionerAssignedIds;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 分析建置时间
     */
    private Date createdAt;

    /**
     * 建置者 FK ag_acl_user.id
     */
    private Long createdBy;

    /**
     * 更新时间
     */
    private Date updatedAt;

    /**
     * 更新者 FK ag_acl_user.id
     */
    private Long updatedBy;

    private static final long serialVersionUID = 1L;

    private Integer creatorType;

    private Integer updaterType;

    private Long customerId;

}