package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_customer_fortune
 * @author 
 */
@Data
public class AclCustomerFortune implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_customer_share.id
     */
    private Long shareId;

    /**
     * FK ag_acl_customer.id
     */
    private Long customerId;

    /**
     * FK ag_po_order.id
     */
    private Long orderId;

    private Date orderDate;

    private BigDecimal orderPrice;

    /**
     * FK ag_product_plan_commission，ag_product_life_plan_commission银盾来佣佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 银盾来佣佣金
     */
    private BigDecimal commissionAmount;

    /**
     * FK ag_product_plan_commission，ag_product_life_plan_commission公告佣金率
     */
    private BigDecimal announcementCommissionRate;

    /**
     * 公告佣金
     */
    private BigDecimal announcementCommissionAmount;

    /**
     * FK ag_acl_channel_referral_rate个人职级佣金率
     */
    private BigDecimal gradeCommissionRate;

    /**
     * %=referral amount / order price 
     */
    private BigDecimal referralRate;

    private BigDecimal referralAmount;

    /**
     * 扣除6个点的企业增值税（6%）
     */
    private BigDecimal referralAmountAfterValueadded;

    /**
     * 0=No, 1=Yes
     */
    private Integer isTax;

    private BigDecimal taxAmount;

    private BigDecimal netAmount;

    /**
     * FK ag_md_mk_campaign.id
     */
    private Long campaignId;

    /**
     * 可提现日期，在生产记录时就算好
     */
    private Date withdrawableDate;

    /**
     * FK ag_acl_customer_fortune_withdraw.id 提现表的id
     */
    private Long withdrawedId;

    /**
     * FK ag_acl_customer_fortune_pay.id 支付表的id
     */
    private Long fortunePayedId;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * FK ag_acl_customer.id
     */
    private Long createdBy;

    private static final long serialVersionUID = 1L;
}