package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclPractitionerSubordinateSystem;
import com.yd.dal.entity.customer.practitioner.PractitionerSubordinateInfo;
import com.yd.dal.mapper.customer.AclPractitionerSubordinateSystemMapper;
import com.yd.dal.service.customer.AclPractitionerSubordinateSystemDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("aclPractitionerSubordinateSystemDALService")
public class AclPractitionerSubordinateSystemDALServiceImpl implements AclPractitionerSubordinateSystemDALService {

    @Resource
    private AclPractitionerSubordinateSystemMapper aclPractitionerSubordinateSystemMapper;
    /**
     * 根据体系ID获取体系相关信息
     * @param subordinateId 体系ID
     * @return
     */
    public PractitionerSubordinateInfo findSubordinateInfo(Long subordinateId) {
        PractitionerSubordinateInfo subordinateInfo = null;
        if(subordinateId != null){
            subordinateInfo = aclPractitionerSubordinateSystemMapper.findSubordinateInfo(subordinateId);
        }
        return subordinateInfo;
    }

    @Override
    public AclPractitionerSubordinateSystem findByPractitionerId(Long practitionerId) {
        return aclPractitionerSubordinateSystemMapper.findByPractitionerId(practitionerId);
    }

    @Override
    public List<AclPractitionerSubordinateSystem> findByOwnerPractitionerId(Long practitionerId) {
        return aclPractitionerSubordinateSystemMapper.findByOwnerPractitionerId(practitionerId);
    }
    @Override
    public List<AclPractitionerSubordinateSystem> findByOwner(Long practitionerId) {
        return aclPractitionerSubordinateSystemMapper.findByOwner(practitionerId);
    }
}
