package com.yd.api.agms.service.impl;

import com.github.pagehelper.PageInfo;
import com.google.common.base.Strings;
import com.yd.api.agms.service.AgmsStatisticsService;
import com.yd.api.agms.vo.statistics.*;
import com.yd.api.commission.service.CommissionService;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.AclPractitioner;
import com.yd.dal.entity.meta.MdDropOptions;
import com.yd.dal.service.customer.AclPractitionerDALService;
import com.yd.dal.service.marketing.MktLeadsPoolDALService;
import com.yd.dal.service.meta.MdDropOptionsDALService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import com.yd.util.page.PageInfoUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.*;

@Service("agmsStatementService")
public class AgmsStatisticsServiceImpl implements AgmsStatisticsService {
    @Autowired
    private CommissionService commissionService;
    @Autowired
    private MktLeadsPoolDALService mktLeadsPoolDALService;
    @Autowired
    private MdDropOptionsDALService mdDropOptionsDALService;
    @Autowired
    private AclPractitionerDALService aclPractitionerDALService;
//    @Autowired
//    private MdCityDALService mdCityDALService;
    @Override
    public FinancialStatisticsResponseVO financialPredictStatistics(FinancialStatisticsRequestVO requestVO, HttpServletResponse response) {
        FinancialStatisticsResponseVO responseVO = new FinancialStatisticsResponseVO();
        PageInfo<statementData> pageInfo = requestVO.getPageInfo();
        String inCommissionDateSpan = requestVO.getInCommissionDateSpan();//来佣开始时间
        String outCommissionDateSpan = requestVO.getOutCommissionDateSpan();//发佣开始时间
        String inCommissionStartTime = null;//来佣开始时间
        String inCommissionEndTime = null;//发佣开始时间
        String outCommissionStartTime= null;//来佣开始时间
        String outCommissionEndTime= null;//发佣开始时间
        if(!Strings.isNullOrEmpty(inCommissionDateSpan)){
            String[] inDataSpan = inCommissionDateSpan.split(":");
            if(inDataSpan.length == 1){
                inCommissionStartTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(inDataSpan[0],"yyyy-MM-dd"),"yyyyMM");
            }else if(inDataSpan.length == 2){
                inCommissionStartTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(inDataSpan[0],"yyyy-MM-dd"),"yyyyMM");
                inCommissionEndTime = getTime(inDataSpan[1]);
//                inCommissionEndTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(inDataSpan[1],"yyyy-MM-dd"),"yyyyMM");
            }
        }
        if(!Strings.isNullOrEmpty(outCommissionDateSpan)){
            String[] outDataSpan = outCommissionDateSpan.split(":");
            if(outDataSpan.length == 1){
                outCommissionStartTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(outDataSpan[0],"yyyy-MM-dd"),"yyyyMM");
            }else if(outDataSpan.length == 2){
                outCommissionStartTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(outDataSpan[0],"yyyy-MM-dd"),"yyyyMM");
                outCommissionEndTime = getTime(outDataSpan[1]);
//                outCommissionEndTime = CommonUtil.dateParseString(CommonUtil.stringParseDate(outDataSpan[1],"yyyy-MM-dd"),"yyyyMM");
            }
        }
        String insurerBranchId = requestVO.getInsurerBranchId();//分公司
        String deptId = requestVO.getDeptId();//营业部
        String subordinateId = requestVO.getSubordinateId();//体系
        Integer type = requestVO.getType();
        Integer isStatement = requestVO.getIsStatement();
        if(isStatement == 1){
            List<statementData> dataList = commissionService.getStatementData(isStatement,type, inCommissionStartTime, outCommissionStartTime,inCommissionEndTime,outCommissionEndTime,insurerBranchId,deptId,subordinateId);
            createCSV(type,dataList,response);
        }else{
            PageInfo<statementData> dataPage = commissionService.getStatementDataByPage(pageInfo.getPageNum(),pageInfo.getSize(),isStatement,type, inCommissionStartTime, outCommissionStartTime,inCommissionEndTime,outCommissionEndTime,insurerBranchId,deptId,subordinateId);
            responseVO.setPredictStatementDataList(dataPage);
        }
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public LeadsStatisticsResponseVO leadsStatistics(LeadsStatisticsRequestVO requestVO, HttpServletResponse response) {
        LeadsStatisticsResponseVO responseVO = new LeadsStatisticsResponseVO();
        Integer expertApplyStatus = requestVO.getExpertApplyStatus(),leadsStatus = requestVO.getLeadsStatus();
        String leadsDateSpan = requestVO.getLeadsDateSpan();
        PageInfo<LeadsStatisticsInfo> requestPage = requestVO.getPageInfo();
        //1、查询商机信息
        List<LeadsStatisticsInfo> resultList;
        List<LeadsStatisticsInfo> leadsInfos = getLeadsInfoByDate(leadsDateSpan);
        if(leadsInfos != null && leadsInfos.size() > 0){
            if(leadsStatus != null && leadsStatus == 1){//未派遣的商机
                resultList = getIsNotAssignLeads(leadsInfos);
            }else{
                //2、查询商机的派遣情况
                List<LeadsStatisticsInfo> isAssignLeadsInfos = mktLeadsPoolDALService.findIsAssignLeads();
                Map<Long,LeadsStatisticsInfo> leadsAssignMap = new HashMap<>();
                if(isAssignLeadsInfos != null && isAssignLeadsInfos.size() > 0){
                    isAssignLeadsInfos.forEach(i->leadsAssignMap.put(i.getAssignId(),i));
                }
                //3、商机状态
                Map<Long,Long> leadsStatusMap = mktLeadsPoolDALService.findLeadsStatusMap();

                //4、商机状态信息
                List<MdDropOptions> dropList = mdDropOptionsDALService.findByDropMasterCodes(Arrays.asList("leads_manual_blood_type","leads_manual_zodiac_type","leads_manual_source","bizchance_promotion_action"));
                Map<Long,String> dropMap = new HashMap<>();
                if(dropList != null && dropList.size() > 0){
                    dropList.forEach(i->dropMap.put(i.getId(),i.getDropOptionName()));
                }
                //5、经纪人信息
                List<AclPractitioner> practitionerList = aclPractitionerDALService.findAll();
                Map<Long,AclPractitioner> practitionerMap = new HashMap<>();
                if(practitionerList != null && practitionerList.size()>0){
                    practitionerList.forEach(i->practitionerMap.put(i.getId(),i));
                }
                /*
                //6、城市信息
                List<MdCity> cityList = mdCityDALService.findByInsurerId(2L);
                Map<Long,String> cityMap = new HashMap<>();
                if(cityList != null && cityList.size() > 0 ){
                    cityList.forEach(i->cityMap.put(i.getId(),i.getCityName()));
                }
                */
                //7、整理信息
                resultList = integrateResponse(leadsInfos,leadsAssignMap,leadsStatusMap,dropMap,practitionerMap);
                //8、安装条件筛选
                resultList = screenResult(resultList,leadsStatus,expertApplyStatus);
            }
            PageInfo<LeadsStatisticsInfo> pageInfoResult = PageInfoUtils.list2PageInfo(resultList,requestPage.getPageNum(),requestPage.getPageSize());
            responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
            responseVO.setStatisticsPageInfo(pageInfoResult);
        }else{
            responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("820001")));
        }
        return responseVO;
    }

    /**
     * 按照条件筛选
     * @param resultList 结果集
     * @param leadsStatus 0/null：全部，1：未派遣，2：已派遣
     * @param expertApplyStatus 0/null：全部，1：未申请，2：申请中，3：已指派，
     */
    private List<LeadsStatisticsInfo> screenResult(List<LeadsStatisticsInfo> resultList, Integer leadsStatus, Integer expertApplyStatus) {
        List<LeadsStatisticsInfo> isAssignList,unapplyList,applyingList,isAssignExpertList;
        isAssignList = new ArrayList<>();
        for(LeadsStatisticsInfo item : resultList){
            if(item.getAssignId() != null){
                isAssignList.add(item);
            }
        }
        if(expertApplyStatus == null || expertApplyStatus == 0){//已派遣的全部
            return isAssignList;
        }else if(!isAssignList.isEmpty()){
            unapplyList = new ArrayList<>();
            applyingList = new ArrayList<>();
            isAssignExpertList = new ArrayList<>();
            for(LeadsStatisticsInfo item : isAssignList) {
                if (item.getRequestSMEDate() == null) {
                    unapplyList.add(item);//未申请
                }else{
                    if(item.getAssignSMEDate() == null){
                        applyingList.add(item);//申请中
                    }else{
                        isAssignExpertList.add(item);//已派遣专家
                    }
                }
            }
            if(expertApplyStatus == 1){//未申请
                return unapplyList;
            }else if(expertApplyStatus == 2){//申请中
                return applyingList;
            }else if(expertApplyStatus == 3){//已指派
                return isAssignExpertList;
            }else{//全部
                return isAssignList;
            }
        }
        return resultList;
    }

    /**
     * 整合响应信息
     * @param leadsInfos 商机信息
     * @param leadsAssignMap 商机派遣信息
     * @param leadsStatusMap 商机状态信息
     * @param dropMap 基础信息
     * @param practitionerMap 经纪人信息
     * @return 整合信息
     */
    private List<LeadsStatisticsInfo> integrateResponse(List<LeadsStatisticsInfo> leadsInfos, Map<Long, LeadsStatisticsInfo> leadsAssignMap, Map<Long, Long> leadsStatusMap, Map<Long, String> dropMap, Map<Long, AclPractitioner> practitionerMap) {
        List<LeadsStatisticsInfo> resultList = new ArrayList<>();
        Long assignId,leadsCustomerId,smePractitionerId,practitionerId;
        LeadsStatisticsInfo assignInfo;
        AclPractitioner practitioner,smePractitioner;
        for (LeadsStatisticsInfo item : leadsInfos){
            assignId = item.getAssignId();
            leadsCustomerId = item.getLeadsCustomerId();
            item.setLeadsSource(dropMap.get(item.getLeadsSourceId()));
            item.setLeadsStatus(dropMap.get(leadsStatusMap.get(leadsCustomerId)));
            item.setLeadsBloodType(dropMap.get(item.getLeadsBloodTypeId()));
            item.setLeadsZodiacType(dropMap.get(item.getLeadsZodiacTypeId()));
            assignInfo = leadsAssignMap.get(assignId);
            if(assignInfo != null && leadsCustomerId.equals(assignInfo.getLeadsCustomerId())){
                practitionerId = assignInfo.getPractitionerId();
                smePractitionerId = assignInfo.getSmePractitionerId();
                if(practitionerId != null){//经纪人
                    practitioner = practitionerMap.get(practitionerId);
                    item.setPractitionerId(practitionerId);
                    item.setPractitionerName(practitioner.getName());
                    item.setPractitionerMobileNo(practitioner.getMobileNo());
                }
                if(smePractitionerId != null){//专家
                    smePractitioner = practitionerMap.get(smePractitionerId);
                    item.setSmePractitionerId(smePractitionerId);
                    item.setSme(smePractitioner.getName());
                    item.setSmeMobileNo(smePractitioner.getMobileNo());
                }
                item.setRequestSMEDate(assignInfo.getRequestSMEDate());
                item.setAssignSMEDate(assignInfo.getAssignSMEDate());
                item.setSmePractitionerId(assignInfo.getSmePractitionerId());
                item.setPredictFYC(assignInfo.getPredictFYC());
                item.setPredictFYP(assignInfo.getPredictFYP());
                item.setPredictPieces(assignInfo.getPredictPieces());
                item.setDealTime(assignInfo.getDealTime());
            }
            resultList.add(item);
        }
        return resultList;
    }


    //塞选未分配的商机
    private List<LeadsStatisticsInfo> getIsNotAssignLeads(List<LeadsStatisticsInfo> leadsInfos) {
        List<LeadsStatisticsInfo> resultList = new ArrayList<>();
        if(leadsInfos != null && leadsInfos.size() > 0){
            for(LeadsStatisticsInfo item : leadsInfos){
                if(item.getPractitionerId() == null){
                    resultList.add(item);
                }
            }
        }
        return resultList;
    }


    /**
     * 获取商机
     * @param leadsDateSpan 商机时间
     * @return 商机列表
     */
    private List<LeadsStatisticsInfo> getLeadsInfoByDate(String leadsDateSpan) {
        String leadsStartTime = null,leadsEndTime = null;
        if(!Strings.isNullOrEmpty(leadsDateSpan)){
            String[] dateStr = leadsDateSpan.split(":");
            if(dateStr.length == 1){
                leadsStartTime = dateStr[0];
            }else{
                leadsStartTime = dateStr[0];
                leadsEndTime = dateStr[1];
            }
        }
        return mktLeadsPoolDALService.findALLByDate(leadsStartTime,leadsEndTime);
    }

    private String getTime(String time) {
        Date date = CommonUtil.stringParseDate(time,"yyyy-MM-dd");
        if(date != null){
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(Calendar.DAY_OF_MONTH,-1);
            date = calendar.getTime();
        }
        return CommonUtil.dateParseString(date,"yyyyMM");
    }

    private void createCSV(Integer type, List<statementData> dataList, HttpServletResponse response) {
        String CSV_COLUMN_SEPARATOR = ",";//CSV文件列分隔符
        String CSV_ROW_SEPARATOR = "\r\n";//CSV文件行分隔符
        String charset = "UTF-8"; // 读取字符编码
        String[] columnName ;
        String tableName ;
        if(type == 2){
            tableName = "YD_FinancialStatement_predict_";
            columnName = new String[]{"序号","预估来佣年月","预估发佣年月","保单号","分公司","营业部","体系","经纪人姓名","员工编号","职阶","职阶率","保费","FYC","RYC","应收佣金","应发佣金","佣奖类型"};
        }else{
            tableName = "YD_FinancialStatement_actual_";
            columnName = new String[]{"序号","实际来佣年月","实际发佣年月","保单号","分公司","营业部","体系","经纪人姓名","员工编号","职阶","职阶率","保费","FYC","RYC","应收佣金","应发佣金","佣奖类型"};
        }
        // 保证线程安全
        StringBuilder buf = new StringBuilder();
        // 组装表头
        for (String title : columnName) {
            buf.append(title).append(CSV_COLUMN_SEPARATOR);
        }
        buf.append(CSV_ROW_SEPARATOR);
        // 组装数据
        if (CollectionUtils.isNotEmpty(dataList)) {
            for (int i = 0; i < dataList.size(); i++) {
                statementData statementData = dataList.get(i);//遍历每个对象
                buf.append(i + 1).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getInCommissionTime()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getOutCommissionTime()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getPolicyNo()+"\t").append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getInsurerBranch()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getDept()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getSubordinate()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getPractitioner()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getPractitionerIdEG()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getTitle()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getTitleRate()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getPremium()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getFYC()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getRYC()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getRightReceiveCommission()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getRightPayCommission()).append(CSV_COLUMN_SEPARATOR);
                buf.append(statementData.getCommissionType()).append(CSV_COLUMN_SEPARATOR);
                buf.append(CSV_ROW_SEPARATOR);
            }
        }
        // 设置文件后缀
        String fn = tableName + System.currentTimeMillis()  + ".csv";
        String headStr = "attachment; filename=\"" + fn + "\"";
        // 设置响应
        response.setContentType("APPLICATION/ms-csv.numberformat");
        response.setCharacterEncoding(charset);
        response.setHeader("Content-Disposition", headStr);
        response.setHeader("Cache-Control", "max-age=30");
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        response.setHeader("Pragma", "public");
        OutputStream os = null;
        try {
            os = response.getOutputStream();
            os.write(buf.toString().getBytes("GBK"));
            os.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }finally {
            if(os != null){
                try {
                    os.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

    }
}
