package com.yd.api.practitioner;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.libs.pdf.*;
import com.yd.util.PDFConfiguration;

public class PractitionerPDFTest {
    /**
     * 填充数据源
     * 其中data存放的key值与pdf模板中的文本域值相对应
     */
    public static Map<String, String> initData() {
        String secondSignature = "张亮";
        String secondPartyIDNo = "330127199611154184";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String secondSignatureDate = format.format(new Date());

        Map<String, String> data = new HashMap<String, String>();
        //1页
        data.put("contactNo", "C-SH-0001");
        data.put("practitionerNo", "YDSH00127");
        data.put("subsystem", "抱一");
        data.put("practitioner", secondSignature);
        data.put("idNo", secondPartyIDNo);
        data.put("residentAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("mobileNo", "13661741633");
        //7页
        data.put("firstParty", "上海银盾保险经纪有限公司");
        data.put("firstPartyResponser", "上海银盾保险经纪有限公司");
        data.put("firstPartyAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");

        data.put("secondParty", secondSignature);
        data.put("secondPartyIDNo", secondPartyIDNo);
        data.put("secondPartyAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondMobileNo", "1366668888");
        data.put("secondSubsystemOwner", "陈欢欢");
        data.put("secondSubsystemSignature", "陈欢欢");
        data.put("secondSubsystemIDNo", "330127199611156403");
        data.put("secondSubsystemAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondSubsystemMobileNo", "1366668888");
        data.put("secondMentor", "陈欢欢");
        data.put("secondMentorIDNo", "330127199611158003");
        data.put("secondMentorAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondMentorMobileNo", "1366668888");
        data.put("contactYear", "2120");
        data.put("contactMonth", "12");
        data.put("contactDay", "16");
        //8页
        data.put("secondParty801", secondSignature);
        data.put("secondBirthYear801", "1989");
        data.put("secondBirthMonth801", "10");
        data.put("secondBirthDay801", "09");
        data.put("secondPartyIDNo801", secondPartyIDNo);
        data.put("secondPartyPermanentResidenceAddress", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondPartyAddress801", "上海市浦东新区张杨路560号中融恒瑞国际西楼1706室");
        data.put("secondMobileNo801", "1366668888");
        data.put("secondPractitionerRegNo", "26961531000080062020000314");
        data.put("secondEmail", "2120@163.com");
        data.put("secondWorkingExperience1", "嫦娥5号登月");
        data.put("secondWorkingPosition1", "项目总工");
        data.put("secondWorkingPeriod1", "2016.12~至今");
        data.put("secondWorkingExperience2", "嫦娥4号登月");
        data.put("secondWorkingPosition2", "姿态调整工程师");
        data.put("secondWorkingPeriod2", "2014.11~2016.10");
        data.put("secondWorkingExperience3", "嫦娥3号登月");
        data.put("secondWorkingPosition3", "动力工程执掌");
        data.put("secondWorkingPeriod3", "2012.03~2014.10");
        data.put("secondWorkingExperience4", "嫦娥2号登月");
        data.put("secondWorkingPosition4", "固态燃料冷凌技师");
        data.put("secondWorkingPeriod4", "2010.07~2012.01");
        data.put("secondBankAccount", secondSignature);
        data.put("secondBankAccountOpening", "上海市工商银行齐齐哈尔路支行");
        data.put("secondBankAccountID", "6222001001234567890");
        data.put("secondMentor802", "陈欢欢");
        data.put("secondIntroducer", "陈欢欢");
        data.put("secondMentorIDNo801", "330127199611151346");
        data.put("secondIntroducerIDNo", "330127199611156403");

        data.put("secondEffectiveYear", "2120");
        data.put("secondEffectiveMonth", "12");
        data.put("secondEffectiveDay", "30");
        data.put("secondParty802", secondSignature);
        data.put("secondMentor801", "陈欢欢");
        data.put("secondSubsystem", "抱一");
        data.put("secondSubsystemNo", "HUGONE");
        data.put("secondSubsystemManager", "陈欢欢");
        data.put("secondSubsystemMaster", "陈欢欢");
        data.put("secondBranchManager", "王子帷");
        data.put("secondBranchMaster", "王子帷");
        data.put("secondCenterHr", "EVEN");
        data.put("secondCenterCEO", "SHARON");

        //9页

        //10页
        data.put("secondSignatureDate1001", secondSignatureDate);
        //12页
        data.put("secondParty1201", secondSignature);
        data.put("secondSignatureDate1201", secondSignatureDate);
        //14页
        data.put("secondParty1401", secondSignature);
        data.put("secondSignatureDate1401", secondSignatureDate);
        //16页
        data.put("secondParty1601", secondSignature);
        data.put("secondPartyIDNo1601", secondPartyIDNo);
        data.put("secondSignatureDate1601", secondSignatureDate);

        return data;
    }

    public static Map<String, String> initImage() {
        Map<String, String> images = new HashMap<String, String>();
        images.put("secondPersonerPicture", "D:\\pcs12\\secondPersonerPicture.png");
        //印章从配置文件读
        String signImage = PDFConfiguration.getProperty("pdf.signImage");
        images.put("yindunESignature1001", signImage);
        images.put("yindunESignature1201", signImage);
        images.put("yindunESignature1401", signImage);

        images.put("secondSignature1001", "D:\\pcs12\\signature.png");
        images.put("secondSignature1201", "D:\\pcs12\\signature.png");
        images.put("secondSignature1401", "D:\\pcs12\\signature.png");
        images.put("secondSignature1601", "D:\\pcs12\\signature.png");

        images.put("secondIDFrontPageImage", "D:\\pcs12\\IDFront.jpg");
        images.put("secondIDBackPageImage", "D:\\pcs12\\IDBack.jpg");
        images.put("secondBankCardImage", "D:\\pcs12\\bank.jpg");

        //选中或不选中从配置文件读
        String checkFile = PDFConfiguration.getProperty("pdf.check");
        String unCheckFile = PDFConfiguration.getProperty("pdf.uncheck");

        images.put("secondIDType1", checkFile);
        images.put("secondIDType2", unCheckFile);
        images.put("secondIDType3", unCheckFile);
        images.put("secondIDType4", unCheckFile);

        images.put("secondPersonalStatement1", checkFile);
        images.put("secondPersonalStatement2", unCheckFile);
        images.put("secondPersonalStatement3", unCheckFile);
        images.put("secondPersonalStatement4", unCheckFile);
        images.put("secondPersonalStatement5", unCheckFile);
        images.put("secondPersonalStatement5", unCheckFile);

        images.put("secondPosition1", checkFile);
        images.put("secondPosition2", unCheckFile);
        images.put("secondPosition3", unCheckFile);
        images.put("secondPosition4", unCheckFile);
        images.put("secondPosition5", unCheckFile);
        images.put("secondPosition6", unCheckFile);

        return images;
    }

    public static void main(String[] args) throws Exception {
        //PDF模板文件
        String templatePDF = "D:\\pcs12\\templatePractitionerContract.pdf";
        templatePDF = PDFConfiguration.getProperty("pdf.template");
        //模板文件生成零时文件
        String tmpPathPDF = PDFConfiguration.getProperty("pdf.temp.path");
        String practitionerNO = "SH000012";

        //PDF模板输出结果文件
        String templateResultPDF = tmpPathPDF + practitionerNO + "-template.pdf";
        //初始化模板数据
        Map<String, String> dt = initData();
        Map<String, String> img = initImage();
        //按模板填充数据生成结果PDF
        PDFTemplate.generatePDF(templatePDF,templateResultPDF,dt,img);

        //准备加盖电子印章的源文件
        String signSourcePDF = templateResultPDF;

        //电子印章文件
        String signImage="D:\\pcs12\\上海银盾保险经纪有限公司.png";
        signImage = PDFConfiguration.getProperty("pdf.signImage");
        //加盖电子印章结果文件
        String signResultPDF = "D:\\pcs12\\signedYD.pdf";
        signResultPDF = tmpPathPDF + practitionerNO + "-signedYD.pdf";

        String password="UC645YlB";
        //password = readFileTxt(PDFConfiguration.getProperty("pdf.keyPasswordFile"));

        String keyStorePath="D:\\pcs12\\4929078_m.zuihuibi.cn.pfx";
        keyStorePath = PDFConfiguration.getProperty("pdf.keyStorePath");;

        float x = 450;
        float y = 150;
        x = Float.parseFloat(PDFConfiguration.getProperty("pdf.position.x"));
        y = Float.parseFloat(PDFConfiguration.getProperty("pdf.position.y"));
        PDFSign.sign(signResultPDF,password,keyStorePath,signSourcePDF,signImage,13,x,y);
    }

    private static String readFileTxt(String filePath) {
        String line = null;
        try
        {
            FileReader fr=new FileReader(filePath);

            //为了提高效率，加入缓冲技术，将字符读取流对象作为参数传递给缓冲对象的构造函数
            BufferedReader bufr=new BufferedReader(fr);

            while((line=bufr.readLine())!=null)
            {
                System.out.println(line);
            }
            bufr.close();//close()中已经包含了flush
        } catch (IOException e) {
            e.printStackTrace();
        }

        return line;
    }
}

