package com.yd.api.customer.service;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.github.pagehelper.PageInfo;
import com.yd.api.customer.vo.CustomerQueryRequestVO;
import com.yd.api.customer.vo.CustomerQueryResponseVO;
import com.yd.api.customer.vo.CustomerVO;
import com.yd.dataccess.entity.customer.Customer;
import com.yd.dataccess.service.customer.CustomerDA;
import com.yd.util.page.PaginationInfo;

@Service("customerServiceImpl")
public class CustomerServiceImpl implements CustomerService{

	@Autowired
    private CustomerDA customerServiceDA;

	@Override
	public List<CustomerVO> listAllCustomer() {
		List<CustomerVO> listTo =new ArrayList<CustomerVO>();
		List<Customer> list = new ArrayList<Customer>();
		list = customerServiceDA.listAllCustomers();
		CustomerVO oneDestVO;
    	for(Customer oneSrc:list)
    	{
    		oneDestVO = new CustomerVO();
    		BeanUtils.copyProperties(oneSrc, oneDestVO);
    		listTo.add(oneDestVO);
    	}
		return listTo;
	}
	
	@Override
	public CustomerQueryResponseVO findByPage(CustomerQueryRequestVO customerQueryRequestVO)
	{
		CustomerQueryResponseVO customerQueryResponseVO = new CustomerQueryResponseVO();
		
		PageInfo<Customer> page = customerQueryRequestVO.getPage();

		PageInfo<Customer> list = customerServiceDA.findByPage(page.getPageNum(), page.getSize());
  	
    	customerQueryResponseVO.setCustomerId(customerQueryRequestVO.getCustomerId());
    	
    	customerQueryResponseVO.setCustomerPage(list);
    	
		return customerQueryResponseVO;
	}	
}

