package com.yd.dal.service.meta.impl;

import com.yd.dal.entity.meta.MdPractitionerHiringApproveSteps;
import com.yd.dal.mapper.meta.MdPractitionerHiringApproveStepsMapper;
import com.yd.dal.service.meta.MdPractitionerHiringApproveStepsDALService;
import com.yd.util.deshandler.DESTypeHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("mdPractitionerHiringApproveStepsDALService")
public class MdPractitionerHiringApproveStepsDALServiceImpl implements MdPractitionerHiringApproveStepsDALService {

    private MdPractitionerHiringApproveStepsMapper mdPractitionerHiringApproveStepsMapper;

    @Autowired
    public void setMdPractitionerHiringApproveStepsMapper(MdPractitionerHiringApproveStepsMapper mdPractitionerHiringApproveStepsMapper) {
        this.mdPractitionerHiringApproveStepsMapper = mdPractitionerHiringApproveStepsMapper;
    }

    @Override
    public List<MdPractitionerHiringApproveSteps> findAll() {
        return mdPractitionerHiringApproveStepsMapper.findAll();
    }

    @Override
    public List<MdPractitionerHiringApproveSteps> findByPractitionerLevel(String practitionerLevelId) {
        return mdPractitionerHiringApproveStepsMapper.findByPractitionerLevel(practitionerLevelId);
    }

    @Override
    public List<MdPractitionerHiringApproveSteps> findByAppointedApprovePractitioners(String appointedApprovePractitioners) {
        DESTypeHandler desTypeHandler = new DESTypeHandler();
        appointedApprovePractitioners = desTypeHandler.decode(appointedApprovePractitioners);
        return mdPractitionerHiringApproveStepsMapper.findByAppointedApprovePractitioners(appointedApprovePractitioners);
    }
}
