package com.yd.dal.entity.customer;

import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
    * customer withdrawl record
    */
@Data
public class AclCustomerFortuneWithdraw {
    /**
    * serial id
    */
    private Long id;

    /**
    * FK ag_acl_customer.id
    */
    private Long customerId;

    /**
    * FK ag_acl_customer_lottery_draws.id
    */
    private Long lotteryDrawsId;

    /**
    * balance before withdrawal
    */
    private BigDecimal withdrawBeforeAmount;

    private BigDecimal withdrawAmount;

    /**
    * balance after withdrawal
    */
    private BigDecimal withdrawAfterAmount;

    /**
    * 0=No=申请中, 1=Yes=已付
    */
    private Integer isPaid;

    /**
    * Paid date by finance
    */
    private Date paidDate;

    private BigDecimal paidAmount;

    /**
    * 付款后的待缴税额
    */
    private BigDecimal taxAmount;

    /**
    * 1. Wechat red envelope 3. Bank
    */
    private Integer paidMethod;

    /**
    * 提现申请者
    */
    private String requestorName;

    /**
    * 证件类型 FK ag_md_id_type, 1=身份证 2=护照 4=台胞证 5=香港身份证
    */
    private Long requestorIdTypeId;

    /**
    * 证件号码
    */
    private String requestorId;

    /**
    * 申请者生日
    */
    private Date requestorBirthdate;

    /**
    * 申请者性别 1=Male, 2=Female
    */
    private Integer requestorGender;

    /**
    * 0=核实中, 1=已支付关帐, 2=取消
    */
    private Integer status;

    /**
    * 提现申请者wechat id (加入红包小助手)
    */
    private String wechatId;

    /**
    * 创建时间
    */
    private Date createdAt;

    /**
    * 创建人
    */
    private Long createdBy;
}