package com.yd.dal.service.meta.impl;

import com.yd.dal.entity.meta.ObjectCollectionTagged;
import com.yd.dal.mapper.meta.ObjectCollectionTaggedMapper;
import com.yd.dal.service.meta.ObjectCollectionTaggedDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("objectCollectionTaggedDALService")
public class ObjectCollectionTaggedDALServiceImpl implements ObjectCollectionTaggedDALService {
    @Resource
    private ObjectCollectionTaggedMapper objectCollectionTaggedMapper;

    @Override
    public List<ObjectCollectionTagged> findByObjectCollectionTagged(ObjectCollectionTagged objectCollectionTagged) {
        return objectCollectionTaggedMapper.findByObjectCollectionTagged(objectCollectionTagged);
    }

    @Override
    public void saveObjectCollectionTagged(ObjectCollectionTagged tagged) {
        objectCollectionTaggedMapper.insertSelective(tagged);
    }

    @Override
    public void updateObjectCollectionTagged(ObjectCollectionTagged tagged) {
        objectCollectionTaggedMapper.updateByPrimaryKeySelective(tagged);
    }
}
