package com.yd.api.commission.service.impl;

import com.yd.api.commission.service.LifeCommissionService;
import com.yd.api.commission.vo.lifecommission.ComeCommissionListResponseVO;
import com.yd.api.commission.vo.lifecommission.ComeCommissionVO;
import com.yd.api.commission.vo.lifecommission.QueryComeCommissionListRequestVO;
import com.yd.api.result.CommonResult;
import com.yd.dal.mapper.lifecommission.LifeCommissionMapper;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


import java.util.List;

@Service
public class LifeCommissionServiceImpl implements LifeCommissionService {

    @Autowired
    private LifeCommissionMapper lifeCommissionMapper;

    @Override
    public ComeCommissionListResponseVO queryComeCommissionList(QueryComeCommissionListRequestVO requestVO) {
        ComeCommissionListResponseVO resp = new ComeCommissionListResponseVO();

        try {
            List<ComeCommissionVO> dataList = lifeCommissionMapper.queryComeCommissionList(requestVO);

            resp.setDataList(dataList);
            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        } catch (Exception e) {
            e.printStackTrace();
            resp.setCommonResult(new CommonResult(false, e.getMessage()));
        }
        return resp;
    }
}
