package com.yd.util;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Locale;

/**
 * @description
 */
@Component
public class SpringContextUtil implements ApplicationContextAware {

    private static ApplicationContext applicationContext;
 
 
	@Override
    public void setApplicationContext(ApplicationContext applicationContext)
            throws BeansException {
        SpringContextUtil.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return SpringContextUtil.applicationContext;
    }
    // 传入线程中
    @SuppressWarnings("unchecked")
	public static <T> T getBean(String beanName) {
        return (T) applicationContext.getBean(beanName);
    }
    public static <T> T getBean(Class<T> t) {
        return SpringContextUtil.applicationContext.getBean(t);
    }
 
    // 国际化使用
    public static String getMessage(String key) {
    	String message = null;
    	try {
    		Locale locale = new Locale("zh", "CN");
			message = applicationContext.getMessage(key, null,locale);
		} catch (Exception e) {
			e.getMessage();
		}
        return message;
    }
 
 
    /// 获取当前环境
    public static String getActiveProfile() {
        return applicationContext.getEnvironment().getActiveProfiles()[0];
    }
    /**
     * 是否为本地环境
     * @return
     */
    public static boolean isLocal() {
        return "LOCAL".equals(getEnvironmentName());
    }
    /**
     * 是否为DEV环境
     * @return
     */
    public static boolean isDev() {
        return "DEV".equals(getEnvironmentName());
    }
    /**
     * 是否为STAGE环境
     * @return
     */
    public static boolean isStage() {
        return "STAGE".equals(getEnvironmentName());
    }
    /**
     * 是否为PROD环境
     * @return
     */
    public static boolean isProd() {
        return "PROD".equals(getEnvironmentName());
    }
    /**
     * 获取环境名字
     */
    public static String getEnvironmentName() {
        return getActiveProfile().toUpperCase();
    }
    /**
     * 获取IP地址时获取当前请求
     * @return
     */
    public static HttpServletRequest getRequest() {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.currentRequestAttributes();
        return attributes.getRequest();
    }
    /**
     * 获取当前请求的IP地址
     * @return
     */
    public static String getCurrentIpAddress()
    {
        String ip = "127.0.0.1";
        try
        {
            HttpServletRequest request = getRequest();
            ip = getIp(request);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ip;
    }
    /**
     * 通过请求头获得IP地址
     * @param request
     * @return
     * @throws Exception
     */
    public static String getIp(HttpServletRequest request) throws Exception{
        String ip = request.getHeader("X-Real-IP");
        if (!StringUtils.isBlank(ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader("X-Forwarded-For");
        if (!StringUtils.isBlank(ip) && !"unknown".equalsIgnoreCase(ip)) {
            // 多次反向代理后会有多个IP值，第一个为真实IP。
            int index = ip.indexOf(',');
            if (index != -1) {
                return ip.substring(0, index);
            } else {
                return ip;
            }
        } else {
            return request.getRemoteAddr();
        }
    }

}
