package com.yd.api.agms;

import com.yd.api.agms.service.AgmsDashboardService;
import com.yd.api.agms.service.AgmsStatementService;
import com.yd.api.agms.vo.dashboard.StatisticsOpportunityRequestVO;
import com.yd.api.agms.vo.dashboard.StatisticsOpportunityResponseVO;
import com.yd.api.agms.vo.dashboard.StatisticsPEPRequestVO;
import com.yd.api.agms.vo.dashboard.StatisticsPEPResponseVO;
import com.yd.api.agms.vo.statement.FinancialStatementRequestVO;
import com.yd.api.agms.vo.statement.FinancialStatementResponseVO;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

@Controller
@RestController
@RequestMapping("/agms")
public class AgmsController {
    @Autowired
    private AgmsStatementService agmsStatementService;
    @Autowired
    private AgmsDashboardService agmsDashboardService;

    /**
     * AGMS -- 财务管理报表
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/financialPredictStatement")
    public Object financialPredictStatement(@RequestBody FinancialStatementRequestVO requestVO, HttpServletResponse response){
        JsonResult result = new JsonResult();
        FinancialStatementResponseVO responseVO = agmsStatementService.financialPredictStatement(requestVO,response);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  寿险整体运营->PEP活动管理(根据公司)
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsPEP")
    public Object statisticsPEP(@RequestBody StatisticsPEPRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsPEPResponseVO responseVO = agmsDashboardService.statisticsPEP(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  寿险整体运营->商机预测(根据公司)
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsOpportunity")
    public Object statisticsOpportunity(@RequestBody StatisticsOpportunityRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsOpportunityResponseVO responseVO = agmsDashboardService.statisticsOpportunity(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
}
