package com.yd.dal.entity.customer;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * fortune record of customer
 */
@Data
public class AclCustomerFortune {
    private static final long serialVersionUID = 1L;
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_customer_share.id
     */
    private Long shareId;

    /**
     * FK ag_acl_customer.id
     */
    private Long customerId;

    /**
     * FK ag_po_order.id
     */
    private Long orderId;

    private Date orderDate;

    private BigDecimal orderPrice;

    /**
     * FK ag_product_plan_commission，ag_product_life_plan_commission银盾来佣佣金率
     */
    private BigDecimal commissionRate;

    /**
     * 银盾来佣佣金
     */
    private BigDecimal commissionAmount;

    /**
     * 公告佣金率存百分值
     */
    private BigDecimal fycRate;

    /**
     * 公告佣金
     */
    private BigDecimal fycAmount;

    /**
     * FK ag_acl_channel_referral_rate个人职级佣金率
     */
    private BigDecimal gradeCommissionRate;

    /**
     * 多个代理人财富分摊比例
     */
    private BigDecimal shareRate;

    /**
     * %=referral amount / order price
     */
    private BigDecimal referralRate;

    private BigDecimal referralAmount;

    /**
     * 发佣年月
     */
    private String monthPeriod;

    /**
     * 佣金类型
     */
    private String commissionType;

    /**
     * FK ag_md_drop_options.drop_option_code where master = Commission_Type,佣金项目类型编码
     */
    private String dropOptionCode;

    /**
     * 经纪人等级
     */
    private String practitionerLevel;

    /**
     * 0=No, 1=Yes
     */
    private Integer isTax;

    private BigDecimal taxAmount;

    private BigDecimal netAmount;

    /**
     * FK ag_md_mk_campaign.id
     */
    private Long campaignId;

    /**
     * 推广活动
     */
    private String campaignName;

    /**
     * 可提现日期，在生产记录时就算好
     */
    private Date withdrawableDate;

    /**
     * FK ag_acl_customer_fortune_payout_batch.id where payout_yearmonth = '2020-11-10',佣金预计发放批次
     */
    private Long payoutBatchId;

    /**
     * FK ag_md_drop_options.drop_option_code where master = Commission_Payout_Status,佣金发放状态
     * 待发佣-0	暂不可发-1 可发放-2 保留-3 已发并关账-4
     */
    private String commissionPayoutStatus;

    /**
     * 发放状态修改时间
     */
    private Date commissionPayoutAt;

    /**
     * FK ag_acl_user.id
     */
    private Long commissionPayoutBy;

    /**
     * FK ag_acl_customer_fortune_withdraw.id 提现表的id
     */
    private Long withdrawedId;

    /**
     * FK ag_acl_customer_fortune_pay.id 支付表的id
     */
    private Long fortunePayedId;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * FK ag_acl_customer.id
     */
    private Long createdBy;

    private Long ruleId;//关联结算规则ID
    private String ruleCode;//结算规则编码
    private String settlementType = "1";//结算类型(1.订单结算;2.经纪人结算;3.渠道结算;)
    private Long practitionerId;//经纪人ID
    private String channelId;//渠道ID
    private String insurerId;//保险公司id
    private String productId;//产品id
    private String calculationMethod;//计算方式(1.跟单生成;2.月末计算;3.季末计算;4:次年第一季度)
    private String calculationFormula;//计算公式
    private Date statisticStart;//统计开始时间
    private Date statisticEnd;//统计结束时间
    private String segmentVlaue;//分段计算值(默认为0,条件因子值在统计时间段内变化时,需要分段计算)
    private Date predictMonthPeriod;//预计发佣年月(YYYY-MM)
    private String status;//状态(0:作废;1:待发佣;2:可发放;3:保留;4:已关账)
    private Long commissionId;//来佣表ID
    private String commissionFlag;//佣金标记(1:手工佣金;)
    private Long coverIntroducerId;//关联经纪人ID
    private Integer commissionPeriod;//佣金期数(1=第一年; 2=第二年; 3=第三年; 4=第四年; 5=第五年)
    private String remark;//佣金备注
    private Double achievementsRate;//业绩比例
    private Double achievements;//业绩
    private Double examineFyc;//考核FYC
    private Double comprehensiveFyc;//综合业绩FYC
    /**
     * 更新时间
     */
    private Date updatedAt;
    private Long updatedBy;
}