package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_customer_membership
 * @author 
 */
@Data
public class AclCustomerMembership implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * FK ag_acl_customer.id
     */
    private Long customerId;

    /**
     * 购买客户姓名
     */
    private String customerName;

    /**
     * FK ag_md_member_voucher.id
     */
    private Long voucherId;

    /**
     * 购买或兑换时间
     */
    private Date purchaseDate;

    /**
     * 推送方案给enduser的时间
     */
    private Date approveDate;

    /**
     * 购买金额
     */
    private BigDecimal purchaseAmount;

    /**
     * 会员资格有效起日
     */
    private Date validFrom;

    /**
     * 会员资格有效终日
     */
    private Date validTo;

    /**
     * 0=No 1=Yes
     */
    private Integer isActive;

    private Date createdAt;

    private Long createdBy;

    /**
     * FK ag_po_order.id
     */
    private Long orderId;

    private Integer customerLevel;

    private Long planId;

    private static final long serialVersionUID = 1L;
}