package com.yd.dal.entity.customer;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * ag_acl_customer_system_log
 * @author 
 */
@Data
public class AclCustomerSystemLog implements Serializable {
    /**
     * 记录ID
     */
    private Long id;

    /**
     * 客户ID
     */
    private Long customerId;

    /**
     * 登录token
     */
    private String token;

    /**
     * 监控系统(1: 银盾经纪; 2: 银盾在线; 3: AGMS; 4: Goup)
     */
    private String fromSystem;

    /**
     * 开始使用时间
     */
    private Date startTime;

    /**
     * 结束使用时间
     */
    private Date endTime;

    /**
     * 是否启用(0=No, 1=Yes)
     */
    private Integer isActive;
    
    private Integer expiredMinute;

    private static final long serialVersionUID = 1L;
}