package com.yd.dal.service.marketing;

import com.yd.api.practitioner.vo.opportunity.SalesScoreDetail;
import com.yd.dal.entity.marketing.MktLeadsAssignedTrack;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public interface MktLeadsAssignedTrackDALService {
    List<MktLeadsAssignedTrack> findByMktLeadsAssignedTrack(MktLeadsAssignedTrack mktLeadsAssignedTrack);

    void saveTrack(MktLeadsAssignedTrack track);

    void updateTrack(MktLeadsAssignedTrack track);

    List<MktLeadsAssignedTrack> findByTrackTimeForNew(MktLeadsAssignedTrack mktLeadsAssignedTrack);

    /**
     * 计算经纪人得分统计
     * @param practitionerIds  经纪人id的list
     * @return 返回他们的分数统计 1.天得分 2.周得分 3.月得分
     */
    HashMap<String, BigDecimal> totalStatisticsForTeam(List<Long> practitionerIds);

    MktLeadsAssignedTrack findByListNotesForCustomerId(Long customerId);

    /**
     * 根据经纪人id及时间范围统计跟进状态次数
     * @param practitionerId 经纪人id
     * @param time 时间范围 今天:d 周:w 月:m
     * @return 跟进状态详情
     */
    List<SalesScoreDetail> getSalesScoreDetailByPractitionerId(Long practitionerId, String time);

    void deleteScheduleTrackById(Long scheduleTrackId);

    int updateInformedOssPathByInformedId(String ossPath, Long informedId);

    int updateCustomerIdByLeadsAssignedId(Long customerId, Long leadsAssignedId);
}
