package com.yd.dal.service.customer.impl;

import com.yd.dal.entity.customer.AclCustomer;
import com.yd.dal.mapper.customer.AclCustomerMapper;
import com.yd.dal.service.customer.AclCustomerDALService;
import com.yd.util.deshandler.DESTypeHandler;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("aclCustomerDalService")
public class AclCustomerDALServiceImpl implements AclCustomerDALService {

    @Autowired
    private AclCustomerMapper aclCustomerMapper;
    @Override
    public List<AclCustomer> findByLogin(String mobileNo) {
        return aclCustomerMapper.findByLogin(mobileNo);
    }

    @Override
    public void update(AclCustomer aclCustomer) {
        aclCustomerMapper.updateByPrimaryKeySelective(aclCustomer);
    }

    @Override
    public AclCustomer findById(Long customerId) {
        return aclCustomerMapper.selectByPrimaryKey(customerId);
    }

    @Override
    public void save(AclCustomer aclCustomer) {
        aclCustomerMapper.insertSelective(aclCustomer);
    }

    @Override
    public AclCustomer findByCustomerId(Long customerId) {
        return aclCustomerMapper.selectByPrimaryKey(customerId);
    }

    @Override
    public AclCustomer findByMobileNo(String mobileNo) {
        return aclCustomerMapper.findByMobileNo(mobileNo);
    }

    @Override
    public List<AclCustomer> findByIds(List<Long> customerIds) {
        return aclCustomerMapper.findByIds(customerIds);
    }

}
