package com.yd.dal.entity.marketing;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;


@Data
public class MktLeadsGoals implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * 目标类型：1：经纪人指标，2:团队指标
     */
    private Integer goalsType;

    /**
     * FK ag_acl_practitioner.id 经纪人（或团队长）
     */
    private Long practitionerId;

    /**
     * FK ag_acl_practitioner_subordinate_system.id 团队ID
     */
    private Long subordinateSystemId;

    /**
     * FK ag_acl_practitioner_subordinate_system.name 团队Name
     */
    private String subordinateSystemName;

    /**
     * 目标所属年度
     */
    private Integer currentYear;

    /**
     * 1：年度，3：月度
     */
    private Integer statisticTimeUnit;

    /**
     * 1：年度，3：月度
     */
    private Integer seqTime;

    /**
     * 保费
     */
    private Double premium;

    /**
     * 佣金
     */
    private Double commission;

    /**
     * 件数
     */
    private Integer pieces;

    /**
     * 件均保费： 计算生成  FYP/件数
     */
    private Double pieceAveragePremium;

    /**
     * 版本控制
     */
    private Date currentVersion;

    /**
     * 0=No, 1=Yes
     */
    private Integer isActive;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * 创建人
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    private Long updatedBy;

    private static final long serialVersionUID = 1L;
}