package com.yd.api.agms.service.impl;

import com.github.pagehelper.PageInfo;
import com.yd.api.agms.service.AgmsHiringService;
import com.yd.api.agms.vo.hiring.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.agms.hiring.*;
import com.yd.dal.entity.customer.*;
import com.yd.dal.entity.meta.MdCode;
import com.yd.dal.entity.meta.MdPractitionerHiringApproveSteps;
import com.yd.dal.entity.order.PoOrder;
import com.yd.dal.entity.practitioner.hiring.HiringApproveRecords;
import com.yd.dal.entity.user.AclUser;
import com.yd.dal.mapper.customer.AclPractitionerHiringBasicInfoMapper;
import com.yd.dal.mapper.customer.AclPractitionerHiringMembershipMapper;
import com.yd.dal.mapper.customer.AclPractitionerMapper;
import com.yd.dal.service.agms.AgmsHiringDALService;
import com.yd.dal.service.customer.*;
import com.yd.dal.service.meta.MdCodeDALService;
import com.yd.dal.service.meta.MdPractitionerHiringApproveStepsDALService;
import com.yd.dal.service.practitioner.PractitionerHiringDALService;
import com.yd.dal.service.user.AclUserDALService;
import com.yd.rmi.ali.send.service.SendService;
import com.yd.rmi.cache.SystemConfigService;
import com.yd.util.CommonUtil;
import com.yd.util.config.ZHBErrorConfig;
import com.yd.util.page.PageInfoUtils;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author xxy
 */
@Service("agmsHiringService")
public class AgmsHiringServiceImpl implements AgmsHiringService {

    private AgmsHiringDALService agmsHiringDalService;
    private SystemConfigService systemConfigService;
    private AclUserDALService aclUserDalService;
    private MdPractitionerHiringApproveStepsDALService mdPractitionerHiringApproveStepsDalService;
    private AclPractitionerHiringApproveRecordsDALService aclPractitionerHiringApproveRecordsDalService;
    private AclPractitionerDALService aclPractitionerDalService;
    private AclPractitionerSettingDALService aclPractitionerSettingDalService;
    private AclPractitionerHiringBasicInfoDALService aclPractitionerHiringBasicInfoDalService;
    private AclPractitionerHiringMembershipDALService aclPractitionerHiringMembershipDalService;
    private AclPractitionerSubordinateSystemDALService aclPractitionerSubordinateSystemDalService;
    private AclCustomerDALService aclCustomerDalService;
    @Autowired
    private AclPractitionerHiringBasicInfoMapper basicInfoMapper;
    @Autowired
    private PractitionerHiringDALService practitionerHiringDalService;
    @Autowired
    private AclPractitionerMapper aclPractitionerMapper;
    @Autowired
    private AclPractitionerHiringMembershipMapper membershipMapper;
    @Autowired
    private MdCodeDALService mdCodeDALService;
    @Autowired
    private SendService sendService;

    @Autowired
    public void setAgmsHiringDalService(AgmsHiringDALService agmsHiringDalService){
        this.agmsHiringDalService = agmsHiringDalService;
    }
    @Autowired
    public void setSystemConfigService(SystemConfigService systemConfigService) {
        this.systemConfigService = systemConfigService;
    }
    @Autowired
    public void setMdPractitionerHiringApproveStepsDalService(MdPractitionerHiringApproveStepsDALService mdPractitionerHiringApproveStepsDalService) {
        this.mdPractitionerHiringApproveStepsDalService = mdPractitionerHiringApproveStepsDalService;
    }

    @Autowired
    public void setAclUserDalService(AclUserDALService aclUserDalService) {
        this.aclUserDalService = aclUserDalService;
    }

    @Autowired
    public void setAclPractitionerHiringApproveRecordsDalService(AclPractitionerHiringApproveRecordsDALService aclPractitionerHiringApproveRecordsDalService) {
        this.aclPractitionerHiringApproveRecordsDalService = aclPractitionerHiringApproveRecordsDalService;
    }

    @Autowired
    public void setAclPractitionerDalService(AclPractitionerDALService aclPractitionerDalService) {
        this.aclPractitionerDalService = aclPractitionerDalService;
    }

    @Autowired
    public void setAclPractitionerSettingDalService(AclPractitionerSettingDALService aclPractitionerSettingDalService) {
        this.aclPractitionerSettingDalService = aclPractitionerSettingDalService;
    }

    @Autowired
    public void setAclPractitionerHiringBasicInfoDalService(AclPractitionerHiringBasicInfoDALService aclPractitionerHiringBasicInfoDalService) {
        this.aclPractitionerHiringBasicInfoDalService = aclPractitionerHiringBasicInfoDalService;
    }

    @Autowired
    public void setAclPractitionerHiringMembershipDalService(AclPractitionerHiringMembershipDALService aclPractitionerHiringMembershipDalService) {
        this.aclPractitionerHiringMembershipDalService = aclPractitionerHiringMembershipDalService;
    }

    @Autowired
    public void setAclPractitionerSubordinateSystemDalService(AclPractitionerSubordinateSystemDALService aclPractitionerSubordinateSystemDalService) {
        this.aclPractitionerSubordinateSystemDalService = aclPractitionerSubordinateSystemDalService;
    }

    @Autowired
    public void setAclCustomerDalService(AclCustomerDALService aclCustomerDalService) {
        this.aclCustomerDalService = aclCustomerDalService;
    }

    @Override
    public PractitionerHiringDetailResponseVO practitionerHiringDetail(PractitionerHiringDetailRequestVO requestVO) {
        PractitionerHiringDetailResponseVO responseVO = new PractitionerHiringDetailResponseVO();

        Long hiringBasicInfoId = requestVO.getHiringBasicInfoId();

        //经纪人审批基本信息
        PractitionerHiringBasicInfo practitionerHiringBasicInfo = agmsHiringDalService.findPractitionerHiringBasicInfo(hiringBasicInfoId);
        //审批经纪人关系
        PractitionerHiringMemberShip practitionerHiringMemberShip = agmsHiringDalService.findPractitionerHiringMemberShip(hiringBasicInfoId);
        //审批经纪人工作经历
        List<PractitionerHiringWorkingExperience> practitionerHiringWorkingExperienceList = agmsHiringDalService.findPractitionerHiringWorkingExperienceList(hiringBasicInfoId);
        //经纪人申请名目
        List<PractitionerHiringPersonalStatements> practitionerHiringPersonalStatementsList = agmsHiringDalService.findPractitionerHiringPersonalStatementsList(hiringBasicInfoId);
        //经纪人合同条款是否同意
        List<PractitionerHiringContractTermsConfirms> practitionerHiringContractTermsConfirmsList = agmsHiringDalService.findPractitionerHiringContractTermsConfirmsList(hiringBasicInfoId);
        //已审批结果
        List<HiringApproveRecords> hiringApproveRecordsList = practitionerHiringDalService.findHiringApproveRecordsList(hiringBasicInfoId);


        responseVO.setHiringBasicInfoId(hiringBasicInfoId);
        // 审批到哪一步
        Integer nextStepSeq = practitionerHiringDalService.getNextStepSeqByApproveStatus(practitionerHiringBasicInfo.getApproveStatus());
        responseVO.setHiringApproveStepsSeq(nextStepSeq);
        responseVO.setPractitionerHiringBasicInfo(practitionerHiringBasicInfo);
        responseVO.setPractitionerHiringMemberShip(practitionerHiringMemberShip);
        responseVO.setPractitionerHiringWorkingExperienceList(practitionerHiringWorkingExperienceList);
        responseVO.setPractitionerHiringPersonalStatementsList(practitionerHiringPersonalStatementsList);
        responseVO.setPractitionerHiringContractTermsConfirmsList(practitionerHiringContractTermsConfirmsList);
        responseVO.setPractitionerHiringApproveRecordsList(hiringApproveRecordsList);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public PractitionerHiringListResponseVO practitionerHiringList(PractitionerHiringListRequestVO requestVO) {
        PractitionerHiringListResponseVO responseVO = new PractitionerHiringListResponseVO();
        PageInfo<PractitionerHiringListInfo> hiringListInfoPageInfo = agmsHiringDalService.practitionerHiringList(requestVO);
        responseVO.setPractitionerHiringList(hiringListInfoPageInfo);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public PractitionerHiringApproveResponseVO practitionerHiringApprove(PractitionerHiringApproveRequestVO requestVO) {
        PractitionerHiringApproveResponseVO responseVO = new PractitionerHiringApproveResponseVO();
        Integer hiringApproveStepsSeq = requestVO.getHiringApproveStepsSeq();
        Long hiringBasicInfoId = requestVO.getHiringBasicInfoId();
        AclPractitionerHiringBasicInfo basicInfo = basicInfoMapper.selectByPrimaryKey(hiringBasicInfoId);
        if (basicInfo != null && StringUtils.isNotEmpty(basicInfo.getApproveStatus())) {
            List<AclPractitionerHiringApproveRecords> recordsList = aclPractitionerHiringApproveRecordsDalService.queryListByBasicInfoId(hiringBasicInfoId);
            for (AclPractitionerHiringApproveRecords record : recordsList) {
                if (record.getStepSeq().equals(String.valueOf(hiringApproveStepsSeq))) {
                    responseVO.setCommonResult(new CommonResult(true, "当前流程已审批，请勿重复提交"));
                    return responseVO;
                }
            }
        }

        Integer plateform = requestVO.getPlateform();
        if (Integer.valueOf("2").equals(plateform)) {
            //通过loginId查询此登入者的经纪人id
            Long loginId = requestVO.getLoginId();
            Long practitionerId = agmsHiringDalService.findPractitionerIdByLoginId(loginId);
            AclUser user = aclUserDalService.selectByPrimaryKey(loginId);
            String mobileNo = user.getMobileNo();
            this.doApprove(practitionerId, mobileNo, requestVO, responseVO);
            return responseVO;

        } else {
            Long practitionerId = requestVO.getPractitionerId();
            AclPractitioner practitioner = aclPractitionerMapper.selectByPrimaryKey(practitionerId);
            String mobileNo = practitioner.getMobileNo();
            this.doApprove(practitionerId, mobileNo, requestVO, responseVO);
            return responseVO;

        }

    }

    private void doApprove(Long practitionerId, String mobileNo, PractitionerHiringApproveRequestVO requestVO, PractitionerHiringApproveResponseVO responseVO) {
        Long hiringBasicInfoId = requestVO.getHiringBasicInfoId();
        //查询审批流程
        List<MdPractitionerHiringApproveSteps> hiringApproveStepsList = systemConfigService.findHiringApproveStepsAll();
        //保存审批结果
        saveRecords(practitionerId, mobileNo, hiringApproveStepsList, requestVO, responseVO);

        //保存完毕,判断是否为最后一步
        AclPractitionerHiringBasicInfo basicInfo2 = basicInfoMapper.selectByPrimaryKey(hiringBasicInfoId);
        if (basicInfo2.getApproveStatus().equals(String.valueOf(hiringApproveStepsList.size()))) {
            Long approvingStatus = requestVO.getApprovingStatus();
            String basicInfoStatus = null;
            if (approvingStatus == 1) {
                //最后一步 并同意 更新经纪人系类表
                updatePractitionerInfo(hiringBasicInfoId, practitionerId);
                //最后一步通过发邮件通知人事填写相关经纪人信息
                this.sendMailToHR(basicInfo2);
                basicInfoStatus = "0";

            } else {
                basicInfoStatus = "-1";
            }
            // 更新basicInfo表审批状态
            AclPractitionerHiringBasicInfo updateObj = new AclPractitionerHiringBasicInfo();
            updateObj.setId(hiringBasicInfoId);
            updateObj.setApproveStatus(basicInfoStatus);
            basicInfoMapper.updateByPrimaryKeySelective(updateObj);
        }
        responseVO.setHiringBasicInfoId(hiringBasicInfoId);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
    }

    @Override
    public PractitionerHiringListResponseVO practitionerHiringListV2(PractitionerHiringListRequestVO requestVO) {
        PractitionerHiringListResponseVO resp = new PractitionerHiringListResponseVO();
        try {
            Long loginId = requestVO.getLoginId();
            String status = requestVO.getStatus();

            List<PractitionerHiringListInfo> list;
            if ("0".equals(status)) {
                list = agmsHiringDalService.queryUnhandledList(requestVO);
                // 对list分页
                PageInfo<PractitionerHiringListInfo> pageInfo = requestVO.getPageInfo();
                int pageNum = pageInfo.getPageNum();
                int pageSize = pageInfo.getPageSize();
                PageInfo<PractitionerHiringListInfo> page = PageInfoUtils.list2PageInfo(list, pageNum, pageSize);
                resp.setPractitionerHiringList(page);

            } else {
                // 通过loginId查询此登入者的经纪人id
                Long loginPractitionerId = agmsHiringDalService.findPractitionerIdByLoginId(loginId);
                PageInfo<PractitionerHiringListInfo> pageInfo = agmsHiringDalService.queryHandledList(loginPractitionerId, status, requestVO);
                resp.setPractitionerHiringList(pageInfo);
            }

            resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));

        } catch (Exception e) {
            e.printStackTrace();
        }
        return resp;
    }

    @SuppressWarnings("unchecked")
    private void saveRecords(Long loginPractitionerId,
                             String mobileNo, List<MdPractitionerHiringApproveSteps> hiringApproveStepsList,
                             PractitionerHiringApproveRequestVO requestVO,
                             PractitionerHiringApproveResponseVO responseVO) {

        Long basicInfoId = requestVO.getHiringBasicInfoId();

        BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("stepSeq", requestVO.getHiringApproveStepsSeq());
        List<MdPractitionerHiringApproveSteps> steps = (List<MdPractitionerHiringApproveSteps>) CollectionUtils.select(hiringApproveStepsList, predicate);

        if (steps.size() != 1) {
            responseVO.setHiringBasicInfoId(requestVO.getHiringBasicInfoId());
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830025")));
            return;
        }

        AclPractitionerHiringApproveRecords records = new AclPractitionerHiringApproveRecords();
        MdPractitionerHiringApproveSteps step = steps.get(0);
        records.setHiringBasicInfoId(basicInfoId);
        records.setApproveStepId(step.getId().toString());
        records.setApproveStepName(step.getStepName());
        records.setApprovingPractitionerId(loginPractitionerId);
        records.setApprovingStatus(requestVO.getApprovingStatus());
        records.setInterviewAssessment(requestVO.getInterviewAssessment());
        records.setRejectNote(requestVO.getRejectNote());
        records.setIsActive(1);
        records.setCreatedAt(new Date());
        records.setCreatedBy(loginPractitionerId);
        records.setUpdatedAt(new Date());
        records.setUpdatedBy(loginPractitionerId);
        aclPractitionerHiringApproveRecordsDalService.save(records);
        // 更新basicInfo表审批状态
        AclPractitionerHiringBasicInfo updateObj = new AclPractitionerHiringBasicInfo();
        updateObj.setId(basicInfoId);
        updateObj.setApproveStatus(step.getStepSeq().toString());
        basicInfoMapper.updateByPrimaryKeySelective(updateObj);

        if (CommonUtil.isNullOrZero(requestVO.getApprovingStatus())) {
            // 审批拒绝更新basicInfo表审批状态为 "-1"
            AclPractitionerHiringBasicInfo updateObj2 = new AclPractitionerHiringBasicInfo();
            updateObj2.setId(basicInfoId);
            updateObj2.setApproveStatus("-1");
            basicInfoMapper.updateByPrimaryKeySelective(updateObj2);

            responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
            return;
        }
        //判断下一个步骤是不是他
        Long id = step.getId();
        MdPractitionerHiringApproveSteps lastStep = hiringApproveStepsList.get(hiringApproveStepsList.size() - 1);
        Long lastStepId = lastStep.getId();
        //这是最后一个步骤
        if (id.equals(lastStepId)) {
            responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
            return;
        }
        //下一个步骤
        MdPractitionerHiringApproveSteps nextStep = new MdPractitionerHiringApproveSteps();
        for (int i = 0; i < hiringApproveStepsList.size(); i++) {
            MdPractitionerHiringApproveSteps stop = hiringApproveStepsList.get(i);
            Long stopId = stop.getId();
            if (id.equals(stopId)) {
                nextStep = hiringApproveStepsList.get(i + 1);
                break;
            }
        }

        //不是他
        boolean flag = this.isHasNextStep(loginPractitionerId, mobileNo, basicInfoId, nextStep);
        if (!flag) {
            responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
            return;
        }
        requestVO.setHiringApproveStepsSeq(nextStep.getStepSeq());
        saveRecords(loginPractitionerId, mobileNo, hiringApproveStepsList, requestVO, responseVO);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
    }

    private boolean isHasNextStep(Long loginPractitionerId, String mobileNo, Long basicInfoId, MdPractitionerHiringApproveSteps nextStep) {
        // 判断是辅导人和团队长
        if (!CommonUtil.isNullOrZero(loginPractitionerId)) {
            String approveRole = nextStep.getApproveRole();
            if (StringUtils.isNotEmpty(approveRole)) {
                AclPractitionerHiringMembership membership = membershipMapper.selectByHiringBasicInfoId(basicInfoId);
                if (membership != null) {
                    if (loginPractitionerId.equals(membership.getSubsystemOwnerId())) {
                        return true;
                    }
                }
            }
        }
        // 判断是否是AGMS中审批的人员
        String appointedApprovePractitioners = nextStep.getAppointedApprovePractitioners();
        if (StringUtils.isNotEmpty(appointedApprovePractitioners)) {
            List<String> hiringApproveMobileNos = new ArrayList<>(Arrays.asList(appointedApprovePractitioners.split(",")));
            if (hiringApproveMobileNos.contains(mobileNo)) {
                return true;
            }
        }
        return false;
    }

    private void updatePractitionerInfo(Long hiringBasicInfoId,Long operater) {
        //更新经纪人系类表
        //ag_acl_practitioner
        //ag_acl_practitioner_setting
        //ag_acl_practitioner_subordinate_system(如果是团队长)operator
        AclPractitionerHiringBasicInfo basicInfo = aclPractitionerHiringBasicInfoDalService.findById(hiringBasicInfoId);
        AclPractitionerHiringMembership membership = aclPractitionerHiringMembershipDalService.findByBasicInfoId(hiringBasicInfoId);
        AclPractitionerSubordinateSystem subordinateSystem = aclPractitionerSubordinateSystemDalService.findById(membership.getSubsystemId());
        AclCustomer customer = aclCustomerDalService.findByMobileNo(basicInfo.getMobileNo());
        AclPractitioner practitioner = new AclPractitioner();
        practitioner.setInsurerId(888L);
        practitioner.setInsurerBranchId(membership.getBranchId());
        practitioner.setDeptId(subordinateSystem.getDeptId());
        practitioner.setSubordinateSystemId(membership.getSubsystemId());
        practitioner.setPractitionerCode(" ");
        practitioner.setName(basicInfo.getName());
        practitioner.setMobileNo(basicInfo.getMobileNo());
        practitioner.setIdTypeId(basicInfo.getIdTypeId());
        practitioner.setIdType(basicInfo.getIdType());
        practitioner.setIdNo(basicInfo.getIdNo());
        practitioner.setPractitionerBirthdate(basicInfo.getPractitionerBirthdate());
        practitioner.setPractitionerRegNo(" ");
        practitioner.setPractitionerRegCompany(" ");
        practitioner.setCustomerId(customer != null ? customer.getId() : null);
        practitioner.setIsActive(1);
        practitioner.setCreatedAt(new Date());
        practitioner.setCreatedBy(operater);
        practitioner.setUpdatedAt(new Date());
        practitioner.setUpdatedBy(operater);
        practitioner.setProvinceId(basicInfo.getProvinceId());
        practitioner.setProvinceName(basicInfo.getProvinceName());
        practitioner.setCityId(basicInfo.getCityId());
        practitioner.setCityName(basicInfo.getCityName());
        practitioner.setWechatId(basicInfo.getWechatId());
        practitioner.setIsProfileShow(0);
        practitioner.setIsNameShow(0);
        practitioner.setIsMobileShow(0);
        practitioner.setEducationLevel(basicInfo.getLastGraduateCode());
        practitioner.setMentorId(membership.getMentorPractitionerId());
        practitioner.setIntroducerId(membership.getIntroducerPractitionerId());
        practitioner.setGender(basicInfo.getGender());
        practitioner.setHiringBasicInfoId(hiringBasicInfoId);
        aclPractitionerDalService.save(practitioner);

        AclPractitionerSetting setting = new AclPractitionerSetting();
        setting.setPractitionerId(practitioner.getId());
        setting.setPractitionerTypeId(28L);
        setting.setPractitionerLevel(membership.getMdDropOptionId());
        setting.setIsActive(1);
        setting.setCreatedAt(new Date());
        setting.setCreatedBy(operater);
        setting.setUpdatedAt(new Date());
        setting.setUpdatedBy(operater);
        aclPractitionerSettingDalService.save(setting);
    }

    private PractitionerHiringApproveSteps getHiringApproveStatus(Long loginId, String practitionerLevelId, List<PractitionerHiringApproveRecords> practitionerHiringApproveRecordsList) {
        //是否可进行审批操作 0.不可审批(未到)  1.可审批  2.已审批  3.无权审批(默认) 4.已驳回
        Long hiringApproveStatus = 3L;
        //审批到哪一步了
        Long hiringApproveStepsSeq = null;
        //查看审批流程最后一次,是否通过
        PractitionerHiringApproveRecords recordsFinally = new PractitionerHiringApproveRecords();
        if (!practitionerHiringApproveRecordsList.isEmpty()) {
            recordsFinally = practitionerHiringApproveRecordsList.get(practitionerHiringApproveRecordsList.size() - 1);
            Long approvingStatusId = recordsFinally.getApprovingStatusId();
            if (CommonUtil.isNullOrZero(approvingStatusId)) {
                //已驳回
                hiringApproveStatus = 4L;
                return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsSeq);
            }
        }

        //通过loginId查询对应的经纪人id
        Long loginPractitionerId = agmsHiringDalService.findPractitionerIdByLoginId(loginId);
        //AGMS登入者手机号不是经纪人手机号,无权审批
        if (!CommonUtil.isNullOrZero(loginPractitionerId)) {
            return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsSeq);
        }
        //遍历已审批结果,查看此agms登入者是否已审批
        for (PractitionerHiringApproveRecords practitionerHiringApproveRecords : practitionerHiringApproveRecordsList) {
            Long approvingPractitionerId = practitionerHiringApproveRecords.getApprovingPractitionerId();
            if (approvingPractitionerId.equals(loginPractitionerId)) {
                //已审批
                hiringApproveStatus = 2L;
                return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsSeq);
            }
        }
        //查询审批流程
        List<MdPractitionerHiringApproveSteps> hiringApproveSteps = systemConfigService.findHiringApproveStepsByPractitionerLevel(practitionerLevelId);
        //通过loginId查询登入者手机号码
        AclUser user = aclUserDalService.selectByPrimaryKey(loginId);
        String loginMobileNo = user.getMobileNo();
        //所有通过agms审批的手机号码
        List<String> hiringApproveMobileNo = systemConfigService.findHiringApproveMobileNo(hiringApproveSteps, practitionerLevelId);
        //agms登入者无审批权力
        if (!hiringApproveMobileNo.contains(loginMobileNo)) {
            return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsSeq);
        }
        //此经纪人最后一次审批步骤id
        hiringApproveStepsSeq = recordsFinally.getApproveStepId();
        //查询此经纪人最后一次审批步骤详细信息
        Long stepId = 0L;
        for (int i = 0; i < hiringApproveSteps.size(); i++) {
            Long id = hiringApproveSteps.get(i).getId();
            if (id.equals(hiringApproveStepsSeq)) {
                stepId = id;
                break;
            }
        }
        MdPractitionerHiringApproveSteps mdPractitionerHiringApproveSteps = hiringApproveSteps.get(Integer.parseInt(stepId.toString()));
        //通过手机号码查询此agmd登入者拥有哪些审批步骤(肯定有值)
        List<MdPractitionerHiringApproveSteps> hiringApproves = mdPractitionerHiringApproveStepsDalService.findByAppointedApprovePractitioners(loginMobileNo);
        //最后一个审批步骤的seq
        Integer stepSeq = mdPractitionerHiringApproveSteps.getStepSeq() == null ? 0 : mdPractitionerHiringApproveSteps.getStepSeq();
        MdPractitionerHiringApproveSteps loginHiringApproveStep = null;
        for (MdPractitionerHiringApproveSteps hiringApprove : hiringApproves) {
            Integer loginStepSeq = hiringApprove.getStepSeq();
            if (stepSeq < loginStepSeq) {
                loginHiringApproveStep = hiringApprove;
                break;
            }
        }
        if (loginHiringApproveStep == null){
            hiringApproveStatus = 2L;
            return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsSeq);
        }
        //查看下一审批步骤
        mdPractitionerHiringApproveSteps = hiringApproveSteps.get(Integer.parseInt(stepId.toString())+1);
        Long mdPractitionerHiringApproveStepsSeq = Long.valueOf(mdPractitionerHiringApproveSteps.getStepSeq());
        Long loginHiringApproveStepId = loginHiringApproveStep.getId();
        if (mdPractitionerHiringApproveStepsSeq.equals(loginHiringApproveStepId)){
            //可审批
            hiringApproveStatus = 1L;
            hiringApproveStepsSeq = mdPractitionerHiringApproveStepsSeq;
        }else {
            //0.不可审批(未到)
            hiringApproveStatus = 0L;
        }
        return new PractitionerHiringApproveSteps(hiringApproveStatus, hiringApproveStepsSeq);
    }

    /**
     * 报聘审核通过，通知人事
     * @param basicInfo
     */
    private void sendMailToHR(AclPractitionerHiringBasicInfo basicInfo) {
        //收件地址
        String address = systemConfigService.getSingleConfigValue("PractitionerHiringNotifyAddress");
        //抄送地址
        String ccAddress = systemConfigService.getSingleConfigValue("PractitionerHiringNotifyAddress");
        String[] ccAddresses = {ccAddress};


        AclPractitionerHiringMembership memberShip = membershipMapper.selectByHiringBasicInfoId(basicInfo.getId());


        StringBuilder messageText = new StringBuilder();
        messageText.append("银盾人事你好，");
        if ("30".equals(memberShip.getMdDropOptionId())) {
            // XX 分公司的 XXX
            messageText.append(memberShip.getBranch()).append("的").append(basicInfo.getName());
        } else {
            // XX 分公司 XX 体系下的 XXX
            messageText.append(memberShip.getBranch()).append(memberShip.getSubsystem()).append("体系下的").append(basicInfo.getName());
        }
        messageText.append("的电子报聘流程线上审批已经通过，请尽快帮助完成该报聘人的经纪人执业登记，并在AGMS 里更新并生成电子合同。谢谢！");

        String subject = "电子报聘审批通过";
        sendService.sendEmailOrSMS("email", address, "3", messageText.toString(), null, subject, ccAddresses, "电子报聘审批通过", 99, null);
    }
}
