package com.yd.api.agms.service.impl;

import com.github.pagehelper.PageInfo;
import com.yd.api.agms.service.AgmsStatementService;
import com.yd.api.agms.vo.statement.FinancialPredictStatementRequestVO;
import com.yd.api.agms.vo.statement.FinancialPredictStatementResponseVO;
import com.yd.api.agms.vo.statement.PredictStatementData;
import com.yd.api.commission.service.CommissionService;
import com.yd.api.result.CommonResult;
import com.yd.util.config.ZHBErrorConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;

@Service("agmsStatementService")
public class AgmsStatementServiceImpl implements AgmsStatementService {
    @Autowired
    private CommissionService commissionService;
    @Override
    public FinancialPredictStatementResponseVO financialPredictStatement(FinancialPredictStatementRequestVO requestVO, HttpServletResponse response) {
        FinancialPredictStatementResponseVO responseVO = new FinancialPredictStatementResponseVO();
        PageInfo<PredictStatementData> pageInfo = requestVO.getPageInfo();
        String predictInCommissionTime = requestVO.getPredictInCommissionTime();//预估来佣时间
        String predictOutCommissionTime = requestVO.getPredictOutCommissionTime();//预估发佣时间
        String insurerBranchId = requestVO.getInsurerBranchId();//分公司
        String deptId = requestVO.getDeptId();//营业部
        String subordinateId = requestVO.getSubordinateId();//体系
        PageInfo<PredictStatementData> dataList = commissionService.getPredictStatementDataByPage(pageInfo.getPageNum(),pageInfo.getSize(),predictInCommissionTime,predictOutCommissionTime,insurerBranchId,deptId,subordinateId);
        responseVO.setPredictStatementDataList(dataList);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }
}
