package com.yd.api.practitioner.service.impl;

import com.github.pagehelper.PageHelper;
import com.yd.api.customer.service.CustomerService;
import com.yd.api.customer.vo.register.RegisterRequestVO;
import com.yd.api.customer.vo.register.RegisterResponseVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginBasicInfo;
import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.media.MediaGetReqVO;
import com.yd.api.practitioner.vo.media.MediaGetRespVO;
import com.yd.api.practitioner.vo.opportunity.*;
import com.yd.api.practitioner.vo.rank.AclCustomerFortuneStatistics;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.rank.PractitionerInfoForAchievement;
import com.yd.api.practitioner.vo.recruit.*;
import com.yd.api.practitioner.vo.salestarget.*;
import com.yd.api.practitioner.vo.setting.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.*;
import com.yd.dal.entity.marketing.*;
import com.yd.dal.entity.meta.*;
import com.yd.dal.entity.practitioner.opportunity.OwnOpportunityInfo;
import com.yd.dal.entity.order.PoOrder;
import com.yd.dal.entity.practitioner.opportunity.PlayerSalesActivityInfo;
import com.yd.dal.entity.survey.SurveyCustomerAnswers;
import com.yd.dal.service.customer.*;
import com.yd.dal.service.marketing.*;
import com.yd.dal.service.meta.*;
import com.yd.dal.service.order.PoOrderDALService;
import com.yd.dal.service.survey.SurveyCustomerAnswersDALService;
import com.yd.dal.entity.customer.practitioner.*;
import com.yd.dal.service.meta.MdCodeDALService;
import com.yd.dal.service.meta.MdDropOptionsDALService;
import com.yd.rmi.ali.oss.service.OssService;
import com.yd.rmi.cache.SystemConfigService;
import com.yd.rmi.tencent.wechat.service.WechatService;
import com.yd.rmi.tencent.wechat.vo.WeChatInfoByENV;
import com.yd.rmi.tencent.wechatinterf.pojo.ticket.TicketRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.token.TokenRequest;
import com.yd.util.CommonUtil;
import com.yd.util.HttpUtil;
import com.yd.util.config.ZHBErrorConfig;
import com.yd.util.deshandler.DESTypeHandler;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.google.common.base.Strings;
import org.springframework.transaction.annotation.Transactional;

import javax.imageio.ImageIO;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Service("practitionerService")
public class PractitionerServiceImpl implements com.yd.api.practitioner.service.PractitionerService {

    @Autowired
    private AclPractitionerDALService aclPractitionerDALService;
    @Autowired
    private MdCodeDALService mdCodeDALService;
    @Autowired
    private AclFileUploadDALService aclFileUploadDALService;
    @Autowired
    private AclPractitionerSubordinateSystemDALService aclPractitionerSubordinateSystemDALService;
    @Autowired
    private AclCustomerLogDALService aclCustomerLogDALService;
    @Autowired
    private OssService ossService;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private AclCustomerShareDALService aclCustomerShareDALService;
    @Autowired
    private PoOrderDALService poOrderDALService;
    @Autowired
    private AclCustomerDALService aclCustomerDALService;
    @Autowired
    private MdMkCampaignDALService mdMkCampaignDALService;
    @Autowired
    private MktLeadsAssignedsDALService mktLeadsAssignedsDALService;
    @Autowired
    private ObjectCollectionTaggedDALService objectCollectionTaggedDALService;
    @Autowired
    private MktLeadsAssignedTrackDALService mktLeadsAssignedTrackDALService;
    @Autowired
    private MdTagDALService mdTagDALService;
    @Autowired
    private AclCustomerMembershipDALService aclCustomerMembershipDALService;
    @Autowired
    private SurveyCustomerAnswersDALService surveyCustomerAnswersDALService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private AclPractitionerPotentialDALService aclPractitionerPotentialDALService;
    @Autowired
    private AclPractitionerPotentialAssignedTrackDALService aclPractitionerPotentialAssignedTrackDALService;
    @Autowired
    private MktLeadsPoolDALService mktLeadsPoolDALService;
    @Autowired
    private MdDropOptionsDALService mdDropOptionsDALService;
    @Autowired
    private AclUserDALService aclUserDALService;
    @Autowired
    private AclPractitionerPotentialAssignedsDALService aclPractitionerPotentialAssignedsDALService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private MktLeadsGoalsDALService mktLeadsGoalsDALService;
    @Autowired
    private MdDropMasterDALService mdDropMasterDALService;
    @Autowired
    private MdGoalsCalculateExpressionService mdGoalsCalculateExpressionService;
    @Autowired
    private MktLeadsGoalsActionsDALService mktLeadsGoalsActionsDALService;

    @Override
    public PractitionerLoginResponseVO practitionerLogin(PractitionerLoginRequestVO requestVO) {
        PractitionerLoginResponseVO responseVO = new PractitionerLoginResponseVO();
        String mobileNo = requestVO.getMobileNo();
        //1、校验入参，电话号码不能为空
        if (Strings.isNullOrEmpty(mobileNo)) {
            String[] params = {"mobileNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", params)));
            return responseVO;
        }
        //2、检查是否在ag_acl_customer表中存在该用户，如果不存在就注册，然后直接抛错，该用户未注册为经纪人
        PractitionerInfo practitionerInfo = aclPractitionerDALService.findPractitionerInfoByLogin(mobileNo);
        if(practitionerInfo != null){
            Long practitionerType = practitionerInfo.getPractitionerType();
            //处理特殊人员
            boolean isSpecial = false;
            String mobileSpecialStr = mdCodeDALService.findCodeByType("special_practitioner_mobile");
            if(!Strings.isNullOrEmpty(mobileSpecialStr)){
                List<String> mobileSpecials = Arrays.asList(mobileSpecialStr.split(","));
                isSpecial = mobileSpecials.contains(mobileNo);
            }
            if(28L == practitionerType || isSpecial){//只有寿险的经纪人和注册为经纪人的员工才能登录
                Long practitionerId = practitionerInfo.getPractitionerId();
                Long customerId = practitionerInfo.getCustomerId();
                AclCustomer customer = aclCustomerDALService.findById(customerId);
                PractitionerLoginBasicInfo basicInfo = new PractitionerLoginBasicInfo();
                BeanUtils.copyProperties(practitionerInfo,basicInfo);
                //获取头像
                Integer targetType = 1, targetUseFor = 1;
                CustomerFileUpload fileUpload = aclFileUploadDALService.findFilePathInfo(targetType,targetUseFor,practitionerId);
                String imagePath = (fileUpload != null) ? fileUpload.getFilePath() : null;
                basicInfo.setHeadImagePath(imagePath);
                //获取体系信息
                Long subordinateId = practitionerInfo.getSubordinateId();
                if(subordinateId != null){
                    PractitionerSubordinateInfo subordinateInfo = aclPractitionerSubordinateSystemDALService.findSubordinateInfo(subordinateId);
                    if(subordinateInfo != null){
                        basicInfo.setSubordinateName(subordinateInfo.getSubordinateName());
                        basicInfo.setSubordinateLeader(subordinateInfo.getSubordinateLeader());
                    }
                }
                //获取用户的登录次数
                List<AclCustomerLog> customerLogList = aclCustomerLogDALService.findLogInfoByCustomerId(customerId);
                int logTimes = (customerLogList.isEmpty()) ? 0 : customerLogList.size();
                //保存用户的登录记录
                aclCustomerLogDALService.saveCustomerLog(customerId,2);
                getOpenIdUrl(responseVO,customer);
                responseVO.setCustomerId(customerId);
                responseVO.setPractitionerId(practitionerId);
                responseVO.setPractitionerBasicInfo(basicInfo);
                responseVO.setLoginTimes(logTimes);
                responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
            }
        }else{
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830001")));
        }
        return responseVO;
    }

    private void getOpenIdUrl(PractitionerLoginResponseVO responseVO, AclCustomer customer) {
        String openId = customer.getYdWechatOpenid();
        if(Strings.isNullOrEmpty(openId)) {
            WeChatInfoByENV weChatInfo = wechatService.getWeChatInfoByENV("YDBJ", false);
            String appId = weChatInfo.getAppId(), secret = weChatInfo.getSecret();
            if (!Strings.isNullOrEmpty(appId) && !Strings.isNullOrEmpty(secret)) {
                try {
                    String info = appId+","+customer.getId();
                    String redirectUri = mdCodeDALService.findCodeByType("FilePathPrefix")+"ydapi/getOpenId?info=" + info;
                    redirectUri = URLEncoder.encode(redirectUri, "UTF-8");
                    String url = "https://open.weixin.qq.com/connect/oauth2/authorize?"
                            + "appid=" + appId
                            + "&redirect_uri=" + redirectUri
                            + "&response_type=code&scope=snsapi_base&state=123#wechat_redirect";
                    System.out.println(">>>>>url>>>>>>>:" + url);
                    responseVO.setGetOpenIdUrl(url);
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    @Override
    public PractitionerRankResponseVO practitionerRank(PractitionerRankRequestVO requestVO) {
        PractitionerRankResponseVO responseVO = new PractitionerRankResponseVO();
        String mobileNo = requestVO.getMobileNo();
        Integer type = requestVO.getType();
        Integer time = requestVO.getTime();
        Integer platform = requestVO.getPlatform();
        type = (type == null) ? 1 : type;//默认：保费
        time = (time == null) ? 1 : time;//默认：本月
        platform = (platform == null) ? 1 : platform;
        if(!Strings.isNullOrEmpty(mobileNo)){
            //查询该手机号码的经纪人id，是否存在
            PractitionerBasicInfo practitionerBasicInfo = getPractitionerBasicInfo(mobileNo,platform);
            if(practitionerBasicInfo != null){
                String practitionerId = practitionerBasicInfo.getPractitionerId();
                if(!Strings.isNullOrEmpty(practitionerId)){
                    List<PractitionerRankInfo> rankInfoList = getPractitionerRankInfo(time,platform);
                    //按照指定类型排序
                    getPractitionerRankResult(responseVO,rankInfoList,type,practitionerId);
                    responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
                }
            }else{
                responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830001"))); //该经纪人不存在
            }
        }else{
            String [] param = {"mobileNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", param)));
        }
        return responseVO;
    }

    private List<PractitionerRankInfo> getPractitionerRankInfo(Integer time, Integer platform) {
        List<PractitionerRankInfo> rankInfoList;
        if(platform == 1){
            Long practitionerTypeId = 28L;
            rankInfoList = aclPractitionerDALService.getPractitionerRankInfoForOnline(time,practitionerTypeId);
            //特殊人员处理
            String mobileSpecialStr = mdCodeDALService.findCodeByType("special_practitioner_mobile");
            if(!Strings.isNullOrEmpty(mobileSpecialStr)){
                List<String> mobileSpecials = Arrays.asList(mobileSpecialStr.split(","));
                List<PractitionerRankInfo> rankInfoListSpecials = aclPractitionerDALService.getPractitionerRankInfoForSpecials(mobileSpecials,time);
                rankInfoList.addAll(rankInfoListSpecials);
            }
        }else{
            rankInfoList = aclPractitionerDALService.getPractitionerRankInfoForOffline(time);
        }
        return rankInfoList;
    }

    private PractitionerBasicInfo getPractitionerBasicInfo(String mobileNo, Integer platform) {
        PractitionerBasicInfo practitionerBasicInfo;
        if(platform == 1){
            practitionerBasicInfo = aclPractitionerDALService.getPractitionerBasicInfoForOnline(mobileNo);
            if(practitionerBasicInfo != null){
                Long practitionerId = practitionerBasicInfo.getPractitionerIdForOnline();
                if(practitionerId != null){
                    practitionerBasicInfo.setPractitionerId(practitionerId.toString());
                }
            }
        }else{
            practitionerBasicInfo = aclPractitionerDALService.getPractitionerBasicInfoForOffline(mobileNo);
        }
        return practitionerBasicInfo;
    }

    private void getPractitionerRankResult(PractitionerRankResponseVO responseVO, List<PractitionerRankInfo> rankInfoList, Integer type, String practitionerId) {
        PractitionerInfoForAchievement practitionerInfo = new PractitionerInfoForAchievement(0D,0D,0);
        List<AclCustomerFortuneStatistics> rankList = new ArrayList<>();
        if(!rankInfoList.isEmpty()){
            //排序---1-保费，2-佣金，3-件数
            if(2 == type){
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyc).reversed());
            }else if(3 == type){
                rankInfoList.sort(Comparator.comparingInt(PractitionerRankInfo::getCount).reversed());
            }else{
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyp).reversed());
            }
            AclCustomerFortuneStatistics fortuneStatistics;
            int rank = 1;
            Long practitionerIdForOnLine;
            String practitionerIdItem;
            for(PractitionerRankInfo practitionerItem : rankInfoList){
                //更新对象里面的内容，将PractitionerIdForOnLine里的信息赋值到PractitionerId
                practitionerIdForOnLine = practitionerItem.getPractitionerIdForOnLine();
                if(practitionerIdForOnLine != null){
                    practitionerItem.setPractitionerId(practitionerIdForOnLine.toString());
                }
                practitionerIdItem = practitionerItem.getPractitionerId();
                if(rank <= 10){//排名
                    fortuneStatistics = new AclCustomerFortuneStatistics();
                    BeanUtils.copyProperties(practitionerItem,fortuneStatistics);
                    fortuneStatistics.setSubordinateSystemName(practitionerItem.getSpcDivName());
                    fortuneStatistics.setRank(rank);
                    rankList.add(fortuneStatistics);
                }
                if(practitionerId.equals(practitionerIdItem)){//赋值
                    BeanUtils.copyProperties(practitionerItem,practitionerInfo);
                    practitionerInfo.setRank(rank);
                    if(rank > 10){
                        break;
                    }
                }
                rank ++;
            }
        }
        responseVO.setPractitionerInfo(practitionerInfo);
        responseVO.setRank(rankList);
    }

    @Override
    @SuppressWarnings("unchecked")
    public SettingQueryResponseVO settingQuery(SettingQueryRequestVO requestVO) {
        SettingQueryResponseVO responseVO = new SettingQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();//入参经纪人id
        //需要查询的信息 1.自我介绍 2.我的设置 3.头像 4.个人微信二位码 5.生活照
        //1.2均在ag_acl_practitioner表中查询
        AclPractitioner practitioner = aclPractitionerDALService.findPractitionerById(practitionerId);
        String bioIntro = practitioner.getBioIntro();//经纪人个人介绍
        Integer isMobileShow = practitioner.getIsMobileShow();
        Integer isNameShow = practitioner.getIsNameShow();
        //3.4.5在ag_acl_file_upload中查询
        //target_type 1=从业人员practioner表, 2=员工user表,  3=客户customer表, 4=渠道客户channel表
        //target_use_for 文件用途 1=头像 2=生活照 3=证照 4=毕业证书 5=营业登记证 6.咨询定制方案 7.客户身份证正面照片 8.客户身份证反面照片 9.个人微信二维码
        //查询ag_acl_file_upload中isActive=1&&target_type=1&&target_id=practitionerId的信息
        AclFileUpload fileUpload = new AclFileUpload();
        fileUpload.setIsActive(1);
        fileUpload.setTargetType(1);
        fileUpload.setTargetId(practitionerId);
        List<AclFileUpload> fileUploads = aclFileUploadDALService.findByAclFileUpload(fileUpload);
        //筛选出头像
        BeanPropertyValueEqualsPredicate predicateClause  = new BeanPropertyValueEqualsPredicate("targetUseFor",1);
        List<AclFileUpload> headImgs = (List<AclFileUpload>) CollectionUtils.select(fileUploads,predicateClause);
        //头像至多一张
        String headImgUrl = null;
        if (!headImgs.isEmpty()){
            headImgUrl = headImgs.get(0).getFilePath();
        }
        //筛选出生活照
        predicateClause  = new BeanPropertyValueEqualsPredicate("targetUseFor",2);
        List<AclFileUpload> lifeImgs = (List<AclFileUpload>) CollectionUtils.select(fileUploads,predicateClause);
        List<LifeImg> lifeImgUrls = new ArrayList<>();
        for (AclFileUpload lifeImg: lifeImgs){
            LifeImg info = new LifeImg();
            info.setId(lifeImg.getId());
            info.setLifeImgUrl(lifeImg.getFilePath());
            lifeImgUrls.add(info);
        }
        //筛选出二维码
        predicateClause  = new BeanPropertyValueEqualsPredicate("targetUseFor",9);
        List<AclFileUpload> wxQRImgs = (List<AclFileUpload>) CollectionUtils.select(fileUploads,predicateClause);
        String wxQRImgUrl = null;
        if (!wxQRImgs.isEmpty()){
            wxQRImgUrl = wxQRImgs.get(0).getFilePath();
        }
        //返回参数
        responseVO.setPractitionerId(practitionerId);
        responseVO.setBioIntro(bioIntro);
        responseVO.setIsMobileShow(isMobileShow);
        responseVO.setIsNameShow(isNameShow);
        responseVO.setHeadImgUrl(headImgUrl);
        responseVO.setLifeImgUrls(lifeImgUrls);
        responseVO.setWxQRImgUrl(wxQRImgUrl);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public ImgDeleteResponseVO imgDelete(ImgDeleteRequestVO requestVO) {
        ImgDeleteResponseVO responseVO = new ImgDeleteResponseVO();
        Long fileId = requestVO.getFileId();
        AclFileUpload fileUpload = new AclFileUpload();
        fileUpload.setId(fileId);
        fileUpload.setIsActive(0);
        aclFileUploadDALService.updateFileUpload(fileUpload);
        responseVO.setPractitionerId(requestVO.getPractitionerId());
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    @Transactional
    public SettingSaveResponseVO settingSave(SettingSaveRequestVO requestVO) throws Exception {
        SettingSaveResponseVO responseVO = new SettingSaveResponseVO();
        //入参判断
        CommonResult commonResult = paramCheck(requestVO);
        if (!commonResult.isSuccess()){
            responseVO.setCommonResult(commonResult);
            return responseVO;
        }
        //保存经纪人自我介绍及设置
        practitionerMySettingSave(requestVO);
        String settingSave = requestVO.getSettingSave();
        if (settingSave.equalsIgnoreCase("img")){
            String message;
            //保存头像
            message = practitionerHeadImgSave(requestVO);
            if (!CommonUtil.isNullOrBlank(message)){
                responseVO.setCommonResult(new CommonResult(false,message));
                return responseVO;
            }
            //保存生活照
            message = practitionerLifeImgSave(requestVO);
            if (!CommonUtil.isNullOrBlank(message)){
                responseVO.setCommonResult(new CommonResult(false,message));
                return responseVO;
            }
            //保存二维码
            message = practitionerWXQRImgSave(requestVO);
            if (!CommonUtil.isNullOrBlank(message)){
                responseVO.setCommonResult(new CommonResult(false,message));
                return responseVO;
            }

        }
        responseVO.setCommonResult(commonResult);
        return responseVO;
    }

    @Override
    public MediaGetRespVO mediaGet(MediaGetReqVO requestVO) {
        MediaGetRespVO mediaGetRespVO=new MediaGetRespVO();
        String message=ZHBErrorConfig.getErrorInfo("800000");
        String mediaId = requestVO.getMediaId();
        String accessToken = wechatService.obtainToken(new TokenRequest());
        System.out.println("accessToken:"+accessToken);
        TicketRequest ticketRequest = new TicketRequest();
        ticketRequest.setAccessToken(accessToken);
        String jsapiTicket = wechatService.obtainTicket(ticketRequest);
        System.out.println("jsapiTicket:"+jsapiTicket);
        String ImgUrl= "https://api.weixin.qq.com/cgi-bin/media/get?access_token="+accessToken+"&media_id="+mediaId;
        String scale = requestVO.getScale();
        //判断上传尺寸是否符合要求
        if(!CommonUtil.isNullOrBlank(scale)){
            Map<String,Object> input = HttpUtil.getInput(ImgUrl);
            if (!(boolean)input.get("success")){
                mediaGetRespVO.setCommonResult(new CommonResult(false, (String)input.get("message")));
                return mediaGetRespVO;
            }
            InputStream inputStream = (InputStream) input.get("is");
            //判断图像尺寸
            Image img = null;
            try {
                img = ImageIO.read(inputStream);
            } catch (IOException e) {
                e.printStackTrace();
            }
            if (img == null || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
                mediaGetRespVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830003")));
                return mediaGetRespVO;
            }else {
                double width = img.getWidth(null);
                double height = img.getHeight(null);
                double value =height/width;
                double scaleDouble = Double.parseDouble(scale);
                if (value !=scaleDouble) {
                    if (scaleDouble == 1){
                        //上传头像尺寸比例为1:1
                        mediaGetRespVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830005")));
                        return mediaGetRespVO;
                    }else if(scaleDouble ==0.75) {
                        mediaGetRespVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830004")));
                        return mediaGetRespVO;
                    }
                }
            }
        }
//		System.out.println("ImgUrl:"+ImgUrl);
        mediaGetRespVO.setImgUrl(ImgUrl);
        mediaGetRespVO.setCommonResult(new CommonResult(true, message));
        return mediaGetRespVO;
    }

    @Override
    public OwnOpportunityQueryResponseVO ownOpportunityQuery(OwnOpportunityQueryRequestVO requestVO) {
        //查询自己的商机列表
        OwnOpportunityQueryResponseVO responseVO = new OwnOpportunityQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();
        //经纪人查询通过自己分享成为自己商机的客户
        AclPractitioner practitioner = aclPractitionerDALService.findPractitionerById(practitionerId);
        Long customerId = practitioner.getCustomerId();
        //查询自己的分享码，仅银盾服务产品
        List<AclCustomerShare> aclCustomerShareList = aclCustomerShareDALService.findByCustomerIdAndInsurerId(customerId,888L);
        List<String> customerShareCodes = new ArrayList<>();
        for ( AclCustomerShare aclCustomerShare:aclCustomerShareList ) {
            customerShareCodes.add(aclCustomerShare.getShareCode());
        }
        //此map存放customerId及订单id
        Map<Long,Long> opportunityDateMap = new HashMap<>();
        if (!customerShareCodes.isEmpty()){
            //通过shareCodeId查询成交的订单
            List<PoOrder> poOrderList = poOrderDALService.findByStatusAndShareCodeInGroupByCustomerId(3,customerShareCodes);
            //便利order，查询商机客户，及服务订单id
            for (PoOrder poOrder:poOrderList) {
                if (poOrder.getCustomerId().longValue() == customerId.longValue()){
                    continue;
                }
                opportunityDateMap.put(poOrder.getCustomerId(), poOrder.getId());
            }
        }
        List<OwnOpportunityInfo> ownOpportunityInfos = aclPractitionerDALService.ownOpportunityQuery(practitionerId);
        for (OwnOpportunityInfo info : ownOpportunityInfos){
            info.setOrderId(opportunityDateMap.get(info.getOpportunityId()));
        }
        responseVO.setOwnOpportunityInfos(ownOpportunityInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public OwnOpportunityDetailQueryResponseVO ownOpportunityDetailQuery(OwnOpportunityDetailQueryRequestVO requestVO) {
        OwnOpportunityDetailQueryResponseVO responseVO = new OwnOpportunityDetailQueryResponseVO();
        //商机客户基本信息
        OpportunityBasicInformationInfo basicInformationInfo = getOpportunityBasicInformation(requestVO);
        //调查问卷答案，咨询服务
        OpportunityConsultationInfo opportunityConsultationInfo = getOpportunityConsultation(requestVO);
        //商机跟进ag_survey_analysis_sales_record表差字段
        OpportunityRecordSituationInfo opportunityRecordSituationInfo = new OpportunityRecordSituationInfo();
        List<OpportunityRecordInfo> opportunityRecordInfos = getOpportunityRecords(requestVO);
        opportunityRecordSituationInfo.setStatus(getRecordStatus(opportunityRecordInfos));
        opportunityRecordSituationInfo.setOpportunityRecordInfos(opportunityRecordInfos);
        //商机得分详情
        OpportunityScore opportunityScore = getOpportunityScore(opportunityRecordInfos);

        responseVO.setOpportunityRecordSituationInfo(opportunityRecordSituationInfo);
        responseVO.setOpportunityBasicInformationInfo(basicInformationInfo);
        responseVO.setOpportunityConsultationInfo(opportunityConsultationInfo);
        responseVO.setOpportunityScore(opportunityScore);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    private Long getRecordStatus(List<OpportunityRecordInfo> opportunityRecordInfos) {
        Long mdDropOptionId = opportunityRecordInfos.get(0).getMdDropOptionId();
        List<MdDropOptions> mdDropOptions = mdDropOptionsDALService.findByDropMasterCode("bizchance_promotion_action");
        ConcurrentMap<String,Long> optionCodeToId = new ConcurrentHashMap<>();
        for (MdDropOptions info : mdDropOptions){
            optionCodeToId.put(info.getDropOptionCode(),info.getId());
        }
        Long refusedId = optionCodeToId.get("refused");
        if (mdDropOptionId.equals(refusedId)){
            return 1L;
        }
        return 0L;
    }

    private OpportunityScore getOpportunityScore(List<OpportunityRecordInfo> opportunityRecordInfos) {
        OpportunityScore opportunityScore = new OpportunityScore();
        Integer scoreDay = 0;
        Integer scoreWeek = 0;
        Integer scoreMonth = 0;
        Integer scoreYear = 0;
        Integer scoreTotal = 0;
        for (OpportunityRecordInfo info:opportunityRecordInfos){
            //总分数
            scoreTotal += info.getTrackScore();
            if (CommonUtil.isThisYear(info.getNoticeDate())){
                //本年分数
                scoreYear += info.getTrackScore();
                if (CommonUtil.isThisMonth(info.getNoticeDate())){
                    //本月分数
                    scoreMonth += info.getTrackScore();
                    if (CommonUtil.isToday(info.getNoticeDate())){
                        //今日分数
                        scoreDay += info.getTrackScore();
                    }
                }
            }
            if (CommonUtil.isThisWeek(info.getNoticeDate())){
                //本周分数
                scoreWeek += info.getTrackScore();
            }
        }
        opportunityScore.setScoreDay(scoreDay);
        opportunityScore.setScoreWeek(scoreWeek);
        opportunityScore.setScoreMonth(scoreMonth);
        opportunityScore.setScoreYear(scoreYear);
        opportunityScore.setScoreTotal(scoreTotal);
        return opportunityScore;
    }

    /**
     * 商机客户基本信息
     */
    private OpportunityBasicInformationInfo getOpportunityBasicInformation(OwnOpportunityDetailQueryRequestVO requestVO) {
        OpportunityBasicInformationInfo info = new OpportunityBasicInformationInfo();
        Long customerId = requestVO.getOpportunityId();
        Long practitionerId = requestVO.getPractitionerId();
        AclCustomer customer = aclCustomerDALService.findByCustomerId(customerId);
        info.setOpportunityId(customerId);
        info.setName(customer.getName());
        info.setAge(customer.getAge());
        info.setGender(customer.getGender());
        info.setMobileNo(customer.getMobileNo());
        info.setWeChat(customer.getWechatNo());
        info.setOtherContacts(customer.getOtherContacts());
        info.setZodiacTypeId(customer.getZodiacTypeId());
        if (!CommonUtil.isNullOrZero(customer.getZodiacTypeId())){
            MdDropOptions mdDropOption = mdDropOptionsDALService.findByDropOptionId(Long.valueOf(customer.getZodiacTypeId()));
            info.setZodiacType(mdDropOption.getDropOptionName());
        }
        info.setBloodTypeId(customer.getBloodTypeId());
        if (!CommonUtil.isNullOrZero(customer.getBloodTypeId())){
            MdDropOptions mdDropOption = mdDropOptionsDALService.findByDropOptionId(Long.valueOf(customer.getBloodTypeId()));
            info.setBloodType(mdDropOption.getDropOptionName());
        }
        String mktCampaign = customer.getMktCampaign();
        if (!CommonUtil.isNullOrBlank(mktCampaign)){
            String mktCampaignId = mktCampaign.split(",")[0];
            MdMkCampaign mdMkCampaign = mdMkCampaignDALService.findByMktCampaignId(Long.valueOf(mktCampaignId));
            info.setSourceChannel(mdMkCampaign.getName());
        } else {
            MktLeadsPool pool = mktLeadsPoolDALService.findByCustomerId(customerId);
            if(pool!=null){
                Integer sourceFrom = pool.getSourceFrom();
                if (!CommonUtil.isNullOrZero(sourceFrom)){
                    MdDropOptions dropOption = mdDropOptionsDALService.findByDropOptionId(Long.valueOf(sourceFrom));
                    info.setSourceChannel(dropOption.getDropOptionName());
                }
            }
        }
        info.setAddress(customer.getAddress());
        MktLeadsAssignedTrack mktLeadsAssignedTrack = new MktLeadsAssignedTrack();
        mktLeadsAssignedTrack.setPractitionerId(practitionerId);
        mktLeadsAssignedTrack.setCustomerId(customerId);
        PageHelper.orderBy("created_at DESC");
        List<MktLeadsAssignedTrack> mktLeadsAssignedTracks = mktLeadsAssignedTrackDALService.findByMktLeadsAssignedTrack(mktLeadsAssignedTrack);
        Long opportunityDropOptionId = 0L;
        if (!mktLeadsAssignedTracks.isEmpty()){
            opportunityDropOptionId = mktLeadsAssignedTracks.get(0).getMdDropOptionId();
        }
        info.setMdDropOptionId(opportunityDropOptionId);
        if (!CommonUtil.isNullOrZero(opportunityDropOptionId)){
            MdDropOptions mdDropOption = mdDropOptionsDALService.findByDropOptionId(opportunityDropOptionId);
            info.setMdDropOptionName(mdDropOption.getDropOptionName());
        }
        MktLeadsAssigneds mktLeadsAssigneds = new MktLeadsAssigneds();
        mktLeadsAssigneds.setCustomerId(customerId);
        mktLeadsAssigneds.setAssignedPractitionerId(practitionerId);
        List<MktLeadsAssigneds>  mktLeadsAssignedsList =mktLeadsAssignedsDALService.findByMktLeadsAssigneds(mktLeadsAssigneds);
        mktLeadsAssigneds = mktLeadsAssignedsList.get(0);
        info.setFyc(mktLeadsAssigneds.getFyc());
        info.setFyp(mktLeadsAssigneds.getFyp());
        info.setPieces(mktLeadsAssigneds.getPieces());
        info.setRemark(mktLeadsAssigneds.getRemark());
        info.setTimeToClose(CommonUtil.dateParseString(mktLeadsAssigneds.getTimeToClose(),"yyyy-MM-dd"));
        info.setOpportunityDate(CommonUtil.dateParseString(mktLeadsAssigneds.getCreatedAt(),"yyyy-MM-dd HH:mm:ss"));
        info.setOpportunityCustomerTags(OpportunityCustomerTags(customerId));
        return info;
    }

    /**
     * 客户标签查询
     */
    private List<OpportunityCustomerTag> OpportunityCustomerTags(Long customerId) {
        List<OpportunityCustomerTag> tags = new ArrayList<>();
        ObjectCollectionTagged objectCollectionTagged = new ObjectCollectionTagged();
        objectCollectionTagged.setIsActive(1);
        objectCollectionTagged.setTaggedObjectType(4);
        objectCollectionTagged.setTaggedObjectId(customerId);
        List<ObjectCollectionTagged> taggeds = objectCollectionTaggedDALService.findByObjectCollectionTagged(objectCollectionTagged);
        List<Long> tagIds = new ArrayList<>();
        for (ObjectCollectionTagged tagged: taggeds) {
            tagIds.add(Long.valueOf(tagged.getMdTagId()));
        }
        if (!tagIds.isEmpty()){
            List<MdTag> mdTags = mdTagDALService.findByTagIdIn(tagIds);
            for (MdTag mdTag:mdTags) {
                OpportunityCustomerTag tag = new OpportunityCustomerTag();
                tag.setTagId(mdTag.getId());
                tag.setTagName(mdTag.getTagName());
                tags.add(tag);
            }
        }
        return tags;
    }

    /**
     * 调查问卷答案，咨询服务
     */
    private OpportunityConsultationInfo getOpportunityConsultation(OwnOpportunityDetailQueryRequestVO requestVO) {
        OpportunityConsultationInfo info = new OpportunityConsultationInfo();
        Long orderId = requestVO.getOrderId();
        if (CommonUtil.isNullOrZero(orderId)){
            return info;
        }
        info.setOrderId(orderId);
        PoOrder poOrder = poOrderDALService.findByOrderId(requestVO.getOrderId());
        Long planId = poOrder.getPlanId();
        if (planId==453L||planId==464L) {
            info.setIsCompletedQuestionnaire(3L);
        }else {
            AclCustomerMembership membership = aclCustomerMembershipDALService.findByOrderId(requestVO.getOrderId());
            info.setIsCompletedQuestionnaire( (membership.getApproveDate() != null) ? 3L : 1L);
        }
        info.setOpportunitySurveyAnswersList(findSurveyAnswers(requestVO));
        return info;
    }

    /**
     * 问卷答案
     */
    @SuppressWarnings("unchecked")
    private List<OpportunitySurveyAnswers> findSurveyAnswers(OwnOpportunityDetailQueryRequestVO requestVO) {
        Long customerId = requestVO.getOpportunityId();
        Long orderId = requestVO.getOrderId();
        SurveyCustomerAnswers surveyCustomerAnswersQuery=new SurveyCustomerAnswers();
        surveyCustomerAnswersQuery.setOrderId(orderId);
        surveyCustomerAnswersQuery.setCustomerId(customerId);
        List<SurveyCustomerAnswers> surveyCustomerAnswersList = surveyCustomerAnswersDALService.findByObjGroupByOrderBy(surveyCustomerAnswersQuery,null,null);
        List<SurveyCustomerAnswers> surveyQuestionsList = surveyCustomerAnswersDALService.findByObjGroupByOrderBy(surveyCustomerAnswersQuery,"question_name","id");
        List<OpportunitySurveyAnswers> req=new ArrayList<>();
        for (SurveyCustomerAnswers surveyQuestions : surveyQuestionsList) {
            String questionName = surveyQuestions.getQuestionName();
            BeanPropertyValueEqualsPredicate predicateClause = new BeanPropertyValueEqualsPredicate( "questionName", questionName);
            List<SurveyCustomerAnswers> mainRisks = (List<SurveyCustomerAnswers>) CollectionUtils.select(surveyCustomerAnswersList, predicateClause);
            OpportunitySurveyAnswers surveyAnswers=new OpportunitySurveyAnswers();
            surveyAnswers.setQuestionName(surveyQuestions.getQuestionName());
            List<String> optionNameList=new ArrayList<>();
            for (SurveyCustomerAnswers surveyCustomerAnswers : mainRisks) {
                if (surveyCustomerAnswers.getOptionName() != null) {
                    optionNameList.add(surveyCustomerAnswers.getOptionName());
                }
                if (surveyCustomerAnswers.getCustomerInput() != null){
                    optionNameList.add(surveyCustomerAnswers.getCustomerInput());
                }
            }
            surveyAnswers.setOptionName(optionNameList);
            req.add(surveyAnswers);
        }
        return req;
    }

    @SuppressWarnings("unchecked")
    private List<OpportunityRecordInfo> getOpportunityRecords(OwnOpportunityDetailQueryRequestVO requestVO) {
        Long practitionerId = requestVO.getPractitionerId();
        Long customerId = requestVO.getOpportunityId();
        List<OpportunityRecordInfo> infos = new ArrayList<>();
        MktLeadsAssignedTrack mktLeadsAssignedTrack = new MktLeadsAssignedTrack();
        mktLeadsAssignedTrack.setPractitionerId(practitionerId);
        mktLeadsAssignedTrack.setCustomerId(customerId);
        PageHelper.orderBy("track_time DESC , created_at DESC , updated_at DESC");
        List<MktLeadsAssignedTrack> mktLeadsAssignedTracks = mktLeadsAssignedTrackDALService.findByMktLeadsAssignedTrack(mktLeadsAssignedTrack);
        List<MdDropOptions> dropOptionsList = mdDropOptionsDALService.findByDropMasterCode("bizchance_promotion_action");
        for (MktLeadsAssignedTrack track : mktLeadsAssignedTracks) {
            OpportunityRecordInfo info = new OpportunityRecordInfo();
            CommonUtil.simpleObjectCopy(track, info);
            info.setOpportunityId(track.getCustomerId());
            info.setNoticeDate(CommonUtil.dateParseString(track.getTrackTime(), "yyyy-MM-dd"));
            BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("id", track.getMdDropOptionId());
            List<MdDropOptions> select = (List<MdDropOptions>)CollectionUtils.select(dropOptionsList, predicate);
            if (!select.isEmpty()){
                info.setMdDropOptionName(select.get(0).getDropOptionName());
            }
            infos.add(info);
        }
        return infos;
    }

    @Override
    public RecruitResponseVO recruit(RecruitRequestVO requestVO) {
        RecruitResponseVO responseVO = new RecruitResponseVO();
        String name = requestVO.getName();
        String mobileNo = requestVO.getMobileNo();
        Long practitionerId = requestVO.getPractitionerId();
        if(!Strings.isNullOrEmpty(name) && !Strings.isNullOrEmpty(mobileNo) && practitionerId != null){
            if(mobileNo.length() != 11 || mobileNo.startsWith("1")){
                RegisterRequestVO register = new RegisterRequestVO();
                register.setMobileNo(mobileNo);
                register.setName(name);
                //将增员对象进行注册
                RegisterResponseVO registerResp = customerService.register(register);
                Long customerId = registerResp.getCustomerId();
                //判断是否已经为银盾经纪人
                AclPractitioner practitioner = aclPractitionerDALService.findByCustomerIdIsActive(customerId,1);
                if(practitioner == null){
                    //判断该增员是否已存在
                    Long potentialId = requestVO.getPotentialId();
                    List<AclPractitionerPotential> practitionerPotentialList = aclPractitionerPotentialDALService.findByMobileNo(mobileNo,1);
                    if(potentialId != null || practitionerPotentialList.isEmpty()){
                        AclPractitionerPotential practitionerPotential = new AclPractitionerPotential();
                        BeanUtils.copyProperties(requestVO,practitionerPotential);
                        practitionerPotential.setCustomerId(customerId);
                        practitionerPotential.setPractitionerAssignedIds(practitionerId.toString());
                        practitionerPotential.setCreatedAt(new Date());
                        practitionerPotential.setCreatedBy(practitionerId);
                        practitionerPotential.setCreatorType(2);
                        practitionerPotential.setIsActive(1);
                        if(potentialId != null){
                            practitionerPotential.setId(potentialId);
                            aclPractitionerPotentialDALService.update(practitionerPotential);
                        }else{
                            aclPractitionerPotentialDALService.save(practitionerPotential);
                            potentialId = practitionerPotential.getId();
                            //如果已经分配团队长，则在追踪表中增加记录
                            List<Long> practitionerPotentialIdList = new ArrayList<>();
                            practitionerPotentialIdList.add(potentialId);
                            addPractitionerPotentialTrack(practitionerPotentialIdList, practitionerId);
                        }
                        responseVO.setPotentialCustomerId(customerId);
                        responseVO.setPotentialId(potentialId);
                        responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
                    }else{
                        responseVO.setPotentialCustomerId(customerId);
                        responseVO.setPotentialId(practitionerPotentialList.get(0).getId());
                        responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("830011")));
                    }
                }else{
                    responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("830010")));
                }
            }else{
                String [] paras = {mobileNo};
                responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("630001",paras)));
            }
        }else{
            String [] paras = {"name,mobileNo,practitionerId"};
            responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("610002",paras)));
        }
        return responseVO;
    }

    private void addPractitionerPotentialTrack(List<Long> practitionerPotentialIdList, Long practitionerId) {
        if (practitionerId != null && !practitionerPotentialIdList.isEmpty()) {
            List<AclPractitionerPotentialAssignedTrack> potentialAssignedTrackList = new ArrayList<>();
            AclPractitionerPotentialAssignedTrack potentialAssignedTrack;
            List<AclPractitionerPotentialAssigneds> potentialAssignedsList = new ArrayList<>();
            AclPractitionerPotentialAssigneds potentialAssigneds;
            Long trackStatusId = 107L;
            Integer trackScore = 2;
            List<MdDropOptions> optionsList = mdDropOptionsDALService.findByMasterCodeAndOrderId("team_building_track",1);
            if(optionsList != null && !optionsList.isEmpty()){
                MdDropOptions options = optionsList.get(0);
                trackStatusId = options.getId();
                trackScore = options.getDropOptionScore();
            }
            for (Long potentialId : practitionerPotentialIdList) {
                potentialAssignedTrack = new AclPractitionerPotentialAssignedTrack();
                potentialAssignedTrack.setPractitionerPotentialId(potentialId);
                potentialAssignedTrack.setPractitionerAssignedId(practitionerId);
                potentialAssignedTrack.setTrackStatusId(trackStatusId);//待跟进
                potentialAssignedTrack.setIsActive(1);
                potentialAssignedTrack.setIsLasted(1);
                potentialAssignedTrack.setCreatedAt(new Date());
                potentialAssignedTrack.setCreatedBy(practitionerId);
                potentialAssignedTrack.setCreatorType(2);
                potentialAssignedTrack.setTrackScore(trackScore);
                potentialAssignedTrack.setTrackTime(new Date());
                potentialAssignedTrackList.add(potentialAssignedTrack);

                potentialAssigneds = new AclPractitionerPotentialAssigneds();
                potentialAssigneds.setAssignedPractitionerId(practitionerId);
                potentialAssigneds.setPractitionerPotentialId(potentialId);
                potentialAssigneds.setIsActive(1);
                potentialAssigneds.setCreatedAt(new Date());
                potentialAssigneds.setCreatedBy(practitionerId);
                potentialAssigneds.setCreatorType(2);
                potentialAssignedsList.add(potentialAssigneds);

            }
            aclPractitionerPotentialAssignedTrackDALService.saveAll(potentialAssignedTrackList);
            aclPractitionerPotentialAssignedsDALService.saveAll(potentialAssignedsList);
        }
    }

    @Override
    @Transactional
    public AddRecruitTrackResponseVO addRecruitTrack(AddRecruitTrackRequestVO requestVO) {
        AddRecruitTrackResponseVO responseVO = new AddRecruitTrackResponseVO();
        Long trackStatusId = requestVO.getTrackStatusId();
        Long practitionerId = requestVO.getPractitionerId();
        Long potentialId = requestVO.getPotentialId();
        String trackTime = requestVO.getTrackTime();
        if(trackStatusId != null && practitionerId != null && potentialId != null && !Strings.isNullOrEmpty(trackTime)){
            Date trackTimeDate = CommonUtil.stringParseDate(trackTime,"yyyy-MM-dd");
            AclPractitionerPotentialAssignedTrack assignedTrack = new AclPractitionerPotentialAssignedTrack();
            List<AclPractitionerPotentialAssignedTrack> assignedTrackIsLastedList = aclPractitionerPotentialAssignedTrackDALService.findByPotentialIdAndIsLasted(potentialId,1);
            //1、更新最新的状态
            if(assignedTrackIsLastedList != null && !assignedTrackIsLastedList.isEmpty()){
                List<AclPractitionerPotentialAssignedTrack> assignedTrackUpdateList = new ArrayList<>();
                for(AclPractitionerPotentialAssignedTrack item : assignedTrackIsLastedList){
                    item.setIsLasted(0);
                    item.setUpdatedBy(practitionerId);
                    item.setUpdaterType(2);
                    item.setUpdatedAt(new Date());
                    assignedTrackUpdateList.add(item);
                }
                aclPractitionerPotentialAssignedTrackDALService.updateAll(assignedTrackUpdateList);
            }
            //2、查询团队长对该增员所有增员状态
            List<AclPractitionerPotentialAssignedTrack> assignedTrackList = aclPractitionerPotentialAssignedTrackDALService.findByPractitionerIdAndPotentialIdAndTrackStatusId(practitionerId,potentialId,trackStatusId,trackTimeDate);
            if(assignedTrackList == null || assignedTrackList.isEmpty()){//3、如果没有，获取增员状态对应的分值，
                MdDropOptions options = mdDropOptionsDALService.findById(trackStatusId);
                assignedTrack.setTrackScore(options.getDropOptionScore());
            }else{
                assignedTrack.setTrackScore(0);
            }
            assignedTrack.setPractitionerAssignedId(practitionerId);
            assignedTrack.setPractitionerPotentialId(potentialId);
            assignedTrack.setTrackStatusId(trackStatusId);
            assignedTrack.setNotice(requestVO.getNotice());
            assignedTrack.setTrackTime(trackTimeDate);
            assignedTrack.setIsActive(1);
            assignedTrack.setIsLasted(1);
            assignedTrack.setCreatorType(2);
            assignedTrack.setCreatedBy(practitionerId);
            assignedTrack.setCreatedAt(new Date());
            aclPractitionerPotentialAssignedTrackDALService.save(assignedTrack);
            responseVO.setTrackId(assignedTrack.getId());
            responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
        }else{
            String [] paras = {"trackStatusId,practitionerId,potentialId,trackTime"};
            responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("610002",paras)));
        }
        return responseVO;
    }

    @Override
    public RecruitTrackQueryResponseVO recruitTrackQuery(RecruitTrackQueryRequestVO requestVO) {
        RecruitTrackQueryResponseVO responseVO = new RecruitTrackQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();
        Long potentialId = requestVO.getPotentialId();
        if(potentialId != null && practitionerId != null){
            List<AclPractitionerPotentialAssignedTrack> assignedTrackList = aclPractitionerPotentialAssignedTrackDALService.findByPractitionerIdAndPotentialId(practitionerId,potentialId);
            if(assignedTrackList != null && !assignedTrackList.isEmpty()){
                Map<Integer,Map<Long,String>> nameMap = getOperateName(assignedTrackList);
                Map<Long,String> userMap = nameMap.get(1);
                Map<Long,String> practitionerMap = nameMap.get(2);
                Map<Long,String> trackStatusMap = new HashMap<>();
                List<MdDropOptions> dropOptionsList = mdDropOptionsDALService.findByMasterCode("team_building_track");
                dropOptionsList.forEach(i->trackStatusMap.put(i.getId(),i.getDropOptionName()));
                List<RecruitTrackInfo> recruitTrackInfoList = new ArrayList<>();
                RecruitTrackInfo recruitTrack;
                Long operateUserId,trackStatusId;
                Integer operateUserType;
                String operateUserName;
                for(AclPractitionerPotentialAssignedTrack item : assignedTrackList){
                    operateUserId = item.getCreatedBy();
                    trackStatusId = item.getTrackStatusId();
                    operateUserType = item.getCreatorType();
                    operateUserName = (operateUserType == 1) ? userMap.get(operateUserId) : practitionerMap.get(operateUserId);
                    recruitTrack = new RecruitTrackInfo();
                    recruitTrack.setTrackId(item.getId());
                    recruitTrack.setNotice(item.getNotice());
                    recruitTrack.setOperateUserId(operateUserId);
                    recruitTrack.setOperateUserName(operateUserName);
                    recruitTrack.setTrackStatusId(trackStatusId);
                    recruitTrack.setTrackStatus(trackStatusMap.get(trackStatusId));
                    recruitTrack.setCreateAt(CommonUtil.dateParseString(item.getCreatedAt(),"yyyy-MM-dd HH:mm:ss"));
                    recruitTrack.setTrackTime(CommonUtil.dateParseString(item.getTrackTime(),"yyyy-MM-dd"));
                    recruitTrackInfoList.add(recruitTrack);
                    responseVO.setRecruitTrackInfoList(recruitTrackInfoList);
                    responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
                }
            }else{
                responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("820001")));
            }
        }else{
            String [] paras = {"practitionerId,potentialId"};
            responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("610002",paras)));
        }
        return responseVO;
    }

    private Map<Integer, Map<Long, String>> getOperateName(List<AclPractitionerPotentialAssignedTrack> assignedTrackList) {
        Map<Integer, Map<Long, String>> nameMap = new HashMap<>();
        Map<Long, String> practitionerMap = new HashMap<>();
        Map<Long, String> userMap = new HashMap<>();
        Set<Long> practitionerIdSet = new HashSet<>();
        Set<Long> userIdSet = new HashSet<>();
        for(AclPractitionerPotentialAssignedTrack item : assignedTrackList){
            if(item.getCreatorType() == 2){
                practitionerIdSet.add(item.getCreatedBy());
            }else{
                userIdSet.add(item.getCreatedBy());
            }
        }
        List<Long> practitionerIdList = new ArrayList<>(practitionerIdSet);
        List<Long> userIdList = new ArrayList<>(userIdSet);
        if(!practitionerIdList.isEmpty()){
            List<AclPractitioner> practitionerList = aclPractitionerDALService.findByIds(practitionerIdList);
            practitionerList.forEach(i->practitionerMap.put(i.getId(),i.getName()));
        }
        if(!userIdList.isEmpty()){
            List<AclUser> userList = aclUserDALService.findByIds(userIdList);
            userList.forEach(i->userMap.put(i.getId(),i.getName()));
        }
        nameMap.put(1,userMap);
        nameMap.put(2,practitionerMap);
        return nameMap;
    }

    @Override
    public RecruitListResponseVO recruitListQuery(RecruitListRequestVO requestVO) {
        RecruitListResponseVO responseVO = new RecruitListResponseVO();
        Long practitionerId = requestVO.getPractitionerId();
        if(practitionerId != null){
            Integer status = requestVO.getStatus();
            //1、获取用户数据
            List<PractitionerPotentialInfo> practitionerPotentialInfoList = aclPractitionerPotentialDALService.findByPractitionerIdAndLasted(practitionerId);
            if(practitionerPotentialInfoList != null && !practitionerPotentialInfoList.isEmpty()){
                List<MdDropOptions> trackStatusList = mdDropOptionsDALService.findByMasterCode("team_building_track");
                Map<Integer,Long> trackStatusInfo = getTrackStatusInfo(trackStatusList);
                Long firstTrackStatusId = trackStatusInfo.get(1);
                Long LastStatusId = trackStatusInfo.get(2);
                Map<Long,String> trackStatusMap = new HashMap<>();
                trackStatusList.forEach(i->trackStatusMap.put(i.getId(),i.getDropOptionName()));
                List<MdDropOptions> recruitSourceList = mdDropOptionsDALService.findByMasterCode("team_building_source");
                Map<Long,String> recruitSourceMap = new HashMap<>();
                recruitSourceList.forEach(i->recruitSourceMap.put(i.getId(),i.getDropOptionName()));
                List<PractitionerPotentialInfo> potentialInfoList = new ArrayList<>();
                Long trackStatusId;
                for(PractitionerPotentialInfo item : practitionerPotentialInfoList){
                    trackStatusId = item.getTrackStatusId();
                    if(status != null){
                        if(status == 1 && trackStatusId.longValue() == firstTrackStatusId){
                            getResponseMessage(potentialInfoList,trackStatusMap,recruitSourceMap,item);
                        }else if(status == 3 && trackStatusId.longValue() == LastStatusId){
                            getResponseMessage(potentialInfoList,trackStatusMap,recruitSourceMap,item);
                        }else if(status == 2 && trackStatusId.longValue() != LastStatusId && trackStatusId.longValue() != firstTrackStatusId){
                            getResponseMessage(potentialInfoList,trackStatusMap,recruitSourceMap,item);
                        }
                    }else{
                        getResponseMessage(potentialInfoList,trackStatusMap,recruitSourceMap,item);
                    }
                }
                responseVO.setPractitionerPotentialInfoList(potentialInfoList);
                responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
            }else{
                responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("820001")));
            }
        }else{
            String [] paras = {"practitionerId"};
            responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("610002",paras)));
        }
        return responseVO;
    }


    private void getResponseMessage(List<PractitionerPotentialInfo> potentialInfoList, Map<Long, String> trackStatusMap,Map<Long,String> recruitSourceMap, PractitionerPotentialInfo item) {
        PractitionerPotentialInfo potentialInfo = new PractitionerPotentialInfo();
        BeanUtils.copyProperties(item,potentialInfo);
        potentialInfo.setTrackStatus(trackStatusMap.get(item.getTrackStatusId()));
        potentialInfo.setResourceDropMasterName(recruitSourceMap.get(item.getResourceDropMasterId()));
        potentialInfoList.add(potentialInfo);
    }

    private Map<Integer,Long> getTrackStatusInfo(List<MdDropOptions> trackStatusList) {
        Map<Integer,Long> trackStatusInfo = new HashMap<>();
        Long firstTrackStatusId = null ,LastStatusId = null,id;
        Integer orderId,min = null,max = null;
        for(MdDropOptions item : trackStatusList){
            id = item.getId();
            orderId = item.getDropOptionOrder();
            if(orderId < 50){
                if(firstTrackStatusId == null){
                    firstTrackStatusId = LastStatusId = id;
                    min = max = orderId;
                }else{
                    if(orderId < min){
                        firstTrackStatusId = id;
                        min = orderId;
                    }else if(orderId > max){
                        LastStatusId = id;
                        max = orderId;
                    }
                }
            }
        }
        trackStatusInfo.put(1,firstTrackStatusId);
        trackStatusInfo.put(2,LastStatusId);
        return trackStatusInfo;
    }

    @Override
    public OwnOpportunityBasicInformationSaveResponseVO ownOpportunityBasicInformationSave(OwnOpportunityBasicInformationSaveRequestVO requestVO) {
        OwnOpportunityBasicInformationSaveResponseVO resp = new OwnOpportunityBasicInformationSaveResponseVO();
        Long leadsAssignedId = requestVO.getLeadsAssignedId();
        Long customerId = requestVO.getOpportunityId();
        if (CommonUtil.isNullOrZero(leadsAssignedId)){
            //判断是否为经纪人自己创建商机
            CommonResult commonResult = isCreateOpportunity(requestVO);
            if (!commonResult.isSuccess()){
                resp.setCommonResult(commonResult);
                return resp;
            }
            customerId = requestVO.getOpportunityId();
        }

        //保存基础信息
        saveCustomerInfo(customerId,requestVO);
        //保存/激活新的标签
        saveCustomerTag(customerId,requestVO.getOpportunityCustomerTags());
        //更新预设值
        saveLeadsAssigneds(requestVO);
        resp.setLeadsAssignedId(requestVO.getLeadsAssignedId());
        resp.setOpportunityId(customerId);
        resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return resp;
    }

    private CommonResult isCreateOpportunity(OwnOpportunityBasicInformationSaveRequestVO requestVO) {
        Long customerId;
        //当指派id为null时,认为是保存新的商机
        //校验商机号码,手机号码对应的customer是否存在
        String mobileNo = requestVO.getMobileNo();
        AclCustomer aclCustomer = aclCustomerDALService.findByMobileNo(mobileNo);
        //判断是否通过手机号码找到客户
        if (aclCustomer!=null){
            MktLeadsAssigneds mktLeadsAssigneds = new MktLeadsAssigneds();
            mktLeadsAssigneds.setCustomerId(aclCustomer.getId());
            List<MktLeadsAssigneds> mktLeadsAssignedsList = mktLeadsAssignedsDALService.findByMktLeadsAssigneds(mktLeadsAssigneds);
            if (!mktLeadsAssignedsList.isEmpty()){
                MktLeadsAssignedTrack leadsAssignedTrack = mktLeadsAssignedTrackDALService.findByListNotesForCustomerId(aclCustomer.getId());
                Long mdDropOptionId = leadsAssignedTrack.getMdDropOptionId();
                //判断最后一条跟进状态是否为失败,是失败则无需判断经纪人id和之前是否一致
                MdDropOptions mdDropOption = mdDropOptionsDALService.findById(mdDropOptionId);
                if (!"refused".equalsIgnoreCase(mdDropOption.getDropOptionCode())){
                    //跳出错误
                    return new CommonResult(false,ZHBErrorConfig.getErrorInfo("830014"));
                }
            }
        }else {
            //此人为第一次进来
            //帮其经行注册
            DESTypeHandler jpaCryptoConverter = new DESTypeHandler();
            aclCustomer = new AclCustomer();
            aclCustomer.setRole(2);//1= Staff 2=Customer 3=Partner
            aclCustomer.setAccountId(createAccountId(mobileNo));
            aclCustomer.setLogin(mobileNo);
            aclCustomer.setMobileNo(jpaCryptoConverter.encode(mobileNo));
            aclCustomer.setCusLevel(1);
            aclCustomer.setName(requestVO.getName());
            aclCustomer.setIsActive(1);
            aclCustomer.setRoleId(3L);
            aclCustomer.setWithdrawType(0);
            aclCustomer.setCreatedAt(new Date());
            aclCustomer.setCreatedBy(-1L);
            aclCustomer.setUpdatedAt(new Date());
            aclCustomer.setUpdatedBy(-1L);
            aclCustomer.setChannelReferralRateId(3L);
            aclCustomerDALService.save(aclCustomer);
        }
        customerId = aclCustomer.getId();
        //查询此customer是否在pool中
        MktLeadsPool pool = mktLeadsPoolDALService.findByCustomerId(customerId);
        if (pool == null){
            //线索池为空时,保存线索池
            pool = new MktLeadsPool();
            pool.setCustomerId(customerId);
            pool.setHasAssigned(1);
            pool.setSourceFrom(requestVO.getSourceFrom());
            pool.setIsActive(1);
            pool.setAddedAt(new Date());
            pool.setAddedBy(-1L);
            mktLeadsPoolDALService.save(pool);
        }
        //保存至指派表
        MktLeadsAssigneds assigneds = new MktLeadsAssigneds();
        assigneds.setAssignedPractitionerId(requestVO.getAssignedPractitionerId());
        assigneds.setCustomerId(customerId);
        assigneds.setIsActive(1);
        assigneds.setCreatedAt(new Date());
        assigneds.setCreatedBy(-1L);
        assigneds.setUpdatedAt(new Date());
        assigneds.setUpdatedBy(-1L);
        mktLeadsAssignedsDALService.save(assigneds);
        //更新跟进表初始值
        String mdDropOptionsId = systemConfigService.getSingleConfigValue("OpportunityToBeFollowedUp");
        MdDropOptions mdDropOptions = mdDropOptionsDALService.findById(Long.valueOf(mdDropOptionsId));
        MktLeadsAssignedTrack leadsAssignedTrack = new MktLeadsAssignedTrack();
        leadsAssignedTrack.setSalesNotice("获得此商机,"+CommonUtil.dateParseString(new Date(),"yyyy-MM-dd HH:mm:ss"));
        leadsAssignedTrack.setTrackScore(mdDropOptions.getDropOptionScore());
        leadsAssignedTrack.setIsActive(1);
        leadsAssignedTrack.setCreatedAt(new Date());
        leadsAssignedTrack.setCreatedBy(requestVO.getAssignedPractitionerId());
        leadsAssignedTrack.setUpdatedAt(new Date());
        leadsAssignedTrack.setUpdatedBy(requestVO.getAssignedPractitionerId());
        leadsAssignedTrack.setPractitionerId(requestVO.getAssignedPractitionerId());
        leadsAssignedTrack.setCustomerId(customerId);
        leadsAssignedTrack.setMdDropOptionId(Long.valueOf(mdDropOptionsId));
        leadsAssignedTrack.setLeadsAssignedId(assigneds.getId());
        leadsAssignedTrack.setTrackTime(new Date());
        leadsAssignedTrack.setCreatorType(2);
        leadsAssignedTrack.setUpdatorType(2);
        mktLeadsAssignedTrackDALService.saveTrack(leadsAssignedTrack);
        requestVO.setOpportunityId(customerId);
        requestVO.setLeadsAssignedId(assigneds.getId());
        return new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000"));
    }

    private String createAccountId(String mobileNo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String sub = null;
        if(mobileNo != null && !"".equals(mobileNo)){
            sub = mobileNo.substring(mobileNo.length()-6);
        }
        return "C_"+sub+"_"+sdf.format(new Date());
    }

    private void saveCustomerInfo(Long customerId, OwnOpportunityBasicInformationSaveRequestVO requestVO) {
        AclCustomer customer = aclCustomerDALService.findById(customerId);
        DESTypeHandler jpaCryptoConverter = new DESTypeHandler();
        String mobileNo = customer.getMobileNo();
        String idNo = customer.getIdNo();
        customer.setMobileNo(jpaCryptoConverter.encode(mobileNo));
        customer.setIdNo(jpaCryptoConverter.encode(idNo));
        customer.setName(requestVO.getName());
        customer.setBirthDate(CommonUtil.stringParseDate(requestVO.getBirthDate(),"yyyy-MM-dd"));
        customer.setGender(requestVO.getGender());
        customer.setAddress(requestVO.getAddress());
        customer.setAge(requestVO.getAge());
        customer.setWechatNo(requestVO.getWeChat());
        customer.setOtherContacts(requestVO.getOtherContacts());
        customer.setZodiacTypeId(requestVO.getZodiacTypeId());
        customer.setBloodTypeId(requestVO.getBloodTypeId());
        aclCustomerDALService.update(customer);
    }

    private void saveLeadsAssigneds(OwnOpportunityBasicInformationSaveRequestVO requestVO) {
        Long leadsAssignedId = requestVO.getLeadsAssignedId();
        MktLeadsAssigneds mktLeadsAssigneds = mktLeadsAssignedsDALService.findByLeadsAssignedId(leadsAssignedId);
        mktLeadsAssigneds.setFyc(requestVO.getFyc());
        mktLeadsAssigneds.setFyp(requestVO.getFyp());
        mktLeadsAssigneds.setPieces(requestVO.getPieces());
        mktLeadsAssigneds.setTimeToClose(CommonUtil.stringParseDate(requestVO.getTimeToClose(),"yyyy-MM-dd"));
        mktLeadsAssigneds.setRemark(requestVO.getRemark());
        mktLeadsAssignedsDALService.updateMktLeadsAssigneds(mktLeadsAssigneds);
    }

    private void saveCustomerTag(Long customerId ,List<OpportunityCustomerTag> opportunityCustomerTags) {
        //保存标签
        //此人的原有标签全部至0
        ObjectCollectionTagged tagged = new ObjectCollectionTagged();
        tagged.setTaggedObjectType(4);
        tagged.setTaggedObjectId(customerId);
        List<ObjectCollectionTagged> taggedList = objectCollectionTaggedDALService.findByObjectCollectionTagged(tagged);
        for (ObjectCollectionTagged tag:taggedList) {
            tag.setIsActive(0);
            objectCollectionTaggedDALService.updateObjectCollectionTagged(tag);
        }
        for (OpportunityCustomerTag tag:opportunityCustomerTags) {
            tagged = new ObjectCollectionTagged();
            tagged.setTaggedObjectType(4);
            tagged.setTaggedObjectId(customerId);
            tagged.setMdTagId(tag.getTagId().intValue());
            List<ObjectCollectionTagged> taggeds = objectCollectionTaggedDALService.findByObjectCollectionTagged(tagged);
            if (taggeds.isEmpty()){
                //保存
                tagged.setIsActive(1);
                tagged.setRecommendOrder(1);
                tagged.setDisplayOrder(1);
                tagged.setCreatedBy(-1L);
                tagged.setCreatedAt(new Date());
                tagged.setUpdatedBy(-1L);
                tagged.setUpdatedAt(new Date());
                objectCollectionTaggedDALService.saveObjectCollectionTagged(tagged);
            }else {
                //更新
                tagged = taggeds.get(0);
                tagged.setIsActive(1);
                tagged.setUpdatedBy(-1L);
                tagged.setUpdatedAt(new Date());
                objectCollectionTaggedDALService.updateObjectCollectionTagged(tagged);
            }
        }
    }

    @Override
    public OwnOpportunityRecordSaveResponseVO ownOpportunityRecordSave(OwnOpportunityRecordSaveRequestVO requestVO) {
        OwnOpportunityRecordSaveResponseVO resp = new OwnOpportunityRecordSaveResponseVO();
        CommonResult commonResult = check(requestVO);
        if (!commonResult.isSuccess()){
            resp.setCommonResult(commonResult);
            return resp;
        }

        MktLeadsAssignedTrack track = new MktLeadsAssignedTrack();
        CommonUtil.simpleObjectCopy(requestVO,track);
        track.setCustomerId(requestVO.getOpportunityId());
        track.setTrackTime(CommonUtil.stringParseDate(requestVO.getNoticeDate()+" 00:00:00", "yyyy-MM-dd HH:mm:ss"));
        track.setCreatedBy(requestVO.getPractitionerId());
        track.setCreatedAt(new Date());
        track.setCreatorType(2);
        track.setUpdatedBy(requestVO.getPractitionerId());
        track.setUpdatorType(2);
        track.setUpdatedAt(new Date());
        MdDropOptions dropOtions = mdDropOptionsDALService.findByDropOptionId(requestVO.getMdDropOptionId());
        track.setTrackScore(dropOtions.getDropOptionScore());
        if (CommonUtil.isNullOrZero(requestVO.getId())){
            //保存
            mktLeadsAssignedTrackDALService.saveTrack(track);
        }else {
            //更新
            mktLeadsAssignedTrackDALService.updateTrack(track);
        }
        resp.setOpportunityId(requestVO.getOpportunityId());
        resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return resp;
    }

    @Override
    public OpportunityStatisticsResponseVO opportunityStatistics(OpportunityStatisticsRequestVO requestVO) {
        OpportunityStatisticsResponseVO resp = new OpportunityStatisticsResponseVO();
        //计算商机得分 今天,本周,本月
        MktLeadsAssignedTrack mktLeadsAssignedTrack = new MktLeadsAssignedTrack();
        mktLeadsAssignedTrack.setPractitionerId(requestVO.getPractitionerId());
        PageHelper.orderBy("track_time DESC");
        List<MktLeadsAssignedTrack> mktLeadsAssignedTracks = mktLeadsAssignedTrackDALService.findByMktLeadsAssignedTrack(mktLeadsAssignedTrack);
        Integer scoreDay = 0;
        Integer scoreWeek = 0;
        Integer scoreMonth = 0;
        for (MktLeadsAssignedTrack info : mktLeadsAssignedTracks){
            boolean isStatistics = false;
            String time = CommonUtil.dateParseString(info.getTrackTime(), "yyyy-MM-dd");
            if (CommonUtil.isThisMonth(time)){
                scoreMonth += info.getTrackScore();
                if (CommonUtil.isToday(time)){
                    scoreDay += info.getTrackScore();
                }
                isStatistics = true;
            }
            if (CommonUtil.isThisWeek(time)){
                scoreWeek += info.getTrackScore();
                isStatistics = true;
            }
            //既不属于月也不属于周跳出
            if (!isStatistics){
                break;
            }
        }
        //计算新增商机个数
        List<MktLeadsAssigneds> mktLeadsAssigneds = mktLeadsAssignedsDALService.findByPractitionerIdAndThisWeek(requestVO.getPractitionerId());
        //计算经纪人目标得分
        MktLeadsGoalsActions mktLeadsGoalsActions = new MktLeadsGoalsActions();
        mktLeadsGoalsActions.setPractitionerId(requestVO.getPractitionerId());
        //当前年份
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        mktLeadsGoalsActions.setCurrentYear(year);
        mktLeadsGoalsActions.setIsActive(1);
        List<MktLeadsGoalsActions> leadsGoalsActions = mktLeadsGoalsActionsDALService.findByMktLeadsGoalsActions(mktLeadsGoalsActions);
        if (!leadsGoalsActions.isEmpty()){
            List<MdDropOptions> mdDropOptionsList = mdDropOptionsDALService.findByDropMasterCode("bizchance_promotion_action");
            ConcurrentMap<Long,Integer> optionScoreMap = new ConcurrentHashMap<>();
            for (MdDropOptions info : mdDropOptionsList){
                optionScoreMap.put(info.getId(),info.getDropOptionScore());
            }
            int targetScoreMonth = 0;
            for (MktLeadsGoalsActions info : leadsGoalsActions){
                Long leadsActionId = info.getLeadsActionId();
                Integer singleScore = optionScoreMap.get(leadsActionId);
                targetScoreMonth += singleScore * info.getActionStandards();
            }
            Double achievementRateMonth = BigDecimal.valueOf(scoreMonth)
                    .divide(BigDecimal.valueOf(targetScoreMonth),4,BigDecimal.ROUND_HALF_UP)
                    .doubleValue();
            Double achievementRateWeek = BigDecimal.valueOf(scoreWeek)
                    .divide(BigDecimal.valueOf(targetScoreMonth),4,BigDecimal.ROUND_HALF_UP)
                    .multiply(BigDecimal.valueOf(12))
                    .divide(BigDecimal.valueOf(52),4,BigDecimal.ROUND_HALF_UP)
                    .doubleValue();
            resp.setAchievementRateMonth(achievementRateMonth);
            resp.setAchievementRateWeek(achievementRateWeek);
        }
        resp.setScoreDay(scoreDay);
        resp.setScoreWeek(scoreWeek);
        resp.setScoreMonth(scoreMonth);
        resp.setAddOpportunityNum(mktLeadsAssigneds.size());
        resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return resp;
    }

    @Override
    @Transactional
    public SalesTargetSaveResponseVO salesTargetSave(SalesTargetSaveRequestVO requestVO) {
        SalesTargetSaveResponseVO responseVO = new SalesTargetSaveResponseVO();
        //经纪人id
        Long practitionerId = requestVO.getPractitionerId();
        //当前年份
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        Integer goalsType = requestVO.getGoalsType();
        //初始化之前数据  全部修改为不启用
        initializationAction(practitionerId,year,goalsType);
        AclPractitionerSubordinateSystem subordinate;
        if (goalsType == 2){
            //查询经纪人所在团队
            List<AclPractitionerSubordinateSystem> subordinates = aclPractitionerSubordinateSystemDALService.findByOwnerPractitionerId(practitionerId);
            if (subordinates.isEmpty()){
                responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830016")));
                return responseVO;
            }
            subordinate = subordinates.get(0);
        }else {
            subordinate = aclPractitionerSubordinateSystemDALService.findByPractitionerId(practitionerId);
            if (subordinate == null){
                responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830018")));
                return responseVO;
            }
        }
        //保存年目标
        Date date = new Date();
        saveYearGoal(requestVO,practitionerId,date,year,goalsType,subordinate);

        //保存月目标
        List<SalesTargetMonth> salesTargetMonths = requestVO.getSalesTargetMonths();
        for(SalesTargetMonth info: salesTargetMonths){
            saveMonthGoal(info,practitionerId,date,year,goalsType,subordinate);
        }

        //经纪人保存/团队不需保存
        if (goalsType==1){
            //保存经纪人商机活动量均分
            MdDropMaster mdDropMaster = mdDropMasterDALService.findByScenarioCode("bizchance_promotion_action");
            Long masterId = mdDropMaster.getId();
            //查询出所有计算公式
            //件数  年总
            Integer pieces = requestVO.getPieces();
            int piecesMonth = BigDecimal.valueOf(pieces).divide(BigDecimal.valueOf(12),0, BigDecimal.ROUND_UP).intValue();
            System.out.println("piecesMonth:"+piecesMonth);
            ScriptEngine jScriptEngine=new ScriptEngineManager().getEngineByName("JavaScript");
            List<MdGoalsCalculateExpression> list = mdGoalsCalculateExpressionService.findByMasterId(masterId);
            List<SalesTargetActions> salesTargetActionsList = new ArrayList<>();
            for (MdGoalsCalculateExpression info : list){
                //保存经纪人商机活动量分摊细化设置  ag_mkt_leads_goals_actions
                SalesTargetActions salesTargetAction = saveLeadsGoalsActions(info,jScriptEngine,year,piecesMonth,practitionerId,date,goalsType);
                salesTargetActionsList.add(salesTargetAction);
            }
            responseVO.setSalesTargetActions(salesTargetActionsList);
        }

        BeanUtils.copyProperties(requestVO,responseVO);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public SalesTargetQueryResponseVO salesTargetQuery(SalesTargetQueryRequestVO requestVO) {
        SalesTargetQueryResponseVO responseVO = new SalesTargetQueryResponseVO();
        //经纪人id
        Long practitionerId = requestVO.getPractitionerId();
        //当前年份
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        Integer goalsType = requestVO.getGoalsType();
        //通过is_active = 1  经纪人id 和 目标所属年度 去查询ag_mkt_leads_goals/ag_mkt_leads_goals_actions
        MktLeadsGoals mktLeadsGoals = new MktLeadsGoals();
        mktLeadsGoals.setIsActive(1);
        mktLeadsGoals.setPractitionerId(practitionerId);
        mktLeadsGoals.setCurrentYear(year);
        mktLeadsGoals.setGoalsType(goalsType);
        AclPractitionerSubordinateSystem subordinateSystem ;
        if (goalsType == 2){
            List<AclPractitionerSubordinateSystem> subordinateSystems = aclPractitionerSubordinateSystemDALService.findByOwnerPractitionerId(practitionerId);
            if (subordinateSystems.isEmpty()){
                responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("830017")));
                return responseVO;
            }
            subordinateSystem = subordinateSystems.get(0);
        }else {
            subordinateSystem = aclPractitionerSubordinateSystemDALService.findByPractitionerId(practitionerId);
            if (subordinateSystem == null){
                responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("830017")));
                return responseVO;
            }
        }
        mktLeadsGoals.setSubordinateSystemId(subordinateSystem.getId());
        List<MktLeadsGoals> mktLeadsGoalsList = mktLeadsGoalsDALService.findByMktLeadsGoals(mktLeadsGoals);
        List<SalesTargetMonth> salesTargetMonthList = new ArrayList<>();
        for (MktLeadsGoals info :mktLeadsGoalsList){
            Integer statisticTimeUnit = info.getStatisticTimeUnit();
            if (statisticTimeUnit==1){//年
                responseVO.setPremium(info.getPremium());
                responseVO.setCommission(info.getCommission());
                responseVO.setPieces(info.getPieces());
                responseVO.setPieceAveragePremium(info.getPieceAveragePremium());
            }else if (statisticTimeUnit==3){//月
                SalesTargetMonth salesTargetMonth = new SalesTargetMonth();
                salesTargetMonth.setCommission(info.getCommission());
                salesTargetMonth.setMonthNum(info.getSeqTime());
                salesTargetMonth.setPieceAveragePremium(info.getPieceAveragePremium());
                salesTargetMonth.setPieces(info.getPieces());
                salesTargetMonth.setPremium(info.getPremium());
                salesTargetMonthList.add(salesTargetMonth);
            }
        }

        MktLeadsGoalsActions mktLeadsGoalsActions = new MktLeadsGoalsActions();
        mktLeadsGoalsActions.setIsActive(1);
        mktLeadsGoalsActions.setPractitionerId(practitionerId);
        mktLeadsGoalsActions.setCurrentYear(year);
        mktLeadsGoalsActions.setGoalsType(goalsType);
        List<MktLeadsGoalsActions> mktLeadsGoalsActionsList = mktLeadsGoalsActionsDALService.findByMktLeadsGoalsActions(mktLeadsGoalsActions);
        List<SalesTargetActions> salesTargetActions = new ArrayList<>();
        for (MktLeadsGoalsActions info : mktLeadsGoalsActionsList){
            SalesTargetActions salesTargetAction = new SalesTargetActions();
            salesTargetAction.setStatisticTimeUnit(3);
            salesTargetAction.setActionStandards(info.getActionStandards());
            salesTargetAction.setLeadsActionId(info.getLeadsActionId());
            salesTargetAction.setLeadsActionName(info.getLeadsActionName());
            salesTargetActions.add(salesTargetAction);
        }

        responseVO.setPractitionerId(practitionerId);
        responseVO.setSalesTargetMonths(salesTargetMonthList);
        responseVO.setSalesTargetActions(salesTargetActions);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public SalesTargetMonthSaveResponseVO salesTargetMonthSave(SalesTargetMonthSaveRequestVO requestVO) {
        SalesTargetMonthSaveResponseVO responseVO = new SalesTargetMonthSaveResponseVO();
        //经纪人id
        Long practitionerId = requestVO.getPractitionerId();
        //当前年份
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        Integer goalsType = requestVO.getGoalsType();
        mktLeadsGoalsActionsDALService.updateIsActiveIsNull(practitionerId,year,goalsType);
        List<SalesTargetActions> salesTargetActionsList = requestVO.getSalesTargetActionsList();
        Date date = new Date();
        MktLeadsGoalsActions mktLeadsGoalsActions;
        for (SalesTargetActions info : salesTargetActionsList){
            mktLeadsGoalsActions = new MktLeadsGoalsActions();
            mktLeadsGoalsActions.setPractitionerId(practitionerId);
            mktLeadsGoalsActions.setGoalsType(goalsType);
            mktLeadsGoalsActions.setCurrentYear(year);
            mktLeadsGoalsActions.setStatisticTimeUnit(3);
            mktLeadsGoalsActions.setLeadsActionId(info.getLeadsActionId());
            mktLeadsGoalsActions.setLeadsActionName(info.getLeadsActionName());
            mktLeadsGoalsActions.setActionStandards(info.getActionStandards());
            mktLeadsGoalsActions.setCurrentVersion(date);
            mktLeadsGoalsActions.setIsActive(1);
            mktLeadsGoalsActions.setCreatedAt(new Date());
            mktLeadsGoalsActions.setCreatedBy(practitionerId);
            mktLeadsGoalsActions.setUpdatedAt(new Date());
            mktLeadsGoalsActions.setUpdatedBy(practitionerId);
            mktLeadsGoalsActionsDALService.save(mktLeadsGoalsActions);
        }
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public TeamActionsAverageQueryResponseVO teamScoreAverageQuery(TeamActionsAverageQueryRequestVO requestVO) {
        TeamActionsAverageQueryResponseVO responseVO = new TeamActionsAverageQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();
        //该团队长下团队所有经纪人信息
        List<AclPractitioner> aclPractitioners = aclPractitionerDALService.findForSubordinateIdByPractitionerId(practitionerId);
        //团队经纪人个数
        BigDecimal practitionerNum = BigDecimal.valueOf(aclPractitioners.size());
        List<Long> practitionerIds = new ArrayList<>();
        for (AclPractitioner info : aclPractitioners){
            practitionerIds.add(info.getId());
        }

        //查询此团队经纪人所有得跟进状态
        List<MdDropOptions> mdDropOptions = mdDropOptionsDALService.findByDropMasterCode("bizchance_promotion_action");
        ConcurrentMap<String,Long> optionCodeToId = new ConcurrentHashMap<>();
        for (MdDropOptions info : mdDropOptions){
            optionCodeToId.put(info.getDropOptionCode(),info.getId());
        }
        //查询其团队天,周,月总分
        HashMap<String,BigDecimal> totalStatistics = mktLeadsAssignedTrackDALService.totalStatisticsForTeam(practitionerIds);
        //总分除以人数得到均分
        Double scoreDayAverage = getScoreAverage(totalStatistics.get("scoreToday"),practitionerNum);
        Double scoreWeekAverage= getScoreAverage(totalStatistics.get("scoreWeek"),practitionerNum);
        Double scoreMonthAverage= getScoreAverage(totalStatistics.get("scoreMonth"),practitionerNum);

        //计算此团队一周增加的商机数 ag_mkt_leads_assigneds
        Integer opportunitiesNum = mktLeadsAssignedsDALService.countPractitionerIdsAndThisWeek(practitionerIds);
        //计算年/季/月  首年保费(premium)/佣金(commission)/件数(pieces)  均取至指派表ag_mkt_leads_assigneds
        //拿到商机跟踪,失败id
        Long refusedId = optionCodeToId.get("refused");
        HashMap<String,BigDecimal> performanceForecast = mktLeadsAssignedsDALService.performanceForecastForTeam(practitionerIds,refusedId);

        List<MktLeadsGoals> leadsGoals = getYearTeamGoals(practitionerId);
        ConcurrentHashMap<String,Double> achievementRateMap = new ConcurrentHashMap<>();
        if (!leadsGoals.isEmpty()){
            //计算完成率
            achievementRateMap = getAchievementRate(leadsGoals,performanceForecast);
        }

        responseVO.setScoreDayAverage(scoreDayAverage);
        responseVO.setScoreWeekAverage(scoreWeekAverage);
        responseVO.setScoreMonthAverage(scoreMonthAverage);
        responseVO.setOpportunitiesNum(opportunitiesNum);
        responseVO.setPremiumMonth(performanceForecast.get("totalFYPMonth").doubleValue());
        responseVO.setCommissionMonth(performanceForecast.get("totalFYCMonth").doubleValue());
        responseVO.setPiecesMonth(performanceForecast.get("totalPiecesMonth").doubleValue());
        responseVO.setPremiumQuarter(performanceForecast.get("totalFYPQuarter").doubleValue());
        responseVO.setCommissionQuarter(performanceForecast.get("totalFYCQuarter").doubleValue());
        responseVO.setPiecesQuarter(performanceForecast.get("totalPiecesQuarter").doubleValue());
        responseVO.setPremiumYear(performanceForecast.get("totalFYPYear").doubleValue());
        responseVO.setCommissionYear(performanceForecast.get("totalFYCYear").doubleValue());
        responseVO.setPiecesYear(performanceForecast.get("totalPiecesYear").doubleValue());
        responseVO.setAchievementRateYear(achievementRateMap.get("achievementRateYear"));
        responseVO.setAchievementRateQuarter(achievementRateMap.get("achievementRateQuarter"));
        responseVO.setAchievementRateMonth(achievementRateMap.get("achievementRateMonth"));
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public PlayerSalesActivityQueryResponseVO playerSalesActivityQuery(PlayerSalesActivityQueryRequestVO requestVO) {
        PlayerSalesActivityQueryResponseVO responseVO = new PlayerSalesActivityQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();
        MdDropOptions mdDropOptions = mdDropOptionsDALService.selectByMasterCodeAndOptionsCode("bizchance_promotion_action","refused");
        List<PlayerSalesActivityInfo> playerSalesActivityInfos = aclPractitionerDALService.playerSalesActivityQuery(practitionerId,mdDropOptions.getId());
        //计算完成率
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        //通过团队长经纪人id查询出团队所有人设置的目标
        List<MktLeadsGoalsActions> mktLeadsGoalsActions = mktLeadsGoalsActionsDALService.findTeamGoalsMonth(practitionerId,year);
        List<MdDropOptions> mdDropOptionsList = mdDropOptionsDALService.findByDropMasterCode("bizchance_promotion_action");
        ConcurrentHashMap<Long , Integer> optionsIdToScore = new ConcurrentHashMap<>();
        for (MdDropOptions info : mdDropOptionsList){
            optionsIdToScore.put(info.getId(),info.getDropOptionScore());
        }
        for (PlayerSalesActivityInfo info : playerSalesActivityInfos){
            //总分数
            int predictionScore = 0;
            for (MktLeadsGoalsActions actions : mktLeadsGoalsActions){
                if (info.getPractitionerId().equals(actions.getPractitionerId())){
                    predictionScore += actions.getActionStandards() * optionsIdToScore.get(actions.getLeadsActionId());
                }
            }
            if (!CommonUtil.isNullOrZero(predictionScore)){
                BigDecimal achievementRateMonth =  info.getScoreMonth().divide(BigDecimal.valueOf(predictionScore),4,BigDecimal.ROUND_HALF_UP);
                info.setAchievementRateMonth(achievementRateMonth.doubleValue());
            }
        }
        responseVO.setPlayerSalesActivityInfo(playerSalesActivityInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public SalesPerformanceForecastListQueryResponseVO salesPerformanceForecastListQuery(SalesPerformanceForecastListQueryRequestVO requestVO) {
        SalesPerformanceForecastListQueryResponseVO responseVO = new SalesPerformanceForecastListQueryResponseVO();
        List<SalesPerformanceForecastInfo> infos = new ArrayList<>();
        //通过团队长经纪人id,查询此团队所有经纪人id
        Long practitionerId = requestVO.getPractitionerId();
        List<AclPractitioner> practitioners = aclPractitionerDALService.findForSubordinateIdByPractitionerId(practitionerId);
        if (practitioners.isEmpty()){
            responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
            return responseVO;
        }
        List<Long> practitionerIds = new ArrayList<>();
        ConcurrentHashMap<Long,String> practitionerIdToName = new ConcurrentHashMap<>();
        for (AclPractitioner aclPractitioner : practitioners){
            practitionerIds.add(aclPractitioner.getId());
            practitionerIdToName.put(aclPractitioner.getId(),aclPractitioner.getName());
        }
        //通过团队所有经纪人id,去查询自己的预测值
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        List<MktLeadsGoals> mktLeadsGoals = mktLeadsGoalsDALService.selectByPractitionerIds(practitionerIds,year);
        //查询词团队所有经纪人的商机预测值
        MdDropOptions mdDropOptions = mdDropOptionsDALService.selectByMasterCodeAndOptionsCode("bizchance_promotion_action","refused");
        List<MktLeadsAssigneds> mktLeadsAssigneds = mktLeadsAssignedsDALService.selectByPractitionerIdRemoveRefused(practitionerIds,mdDropOptions.getId());

        String time = requestVO.getTime();
        if ("M".equalsIgnoreCase(time)){
            //月度
            int month = cal.get(Calendar.MONTH) + 1;
            infos = getMouthPerformanceForecast(practitionerIds,mktLeadsGoals,mktLeadsAssigneds,practitionerIdToName,month);
        }else if ("Q".equalsIgnoreCase(time)){
            //季度
            int month = cal.get(Calendar.MONTH) + 1;
            infos = getQuarterPerformanceForecast(practitionerIds,mktLeadsGoals,mktLeadsAssigneds,practitionerIdToName,month);
        }else if ("Y".equalsIgnoreCase(time)){
            //年
            infos = getYearPerformanceForecast(practitionerIds,mktLeadsGoals,mktLeadsAssigneds,practitionerIdToName);
        }

        responseVO.setSalesPerformanceForecastInfos(infos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @SuppressWarnings("unchecked")
    private List<SalesPerformanceForecastInfo> getYearPerformanceForecast(List<Long> practitionerIds, List<MktLeadsGoals> mktLeadsGoals, List<MktLeadsAssigneds> mktLeadsAssigneds, ConcurrentHashMap<Long, String> practitionerIdToName) {
        List<SalesPerformanceForecastInfo> infos = new ArrayList<>();
        for (Long praId : practitionerIds) {
            SalesPerformanceForecastInfo info = new SalesPerformanceForecastInfo();
            BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("practitionerId", praId);
            List<MktLeadsGoals> mktLeadsGoalsList = (List<MktLeadsGoals>) CollectionUtils.select(mktLeadsGoals, predicate);
            if (mktLeadsGoalsList.isEmpty()){
                info.setPractitionerId(praId);
                info.setName(practitionerIdToName.get(praId));
                infos.add(info);
                continue;
            }
            //总预测值
            BigDecimal quarterGoal = BigDecimal.ZERO;
            for (MktLeadsGoals leadsGoals : mktLeadsGoalsList) {
                if (leadsGoals.getStatisticTimeUnit() == 1) {
                    quarterGoal = quarterGoal.add(BigDecimal.valueOf(leadsGoals.getCommission()));
                }
            }

            //商机累加值
            predicate = new BeanPropertyValueEqualsPredicate("assignedPractitionerId", praId);
            List<MktLeadsAssigneds> mktLeadsAssignedsList = (List<MktLeadsAssigneds>)CollectionUtils.select(mktLeadsAssigneds,predicate);

            BigDecimal defaultCommission = BigDecimal.ZERO;
            BigDecimal defaultPremium = BigDecimal.ZERO;
            Integer defaultPieces = 0;
            for (MktLeadsAssigneds leadsAssigneds: mktLeadsAssignedsList) {
                String timeToClose = CommonUtil.dateParseString(leadsAssigneds.getTimeToClose(), "yyyy-MM-dd");
                if (CommonUtil.isNullOrBlank(timeToClose)){
                    continue;
                }
                if (CommonUtil.isThisYear(timeToClose)){
                    defaultPieces += leadsAssigneds.getPieces();
                    defaultCommission = defaultCommission.add(leadsAssigneds.getFyc());
                    defaultPremium = defaultPremium.add(leadsAssigneds.getFyp());
                }
            }
            Double achievementRate = defaultCommission.divide(quarterGoal,4,BigDecimal.ROUND_HALF_UP).doubleValue();
            info.setPractitionerId(praId);
            info.setName(practitionerIdToName.get(praId));
            info.setPieces(defaultPieces);
            info.setPremium(defaultPremium.doubleValue());
            info.setCommission(defaultCommission.doubleValue());
            info.setAchievementRate(achievementRate);
            infos.add(info);
        }
        return infos;
    }

    @SuppressWarnings("unchecked")
    private List<SalesPerformanceForecastInfo> getQuarterPerformanceForecast(List<Long> practitionerIds, List<MktLeadsGoals> mktLeadsGoals, List<MktLeadsAssigneds> mktLeadsAssigneds, ConcurrentHashMap<Long, String> practitionerIdToName, int month) {
        List<SalesPerformanceForecastInfo> infos = new ArrayList<>();
        for (Long praId : practitionerIds) {
            SalesPerformanceForecastInfo info = new SalesPerformanceForecastInfo();
            BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("practitionerId", praId);
            List<MktLeadsGoals> mktLeadsGoalsList = (List<MktLeadsGoals>) CollectionUtils.select(mktLeadsGoals, predicate);
            if (mktLeadsGoalsList.isEmpty()){
                info.setPractitionerId(praId);
                info.setName(practitionerIdToName.get(praId));
                infos.add(info);
                continue;
            }
            Integer[] quarter = new Integer[]{};
            if (month == 1 || month == 2 || month == 3) {
                quarter = new Integer[]{1, 2, 3};
            } else if (month == 4 || month == 5 || month == 6) {
                quarter = new Integer[]{4, 5, 6};
            } else if (month == 7 || month == 8 || month == 9) {
                quarter = new Integer[]{7, 8, 9};
            } else if (month == 10 || month == 11 || month == 12) {
                quarter = new Integer[]{10, 11, 12};
            }
            //总预测值
            BigDecimal quarterGoal = BigDecimal.ZERO;
            for (MktLeadsGoals leadsGoals : mktLeadsGoalsList) {
                if (leadsGoals.getStatisticTimeUnit() == 3) {
                    //月目标
                    //判断是否为本季度
                    Integer monthNum = leadsGoals.getSeqTime();
                    if (Arrays.asList(quarter).contains(monthNum)) {
                        quarterGoal = quarterGoal.add(BigDecimal.valueOf(leadsGoals.getCommission()));
                    }
                }
            }

            //商机累加值
            predicate = new BeanPropertyValueEqualsPredicate("assignedPractitionerId", praId);
            List<MktLeadsAssigneds> mktLeadsAssignedsList = (List<MktLeadsAssigneds>)CollectionUtils.select(mktLeadsAssigneds,predicate);

            BigDecimal defaultCommission = BigDecimal.ZERO;
            BigDecimal defaultPremium = BigDecimal.ZERO;
            Integer defaultPieces = 0;
            for (MktLeadsAssigneds leadsAssigneds: mktLeadsAssignedsList) {
                String timeToClose = CommonUtil.dateParseString(leadsAssigneds.getTimeToClose(), "yyyy-MM-dd");
                if (CommonUtil.isNullOrBlank(timeToClose)){
                    continue;
                }
                Calendar c = Calendar.getInstance();
                c.setTime(leadsAssigneds.getTimeToClose());
                int timeToCloseMonth = c.get(Calendar.MONTH);
                if (Arrays.asList(quarter).contains(timeToCloseMonth)){
                    defaultPieces += leadsAssigneds.getPieces();
                    defaultCommission = defaultCommission.add(leadsAssigneds.getFyc());
                    defaultPremium = defaultPremium.add(leadsAssigneds.getFyp());
                }
            }
            Double achievementRate = defaultCommission.divide(quarterGoal,4,BigDecimal.ROUND_HALF_UP).doubleValue();
            info.setPractitionerId(praId);
            info.setName(practitionerIdToName.get(praId));
            info.setPieces(defaultPieces);
            info.setPremium(defaultPremium.doubleValue());
            info.setCommission(defaultCommission.doubleValue());
            info.setAchievementRate(achievementRate);
            infos.add(info);
        }
        return infos;
    }

    @SuppressWarnings("unchecked")
    private List<SalesPerformanceForecastInfo> getMouthPerformanceForecast(List<Long> practitionerIds, List<MktLeadsGoals> mktLeadsGoals, List<MktLeadsAssigneds> mktLeadsAssigneds, ConcurrentHashMap<Long, String> practitionerIdToName, int month) {
        List<SalesPerformanceForecastInfo> infos = new ArrayList<>();
        for (Long praId : practitionerIds){
            SalesPerformanceForecastInfo info = new SalesPerformanceForecastInfo();
            BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("practitionerId", praId);
            List<MktLeadsGoals> mktLeadsGoalsList = (List<MktLeadsGoals>)CollectionUtils.select(mktLeadsGoals,predicate);
            predicate = new BeanPropertyValueEqualsPredicate("seqTime", month);
            mktLeadsGoalsList = (List<MktLeadsGoals>)CollectionUtils.select(mktLeadsGoalsList,predicate);
            if (mktLeadsGoalsList.isEmpty()){
                info.setPractitionerId(praId);
                info.setName(practitionerIdToName.get(praId));
                infos.add(info);
                continue;
            }
            MktLeadsGoals leadsGoals = mktLeadsGoalsList.get(0);
            //筛选此经纪人的所有指派信息
            predicate = new BeanPropertyValueEqualsPredicate("assignedPractitionerId", praId);
            List<MktLeadsAssigneds> mktLeadsAssignedsList = (List<MktLeadsAssigneds>)CollectionUtils.select(mktLeadsAssigneds,predicate);

            BigDecimal defaultCommission = BigDecimal.ZERO;
            BigDecimal defaultPremium = BigDecimal.ZERO;
            Integer defaultPieces = 0;
            for (MktLeadsAssigneds leadsAssigneds : mktLeadsAssignedsList){
                String timeToClose = CommonUtil.dateParseString(leadsAssigneds.getTimeToClose(), "yyyy-MM-dd");
                if (CommonUtil.isNullOrBlank(timeToClose)){
                    continue;
                }
                if (CommonUtil.isThisMonth(timeToClose)){
                    defaultPieces += leadsAssigneds.getPieces();
                    defaultCommission = defaultCommission.add(leadsAssigneds.getFyc());
                    defaultPremium = defaultPremium.add(leadsAssigneds.getFyp());
                }
            }
            Double achievementRate = defaultCommission.divide(BigDecimal.valueOf(leadsGoals.getCommission()),4,BigDecimal.ROUND_HALF_UP).doubleValue();
            info.setPractitionerId(praId);
            info.setName(practitionerIdToName.get(praId));
            info.setPieces(defaultPieces);
            info.setPremium(defaultPremium.doubleValue());
            info.setCommission(defaultCommission.doubleValue());
            info.setAchievementRate(achievementRate);
            infos.add(info);
        }
        return infos;
    }


    private ConcurrentHashMap<String, Double> getAchievementRate(List<MktLeadsGoals> leadsGoals,HashMap<String,BigDecimal> performanceForecast) {
        ConcurrentHashMap<String, Double> achievementRateMap = new ConcurrentHashMap<>();
        //获取当前月份
        Calendar cal = Calendar.getInstance();
        int month = cal.get(Calendar.MONTH)+1;
        //查询这个月所在季度是那几个月
        Integer[] quarter =  new Integer[]{};
        if (month == 1 || month == 2 || month == 3){
            quarter = new Integer[]{1, 2, 3};
        }else if (month == 4 || month == 5 || month == 6){
            quarter = new Integer[]{4, 5, 6};
        }else if (month == 7 || month == 8 || month == 9){
            quarter = new Integer[]{7, 8, 9};
        }else if (month == 10 || month == 11 || month == 12){
            quarter = new Integer[]{10, 11, 12};
        }

        Double yearGoal = 0D;
        Double quarterGoal = 0D;
        Double monthGoal = 0D;
        for (MktLeadsGoals info : leadsGoals){
            if (info.getStatisticTimeUnit()==1){
                //年目标
                yearGoal = info.getCommission();
            }else if (info.getStatisticTimeUnit() == 3){
                //月目标
                //判断是否为本季度
                Integer monthNum = info.getSeqTime();
                if (Arrays.asList(quarter).contains(monthNum)){
                    quarterGoal += info.getCommission();
                    if (month == info.getSeqTime()){
                        monthGoal = info.getCommission();
                    }
                }
            }
        }

        //年完成率
        Double achievementRateYear = performanceForecast.get("totalFYCYear")
                .divide(BigDecimal.valueOf(yearGoal),4,BigDecimal.ROUND_HALF_UP)
                .doubleValue();
        achievementRateMap.put("achievementRateYear",achievementRateYear);
        //季完成率
        Double achievementRateQuarter = performanceForecast.get("totalFYCQuarter")
                .divide(BigDecimal.valueOf(quarterGoal),4,BigDecimal.ROUND_HALF_UP)
                .doubleValue();
        achievementRateMap.put("achievementRateQuarter",achievementRateQuarter);
        //月完成率
        Double achievementRateMonth = performanceForecast.get("totalFYCMonth")
                .divide(BigDecimal.valueOf(monthGoal),4,BigDecimal.ROUND_HALF_UP)
                .doubleValue();
        achievementRateMap.put("achievementRateMonth",achievementRateMonth);
        return achievementRateMap;
    }

    private List<MktLeadsGoals> getYearTeamGoals(Long practitionerId) {
        //查询团队长设置的月/季/年  FYC目标  ag_mkt_leads_goals
        MktLeadsGoals mktLeadsGoals = new MktLeadsGoals();
        mktLeadsGoals.setIsActive(1);//是否启用
        mktLeadsGoals.setPractitionerId(practitionerId);//团队长经纪人id
        mktLeadsGoals.setGoalsType(2);//目标类型：1：经纪人指标，2:团队指标
        //当前年份
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        mktLeadsGoals.setCurrentYear(year);
        List<AclPractitionerSubordinateSystem> subordinateSystems = aclPractitionerSubordinateSystemDALService.findByOwnerPractitionerId(practitionerId);
        if (!subordinateSystems.isEmpty()){
            AclPractitionerSubordinateSystem subordinateSystem = subordinateSystems.get(0);
            mktLeadsGoals.setSubordinateSystemId(subordinateSystem.getId());
        }
        return mktLeadsGoalsDALService.findByMktLeadsGoals(mktLeadsGoals);
    }

    /**
     * 通过总分计算平均分  保留两位小数
     * @param total 总分
     * @param practitionerNum 人数
     * @return 均分
     */
    private Double getScoreAverage(BigDecimal total, BigDecimal practitionerNum) {
        double scoreAverage = 0D;
        if (!CommonUtil.isNullOrZero(total)){
            scoreAverage = total
                    .divide(practitionerNum,2,BigDecimal.ROUND_HALF_UP)
                    .doubleValue();
        }
        return scoreAverage;
    }

    private void initializationAction(Long practitionerId, int year,Integer goalsType) {
        //通过经纪人id 和 目标所属年度 去查询ag_mkt_leads_goals/ag_mkt_leads_goals_actions  并将is_active = 0
        mktLeadsGoalsDALService.updateIsActiveIsNull(practitionerId,year,goalsType);
        mktLeadsGoalsActionsDALService.updateIsActiveIsNull(practitionerId,year,goalsType);
    }

    private SalesTargetActions saveLeadsGoalsActions(MdGoalsCalculateExpression info, ScriptEngine jScriptEngine, int year, int piecesMonth, Long practitionerId , Date date,Integer goalsType) {
        Long dropOptionId = info.getActionId();
        String dropOptionName = info.getDropOptionName();
        String calculateScriptExpression = info.getCalculateScriptExpression();
//            System.out.println("calculateScriptExpression:"+calculateScriptExpression);
        Integer actionStandards = null;
        String replaceAll = calculateScriptExpression.replaceAll("num", String.valueOf(piecesMonth));
        System.out.println(replaceAll);
        try {
            actionStandards = (Integer) jScriptEngine.eval(replaceAll);
        } catch (ScriptException e) {
            e.printStackTrace();
        }
        //保存信息至ag_mkt_leads_goals_actions
        MktLeadsGoalsActions mktLeadsGoalsActions = new MktLeadsGoalsActions();
        mktLeadsGoalsActions.setPractitionerId(practitionerId);
        mktLeadsGoalsActions.setCurrentYear(year);
        mktLeadsGoalsActions.setStatisticTimeUnit(3);
        mktLeadsGoalsActions.setGoalsType(goalsType);
        mktLeadsGoalsActions.setLeadsActionId(dropOptionId);
        mktLeadsGoalsActions.setLeadsActionName(dropOptionName);
        mktLeadsGoalsActions.setActionStandards(actionStandards);
        mktLeadsGoalsActions.setCurrentVersion(date);
        mktLeadsGoalsActions.setIsActive(1);
        mktLeadsGoalsActions.setCreatedAt(new Date());
        mktLeadsGoalsActions.setCreatedBy(practitionerId);
        mktLeadsGoalsActions.setUpdatedAt(new Date());
        mktLeadsGoalsActions.setUpdatedBy(practitionerId);
        mktLeadsGoalsActionsDALService.save(mktLeadsGoalsActions);
        SalesTargetActions salesTargetAction = new SalesTargetActions();
        salesTargetAction.setStatisticTimeUnit(3);
        salesTargetAction.setActionStandards(actionStandards);
        salesTargetAction.setLeadsActionId(dropOptionId);
        salesTargetAction.setLeadsActionName(dropOptionName);
        return salesTargetAction;
    }

    /**
     * 保存月度商机目标
     * @param info 入参
     * @param practitionerId 经纪人id
     * @param date 版本号
     * @param year 当前年份
     */
    private void saveMonthGoal(SalesTargetMonth info, Long practitionerId, Date date,int year,Integer goalsType,AclPractitionerSubordinateSystem subordinate) {
        MktLeadsGoals mktLeadsGoals = new MktLeadsGoals();
        mktLeadsGoals.setPractitionerId(practitionerId);
        mktLeadsGoals.setPremium(info.getPremium());
        mktLeadsGoals.setCommission(info.getCommission());
        mktLeadsGoals.setGoalsType(goalsType);
        mktLeadsGoals.setSubordinateSystemId(subordinate.getId());
        mktLeadsGoals.setSubordinateSystemName(subordinate.getName());
        mktLeadsGoals.setPieces(info.getPieces());
        mktLeadsGoals.setPieceAveragePremium(info.getPieceAveragePremium());
        mktLeadsGoals.setCurrentYear(year);
        mktLeadsGoals.setStatisticTimeUnit(3);
        mktLeadsGoals.setSeqTime(info.getMonthNum());
        mktLeadsGoals.setCurrentVersion(date);
        mktLeadsGoals.setCreatedAt(new Date());
        mktLeadsGoals.setCreatedBy(practitionerId);
        mktLeadsGoals.setUpdatedAt(new Date());
        mktLeadsGoals.setUpdatedBy(practitionerId);
        mktLeadsGoals.setIsActive(1);
        mktLeadsGoalsDALService.saveMktLeadsGoals(mktLeadsGoals);
    }

    /**
     * 保存商机年目标
     * @param requestVO 入参
     * @param practitionerId 经纪人id
     * @param date 版本号
     * @param year 当前年份
     */
    private void saveYearGoal(SalesTargetSaveRequestVO requestVO,Long practitionerId,Date date,int year,Integer goalsType,AclPractitionerSubordinateSystem subordinate) {
        Double premium = requestVO.getPremium();
        Double commission = requestVO.getCommission();
        Integer pieces = requestVO.getPieces();
        Double pieceAveragePremium = requestVO.getPieceAveragePremium();
        MktLeadsGoals mktLeadsGoals = new MktLeadsGoals();
        mktLeadsGoals.setPractitionerId(practitionerId);
        mktLeadsGoals.setGoalsType(goalsType);
        mktLeadsGoals.setSubordinateSystemId(subordinate.getId());
        mktLeadsGoals.setSubordinateSystemName(subordinate.getName());
        mktLeadsGoals.setPremium(premium);
        mktLeadsGoals.setCommission(commission);
        mktLeadsGoals.setPieces(pieces);
        mktLeadsGoals.setPieceAveragePremium(pieceAveragePremium);
        mktLeadsGoals.setCurrentYear(year);
        mktLeadsGoals.setSeqTime(year);
        mktLeadsGoals.setStatisticTimeUnit(1);
        mktLeadsGoals.setCurrentVersion(date);
        mktLeadsGoals.setCreatedAt(new Date());
        mktLeadsGoals.setCreatedBy(practitionerId);
        mktLeadsGoals.setUpdatedAt(new Date());
        mktLeadsGoals.setUpdatedBy(practitionerId);
        mktLeadsGoals.setIsActive(1);
        mktLeadsGoalsDALService.saveMktLeadsGoals(mktLeadsGoals);
    }

    private CommonResult check(OwnOpportunityRecordSaveRequestVO requestVO) {
        String noticeDate = requestVO.getNoticeDate();
        if (CommonUtil.isNullOrBlank(noticeDate)){
            return new CommonResult(false, ZHBErrorConfig.getErrorInfo("830012"));
        }
        String salesNotice = requestVO.getSalesNotice();
        if (CommonUtil.isNullOrBlank(salesNotice)){
            return new CommonResult(false, ZHBErrorConfig.getErrorInfo("830013"));
        }
        //判断此经纪人当天是否已为此商机经行了此项跟进
        if (CommonUtil.isNullOrZero(requestVO.getId())){
            MktLeadsAssignedTrack mktLeadsAssignedTrack = new MktLeadsAssignedTrack();
            mktLeadsAssignedTrack.setPractitionerId(requestVO.getPractitionerId());
            mktLeadsAssignedTrack.setCustomerId(requestVO.getOpportunityId());
            mktLeadsAssignedTrack.setLeadsAssignedId(requestVO.getLeadsAssignedId());
            mktLeadsAssignedTrack.setMdDropOptionId(requestVO.getMdDropOptionId());
            List<MktLeadsAssignedTrack> trackList = mktLeadsAssignedTrackDALService.findByTrackTimeForNew(mktLeadsAssignedTrack);
            if (!trackList.isEmpty()){
                return new CommonResult(false, ZHBErrorConfig.getErrorInfo("830015"));
            }
        }
        return new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000"));
    }

    private CommonResult paramCheck(SettingSaveRequestVO requestVO) {
        //检查入参判断
        Long practitionerId = requestVO.getPractitionerId();
        if (CommonUtil.isNullOrZero(practitionerId)){
            String[] params = {"practitionerId"};
            return new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001",params));
        }
        //生活照至多三张
        List<String> lifeImgUrls = requestVO.getLifeImgUrls();
        if (lifeImgUrls != null){
            if (!lifeImgUrls.isEmpty()){
                AclFileUpload aclFileUpload = new AclFileUpload();
                aclFileUpload.setTargetType(1);
                aclFileUpload.setTargetId(practitionerId);
                aclFileUpload.setTargetUseFor(2);
                aclFileUpload.setIsActive(1);
                List<AclFileUpload> fileUploads = aclFileUploadDALService.findByAclFileUpload(aclFileUpload);
                if (!fileUploads.isEmpty()){
                    int size = lifeImgUrls.size()+fileUploads.size();
                    if (size>=4){
                        return new CommonResult(false, ZHBErrorConfig.getErrorInfo("830006"));
                    }
                }
            }
        }
        return new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000"));
    }

    private void practitionerMySettingSave(SettingSaveRequestVO requestVO) {
        //修改个人设置，个人介绍
        String settingSave = requestVO.getSettingSave();
        if (settingSave.equalsIgnoreCase("isShow")||settingSave.equalsIgnoreCase("intro")){
            Long practitionerId = requestVO.getPractitionerId();
            AclPractitioner practitioner = aclPractitionerDALService.findPractitionerById(practitionerId);
            if (settingSave.equalsIgnoreCase("intro")){
                practitioner.setBioIntro(requestVO.getBioIntro());
            }else if (settingSave.equalsIgnoreCase("isShow")){
                practitioner.setIsNameShow(requestVO.getIsNameShow());
                practitioner.setIsMobileShow(requestVO.getIsMobileShow());
            }
            aclPractitionerDALService.updatePractitioner(practitioner);
        }
    }

    private String practitionerHeadImgSave(SettingSaveRequestVO requestVO) throws Exception {
        String headImgUrl = requestVO.getHeadImgUrl();
        if (CommonUtil.isNullOrBlank(headImgUrl)){
            //如果头像没有地址，则认为没有上传
            return null;
        }
        //上传图片
        return uploadImage(headImgUrl,requestVO.getPractitionerId(),1);
    }

    private String practitionerLifeImgSave(SettingSaveRequestVO requestVO) throws Exception {
        List<String> lifeImgUrls = requestVO.getLifeImgUrls();
        StringBuilder message = new StringBuilder(" ");
        int i = 1;
        for (String lifeImgUrl: lifeImgUrls){
            String resp = uploadImage(lifeImgUrl, requestVO.getPractitionerId(), 2);
            if (!CommonUtil.isNullOrBlank(resp)){
                message.append(i).append(",");
            }
            i++;
        }
        if (!CommonUtil.isNullOrBlank(message.toString())){
            return "此次上传第"+message+"张图片尺寸不符合要求!!";
        }
        return null;
    }

    private String practitionerWXQRImgSave(SettingSaveRequestVO requestVO) throws Exception{
        String wxQRImgUrl = requestVO.getWxQRImgUrl();
        if (CommonUtil.isNullOrBlank(wxQRImgUrl)){
            //如果头像没有地址，则认为没有上传
            return null;
        }
        //上传图片
        return uploadImage(wxQRImgUrl,requestVO.getPractitionerId(),9);
    }

    private String uploadImage(String headImgUrl, Long practitionerId,Integer targetUseFor) throws Exception{
        Map<String, Object> input = HttpUtil.getInput(headImgUrl);
        if (!(boolean)input.get("success")){
            if (targetUseFor==1){
                //地址转流失败
                return ZHBErrorConfig.getErrorInfo("830007");
            }else if(targetUseFor==2){
                return ZHBErrorConfig.getErrorInfo("830008");
            }else if(targetUseFor==9){
                return ZHBErrorConfig.getErrorInfo("830009");
            }
        }
        //获取头像流
        InputStream inputStream = (InputStream) input.get("is");
        //判断图像尺寸
        BufferedImage img = ImageIO.read(inputStream);
        if (img == null || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
            return ZHBErrorConfig.getErrorInfo("830003");
        }
//        else {
//            double width = img.getWidth(null);
//            double height = img.getHeight(null);
//            double value =height/width;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write(img, "jpg", os);
            inputStream = new ByteArrayInputStream(os.toByteArray());
//            if (value !=1&&(targetUseFor == 1 || targetUseFor == 9)){
//                //上传头像尺寸比例为1:1
//                return ZHBErrorConfig.getErrorInfo("830005");
//            }else if(value !=0.75 && targetUseFor == 2){
//                return ZHBErrorConfig.getErrorInfo("830004");
//            }
//        }
        //上传图片至阿里云
        String prefix = "broker/"+practitionerId+"/";
        String originalFilename = generateKey(targetUseFor);
        String key = prefix + originalFilename;
        String putFileToOss = ossService.putFileToOss(null,key,inputStream);
        //将之前头像设置为不启用
        if (targetUseFor==1||targetUseFor==9){
            updateImgOld(practitionerId,targetUseFor);
        }
        //保存到数据库
        AclPractitioner practitioner = aclPractitionerDALService.findPractitionerById(practitionerId);
        AclFileUpload aclFileUpload = new AclFileUpload();
        aclFileUpload.setTargetType(1);
        aclFileUpload.setTargetId(practitioner.getId());
        String practitionerCode = practitioner.getPractitionerCode();
        aclFileUpload.setTargetNo(practitionerCode);
        aclFileUpload.setFileType("jpg");
        aclFileUpload.setFileName(originalFilename);
        aclFileUpload.setFilePath(putFileToOss);
        aclFileUpload.setTargetUseFor(targetUseFor);
        aclFileUpload.setFileSize(String.valueOf(inputStream.available()));
        aclFileUpload.setOssKey(key);
        aclFileUpload.setIsActive(1);
        aclFileUpload.setUploadedAt(new Date());
        aclFileUpload.setUploadedBy(-1L);
        aclFileUpload.setTargetSeq(getTargetSeq(practitioner.getId(),targetUseFor));
        aclFileUploadDALService.saveFileUpload(aclFileUpload);
        return null;
    }
    private String generateKey(int targetUseFor) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        return targetUseFor+sdf.format(new Date()) + CommonUtil.getRandomNum(3)+".jpg";
    }

    private void updateImgOld(Long practitionerId, int targetUseFor) {
        AclFileUpload aclFileUpload = new AclFileUpload();
        aclFileUpload.setTargetId(practitionerId);
        aclFileUpload.setTargetType(1);
        aclFileUpload.setIsActive(1);
        aclFileUpload.setTargetUseFor(targetUseFor);
        List<AclFileUpload> uploads = aclFileUploadDALService.findByAclFileUpload(aclFileUpload);
        if (!uploads.isEmpty()){
            for (AclFileUpload fileUpload :uploads){
                fileUpload.setIsActive(0);
                aclFileUploadDALService.updateFileUpload(fileUpload);
            }
        }
    }

    private Integer getTargetSeq(Long practitionerId, Integer targetUseFor) {
        AclFileUpload aclFileUpload = new AclFileUpload();
        aclFileUpload.setTargetType(1);
        aclFileUpload.setTargetId(practitionerId);
        aclFileUpload.setTargetUseFor(targetUseFor);
        List<AclFileUpload> aclFileUploadList = aclFileUploadDALService.findByAclFileUpload(aclFileUpload);
        return aclFileUploadList.size()+1;
    }
}
