package com.yd.api.agms.service.impl;
import com.google.common.collect.Lists;

import com.itextpdf.tool.xml.html.head.Title;
import com.yd.api.agms.service.AgmsSharingService;
import com.yd.api.agms.vo.sharing.ControllerResponseVO;
import com.yd.rmi.ali.oss.service.OssService;
import com.yd.rmi.ali.oss.vo.OssOperateTypeEnum;
import com.yd.rmi.ali.oss.vo.OssRequestVO;
import com.yd.rmi.ali.oss.vo.OssResponseVO;
import com.yd.rmi.cache.SystemConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

/**
 * @author xxy
 */
@Service("agmsSharingService")
public class AgmsSharingServiceImpl implements AgmsSharingService {

    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private OssService ossService;

    @Override
    public ControllerResponseVO controller(String action, MultipartFile upfile) {
        ControllerResponseVO responseVO = new ControllerResponseVO();
        String aliOssBucketName = systemConfigService.getSingleConfigValue("ALI_OSS_BUCKET_NAME");
        String[] imageAllowFiles = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp"};
        String[] videoAllowFiles = new String[]{".flv", ".swf", ".mkv", ".avi", ".rm", ".rmvb", ".mpeg", ".mpg",
                ".ogg", ".ogv", ".mov", ".wmv", ".mp4", ".webm", ".mp3", ".wav", ".mid"};
        String[] fileAllowFiles = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp",
                ".flv", ".swf", ".mkv", ".avi", ".rm", ".rmvb", ".mpeg", ".mpg",
                ".ogg", ".ogv", ".mov", ".wmv", ".mp4", ".webm", ".mp3", ".wav", ".mid",
                ".rar", ".zip", ".tar", ".gz", ".7z", ".bz2", ".cab", ".iso",
                ".doc", ".docx", ".xls", ".xlsx", ".ppt", ".pptx", ".pdf", ".txt", ".md", ".xml"};
        if ("uploadimage".equals(action)) {
            responseVO.setImageActionName("uploadimage");
            responseVO.setImageFieldName("upfile");
            responseVO.setImageMaxSize(2048000);
            responseVO.setImageAllowFiles(Arrays.asList(imageAllowFiles.clone()));
            responseVO.setImageCompressEnable(true);
            responseVO.setImageCompressBorder(1600);
            responseVO.setImageInsertAlign("none");
            responseVO.setImageUrlPrefix(aliOssBucketName);
            responseVO.setImagePathFormat("/sharing/image/{time}{rand:6}");
            responseVO.setScrawlActionName("uploadscrawl");
            responseVO.setScrawlFieldName("upfile");
            responseVO.setScrawlPathFormat("/sharing/image/{time}{rand:6}");
            responseVO.setScrawlMaxSize(2048000);
            responseVO.setScrawlUrlPrefix(aliOssBucketName);
            responseVO.setScrawlInsertAlign("none");
            responseVO.setSnapscreenActionName("uploadimage");
            responseVO.setSnapscreenPathFormat("/sharing/image/{time}{rand:6}");
            responseVO.setSnapscreenUrlPrefix(aliOssBucketName);
            responseVO.setSnapscreenInsertAlign("none");
            String[] catcherLocalDomain = new String[]{"127.0.0.1", "localhost", "img.baidu.com"};
            responseVO.setCatcherLocalDomain(Arrays.asList(catcherLocalDomain));
            responseVO.setCatcherActionName("catchimage");
            responseVO.setCatcherFieldName("source");
            responseVO.setCatcherPathFormat("/sharing/image/{time}{rand:6}");
            responseVO.setCatcherUrlPrefix(aliOssBucketName);
            responseVO.setCatcherMaxSize(2048000);
            responseVO.setCatcherAllowFiles(Arrays.asList(imageAllowFiles));
            responseVO.setVideoActionName("uploadvideo");
            responseVO.setVideoFieldName("upfile");
            responseVO.setVideoPathFormat("/sharing/video/{time}{rand:6}");
            responseVO.setVideoUrlPrefix(aliOssBucketName);
            responseVO.setVideoMaxSize(102400000);
            responseVO.setVideoAllowFiles(Arrays.asList(videoAllowFiles));
            responseVO.setFileActionName("uploadfile");
            responseVO.setFileFieldName("upfile");
            responseVO.setFilePathFormat("/sharing/file/{time}{rand:6}");
            responseVO.setFileUrlPrefix(aliOssBucketName);
            responseVO.setFileMaxSize(51200000);
            responseVO.setFileAllowFiles(Arrays.asList(fileAllowFiles));
            responseVO.setImageManagerActionName("listimage");
            responseVO.setImageManagerListPath("/sharing/image/");
            responseVO.setImageManagerListSize(20);
            responseVO.setImageManagerUrlPrefix(aliOssBucketName);
            responseVO.setImageManagerInsertAlign("none");
            String[] imageManagerAllowFiles = new String[]{".png", ".jpg", ".jpeg", ".gif", ".bmp"};
            responseVO.setImageManagerAllowFiles(Arrays.asList(imageManagerAllowFiles));
            responseVO.setFileManagerActionName("listfile");
            responseVO.setFileManagerListPath("/sharing/file/");
            responseVO.setFileManagerUrlPrefix(aliOssBucketName);
            responseVO.setFileManagerListSize(20);
            responseVO.setFileManagerAllowFiles(Arrays.asList(fileAllowFiles));
        } else if ("config".equals(action)){
            try {
                String type = upfile.getOriginalFilename().substring(upfile.getOriginalFilename().indexOf(".") + 1);
                byte[] bytes = upfile.getBytes();
                InputStream in = new ByteArrayInputStream(bytes);
                StringBuilder key = new StringBuilder("/sharing/");
                String title;
                Date date = new Date();
                SimpleDateFormat sd = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                String nowTime = sd.format(date);
                if (Arrays.asList(imageAllowFiles).contains(type)){
                    title = nowTime + (int)(Math.random()*1000000);
                    key.append("image/").append(title);
                }else if (Arrays.asList(videoAllowFiles).contains(type)){
                    title = nowTime + (int)(Math.random()*1000000);
                    key.append("video/").append(title);
                }else {
                    title = nowTime + (int)(Math.random()*1000000);
                    key.append("file/").append(title);
                }
                String putFileToOss = ossService.putFileToOss(null, key.toString(), in);
                responseVO.setState("SUCCESS");
                responseVO.setUrl(putFileToOss);
                responseVO.setTitle(title);
                responseVO.setOriginal(upfile.getOriginalFilename());
                responseVO.setType(type);
                responseVO.setSize(upfile.getSize());
            }catch (Exception e){
                e.printStackTrace();
            }
        }
        return responseVO;
    }
}
