package com.yd.api.agms;

import com.yd.api.agms.service.AgmsDashboardService;
import com.yd.api.agms.service.AgmsFortuneService;
import com.yd.api.agms.service.AgmsHiringService;
import com.yd.api.agms.vo.dashboard.*;
import com.yd.api.agms.service.AgmsStatisticsService;
import com.yd.api.agms.vo.fortune.*;
import com.yd.api.agms.vo.hiring.*;
import com.yd.api.agms.vo.statistics.FinancialStatisticsRequestVO;
import com.yd.api.agms.vo.statistics.FinancialStatisticsResponseVO;
import com.yd.api.agms.vo.statistics.LeadsStatisticsRequestVO;
import com.yd.api.agms.vo.statistics.LeadsStatisticsResponseVO;
import com.yd.api.practitioner.vo.hiring.HiringApproveRequestVO;
import com.yd.api.practitioner.vo.hiring.HiringApproveResponseVO;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

@Controller
@RestController
@RequestMapping("/agms")
public class AgmsController {
    @Autowired
    private AgmsDashboardService agmsDashboardService;
    @Autowired
    private AgmsStatisticsService agmsStatisticsService;
    @Autowired
    private AgmsFortuneService agmsFortuneService;
    @Autowired
    private AgmsHiringService agmsHiringService;

    /**
     * AGMS -- 财务管理报表
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/financialPredictStatistics")
    public Object financialPredictStatistics(@RequestBody FinancialStatisticsRequestVO requestVO, HttpServletResponse response){
        JsonResult result = new JsonResult();
        FinancialStatisticsResponseVO responseVO = agmsStatisticsService.financialPredictStatistics(requestVO,response);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  PEP活动管理
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsPEP")
    public Object statisticsPEP(@RequestBody StatisticsPEPRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsPEPResponseVO responseVO = agmsDashboardService.statisticsPEP(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  商机预测
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsOpportunity")
    public Object statisticsOpportunity(@RequestBody StatisticsOpportunityRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsOpportunityResponseVO responseVO = agmsDashboardService.statisticsOpportunity(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  预测统计查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsForecastTotal")
    public Object statisticsForecastTotal(@RequestBody StatisticsForecastTotalRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsForecastTotalResponseVO responseVO = agmsDashboardService.statisticsForecastTotal(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  销售统计查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsSales")
    public Object statisticsSales(@RequestBody StatisticsSalesRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsSalesResponseVO responseVO = agmsDashboardService.statisticsSales(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- Dashboard查询  经纪人统计查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/statisticsPractitioner")
    public Object statisticsPractitioner(@RequestBody StatisticsPractitionerRequestVO requestVO){
        JsonResult result = new JsonResult();
        StatisticsPractitionerResponseVO responseVO = agmsDashboardService.statisticsPractitioner(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- 商机统计报表
     * @param requestVO requestVO
     * @return 响应数据
     */
    @RequestMapping(value="/leadsStatistics")
    public Object leadsStatistics(@RequestBody LeadsStatisticsRequestVO requestVO,HttpServletResponse response) {
        JsonResult result = new JsonResult();
        LeadsStatisticsResponseVO responseVO = agmsStatisticsService.leadsStatistics(requestVO,response);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 修改佣金发放状态
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/commissionPayoutStatusUpdate")
    public Object commissionPayoutStatusUpdate(@RequestBody CommissionPayoutStatusUpdateRequestVO requestVO) {
        JsonResult result = new JsonResult();
        CommissionPayoutStatusUpdateResponseVO responseVO = agmsFortuneService.commissionPayoutStatusUpdate(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 修改佣金发放状态列表
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/commissionPayoutStatusQuery")
    public Object commissionPayoutStatusQuery(@RequestBody CommissionPayoutStatusQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        CommissionPayoutStatusQueryResponseVO responseVO = agmsFortuneService.commissionPayoutStatusQuery(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 支付列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/withdrawQuery")
    public Object withdrawQuery(@RequestBody WithdrawQueryRequestVO requestVO){
        JsonResult result = new JsonResult();
        WithdrawQueryResponseVO withdrawQueryResponseVO  = agmsFortuneService.withdrawQuery(requestVO);
        result.addResult(withdrawQueryResponseVO);
        result.setData(withdrawQueryResponseVO);
        return result;
    }

    /**
     * AGMS -- 提现财富对应订单查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/fortunePayToOrder")
    public Object fortunePayToOrder(@RequestBody FortunePayToOrderRequestVO requestVO) {
        JsonResult result = new JsonResult();
        FortunePayToOrderResponseVO responseVO = agmsFortuneService.fortunePayToOrder(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 财富批量支付
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/fortunePay")
    public Object fortunePay(@RequestBody FortunePayRequestVO requestVO) {
        JsonResult result = new JsonResult();
        FortunePayResponseVO responseVO = agmsFortuneService.fortunePay(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 导出财富文档
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/exportFortunePay")
    public Object exportFortunePay(@RequestBody ExportFortunePayRequestVO requestVO, HttpServletResponse response) {
        JsonResult result = new JsonResult();
        ExportFortunePayResponseVO responseVO = agmsFortuneService.exportFortunePay(requestVO,response);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 查询预计发佣日期
     * @return 响应数据
     */
    @RequestMapping(value="/fortunePayoutBatchQuery",method = RequestMethod.GET)
    public Object fortunePayoutBatchQuery() {
        JsonResult result = new JsonResult();
        FortunePayoutBatchQueryResponseVO responseVO = agmsFortuneService.fortunePayoutBatchQuery();
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 经纪人审批详情查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/practitionerHiringDetail")
    public Object practitionerHiringDetail(@RequestBody PractitionerHiringDetailRequestVO requestVO) {
        JsonResult result = new JsonResult();
        PractitionerHiringDetailResponseVO responseVO = agmsHiringService.practitionerHiringDetail(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 经纪人审批列表查询
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/practitionerHiringListOld")
    public Object practitionerHiringListOld(@RequestBody PractitionerHiringListRequestVO requestVO) {
        JsonResult result = new JsonResult();
        PractitionerHiringListResponseVO responseVO = agmsHiringService.practitionerHiringList(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }

    /**
     * AGMS -- 经纪人审批
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/practitionerHiringApprove")
    public Object practitionerHiringApprove(@RequestBody PractitionerHiringApproveRequestVO requestVO){
        JsonResult result = new JsonResult();
        PractitionerHiringApproveResponseVO responseVO = agmsHiringService.practitionerHiringApprove(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- 经纪人审批列表查询第二版
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping(value="/practitionerHiringList")
    public Object practitionerHiringList(@RequestBody PractitionerHiringListRequestVO requestVO) {
        JsonResult result = new JsonResult();
        PractitionerHiringListResponseVO responseVO = agmsHiringService.practitionerHiringListV2(requestVO);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
}
