package com.yd.api.practitioner;

import com.yd.api.practitioner.service.PractitionerArticleService;
import com.yd.api.practitioner.vo.ArticleTrackSaveResponseVO;
import com.yd.api.practitioner.vo.article.ArticleShareCodeSaveRequestVO;
import com.yd.api.practitioner.vo.article.ArticleShareCodeSaveResponseVO;
import com.yd.api.practitioner.vo.article.ArticleTrackSaveRequestVO;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@RestController
@RequestMapping("/practitionerArticle")
public class PractitionerArticleController {
    @Autowired
    private PractitionerArticleService practitionerArticleService;

    @RequestMapping("/articleShareCodeSave")
    public Object articleShareCodeSave(@RequestBody ArticleShareCodeSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        ArticleShareCodeSaveResponseVO responseVO = practitionerArticleService.articleShareCodeSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    @RequestMapping("/articleTrackSave")
    public Object articleTrackSave(@RequestBody ArticleTrackSaveRequestVO requestVO){
        JsonResult result = new JsonResult();
        ArticleTrackSaveResponseVO responseVO = practitionerArticleService.articleTrackSave(requestVO);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }
}
