package com.yd.api.practitioner.service.impl;

import com.github.pagehelper.PageHelper;
import com.yd.api.customer.service.CustomerService;
import com.yd.api.customer.vo.register.RegisterRequestVO;
import com.yd.api.customer.vo.register.RegisterResponseVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginBasicInfo;
import com.yd.api.practitioner.vo.login.PractitionerLoginRequestVO;
import com.yd.api.practitioner.vo.login.PractitionerLoginResponseVO;
import com.yd.api.practitioner.vo.media.MediaGetReqVO;
import com.yd.api.practitioner.vo.media.MediaGetRespVO;
import com.yd.api.practitioner.vo.opportunity.*;
import com.yd.api.practitioner.vo.rank.AclCustomerFortuneStatistics;
import com.yd.api.practitioner.vo.rank.PractitionerRankRequestVO;
import com.yd.api.practitioner.vo.rank.PractitionerRankResponseVO;
import com.yd.api.practitioner.vo.rank.PractitionerInfoForAchievement;
import com.yd.api.practitioner.vo.recruit.*;
import com.yd.api.practitioner.vo.setting.*;
import com.yd.api.result.CommonResult;
import com.yd.dal.entity.customer.*;
import com.yd.dal.entity.marketing.MktLeadsAssignedTrack;
import com.yd.dal.entity.marketing.MktLeadsAssigneds;
import com.yd.dal.entity.marketing.MktLeadsPool;
import com.yd.dal.entity.meta.MdDropOptions;
import com.yd.dal.entity.meta.MdMkCampaign;
import com.yd.dal.entity.meta.MdTag;
import com.yd.dal.entity.meta.ObjectCollectionTagged;
import com.yd.dal.entity.practitioner.opportunity.OwnOpportunityInfo;
import com.yd.dal.entity.order.PoOrder;
import com.yd.dal.entity.survey.SurveyCustomerAnswers;
import com.yd.dal.service.customer.*;
import com.yd.dal.service.marketing.MktLeadsAssignedTrackDALService;
import com.yd.dal.service.marketing.MktLeadsAssignedsDALService;
import com.yd.dal.service.meta.*;
import com.yd.dal.service.order.PoOrderDALService;
import com.yd.dal.service.survey.SurveyCustomerAnswersDALService;
import com.yd.dal.entity.customer.practitioner.*;
import com.yd.rmi.ali.oss.service.OssService;
import com.yd.rmi.tencent.wechat.service.WechatService;
import com.yd.rmi.tencent.wechat.vo.WeChatInfoByENV;
import com.yd.rmi.tencent.wechatinterf.pojo.ticket.TicketRequest;
import com.yd.rmi.tencent.wechatinterf.pojo.token.TokenRequest;
import com.yd.util.CommonUtil;
import com.yd.util.EncryptUtil;
import com.yd.util.HttpUtil;
import com.yd.util.config.ZHBErrorConfig;
import com.yd.util.deshandler.DESTypeHandler;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.google.common.base.Strings;
import org.springframework.transaction.annotation.Transactional;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;

@Service("practitionerService")
public class PractitionerServiceImpl implements com.yd.api.practitioner.service.PractitionerService {

    @Autowired
    private AclPractitionerDALService aclPractitionerDALService;
    @Autowired
    private MdCodeDALService mdCodeDALService;
    @Autowired
    private AclFileUploadDALService aclFileUploadDALService;
    @Autowired
    private AclPractitionerSubordinateSystemDALService aclPractitionerSubordinateSystemDALService;
    @Autowired
    private AclCustomerLogDALService aclCustomerLogDALService;
    @Autowired
    private OssService ossService;
    @Autowired
    private WechatService wechatService;
    @Autowired
    private AclCustomerShareDALService aclCustomerShareDALService;
    @Autowired
    private PoOrderDALService poOrderDALService;
    @Autowired
    private AclCustomerDALService aclCustomerDALService;
    @Autowired
    private MdMkCampaignDALService mdMkCampaignDALService;
    @Autowired
    private MktLeadsAssignedsDALService mktLeadsAssignedsDALService;
    @Autowired
    private ObjectCollectionTaggedDALService objectCollectionTaggedDALService;
    @Autowired
    private MktLeadsAssignedTrackDALService mktLeadsAssignedTrackDALService;
    @Autowired
    private MdTagDALService mdTagDALService;
    @Autowired
    private AclCustomerMembershipDALService aclCustomerMembershipDALService;
    @Autowired
    private SurveyCustomerAnswersDALService surveyCustomerAnswersDALService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private AclPractitionerPotentialDALService aclPractitionerPotentialDALService;
    @Autowired
    private AclPractitionerPotentialAssignedTrackDALService aclPractitionerPotentialAssignedTrackDALService;
    @Autowired
    private MktLeadsPoolDALService mktLeadsPoolDALService;
    @Autowired
    private MdDropOptionsDALService mdDropOptionsDALService;
    @Override
    public PractitionerLoginResponseVO practitionerLogin(PractitionerLoginRequestVO requestVO) {
        PractitionerLoginResponseVO responseVO = new PractitionerLoginResponseVO();
        String mobileNo = requestVO.getMobileNo();
        //1、校验入参，电话号码不能为空
        if (Strings.isNullOrEmpty(mobileNo)) {
            String[] params = {"mobileNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", params)));
            return responseVO;
        }
        //2、检查是否在ag_acl_customer表中存在该用户，如果不存在就注册，然后直接抛错，该用户未注册为经纪人
        PractitionerInfo practitionerInfo = aclPractitionerDALService.findPractitionerInfoByLogin(mobileNo);
        if(practitionerInfo != null){
            Long practitionerType = practitionerInfo.getPractitionerType();
            //处理特殊人员
            boolean isSpecial = false;
            String mobileSpecialStr = mdCodeDALService.findCodeByType("special_practitioner_mobile");
            if(!Strings.isNullOrEmpty(mobileSpecialStr)){
                List<String> mobileSpecials = Arrays.asList(mobileSpecialStr.split(","));
                isSpecial = mobileSpecials.contains(mobileNo);
            }
            if(28L == practitionerType || isSpecial){//只有寿险的经纪人和注册为经纪人的员工才能登录
                Long practitionerId = practitionerInfo.getPractitionerId();
                Long customerId = practitionerInfo.getCustomerId();
                AclCustomer customer = aclCustomerDALService.findById(customerId);
                PractitionerLoginBasicInfo basicInfo = new PractitionerLoginBasicInfo();
                BeanUtils.copyProperties(practitionerInfo,basicInfo);
                //获取头像
                Integer targetType = 1, targetUseFor = 1;
                CustomerFileUpload fileUpload = aclFileUploadDALService.findFilePathInfo(targetType,targetUseFor,practitionerId);
                String imagePath = (fileUpload != null) ? fileUpload.getFilePath() : null;
                basicInfo.setHeadImagePath(imagePath);
                //获取体系信息
                Long subordinateId = practitionerInfo.getSubordinateId();
                if(subordinateId != null){
                    PractitionerSubordinateInfo subordinateInfo = aclPractitionerSubordinateSystemDALService.findSubordinateInfo(subordinateId);
                    if(subordinateInfo != null){
                        basicInfo.setSubordinateName(subordinateInfo.getSubordinateName());
                        basicInfo.setSubordinateLeader(subordinateInfo.getSubordinateLeader());
                    }
                }
                //获取用户的登录次数
                List<AclCustomerLog> customerLogList = aclCustomerLogDALService.findLogInfoByCustomerId(customerId);
                int logTimes = (customerLogList.isEmpty()) ? 0 : customerLogList.size();
                //保存用户的登录记录
                aclCustomerLogDALService.saveCustomerLog(customerId,2);
                getOpenIdUrl(responseVO,customer);
                responseVO.setCustomerId(customerId);
                responseVO.setPractitionerId(practitionerId);
                responseVO.setPractitionerBasicInfo(basicInfo);
                responseVO.setLoginTimes(logTimes);
                responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
            }
        }else{
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830001")));
        }
        return responseVO;
    }

    private void getOpenIdUrl(PractitionerLoginResponseVO responseVO, AclCustomer customer) {
        String openId = customer.getYdWechatOpenid();
        if(Strings.isNullOrEmpty(openId)) {
            WeChatInfoByENV weChatInfo = wechatService.getWeChatInfoByENV("YDBJ", false);
            String appId = weChatInfo.getAppId(), secret = weChatInfo.getSecret();
            if (!Strings.isNullOrEmpty(appId) && !Strings.isNullOrEmpty(secret)) {
                try {
                    String info = appId+","+customer.getId();
                    String redirectUri = mdCodeDALService.findCodeByType("FilePathPrefix")+"ydapi/getOpenId?info=" + info;
                    redirectUri = URLEncoder.encode(redirectUri, "UTF-8");
                    String url = "https://open.weixin.qq.com/connect/oauth2/authorize?"
                            + "appid=" + appId
                            + "&redirect_uri=" + redirectUri
                            + "&response_type=code&scope=snsapi_base&state=123#wechat_redirect";
                    System.out.println(">>>>>url>>>>>>>:" + url);
                    responseVO.setGetOpenIdUrl(url);
                } catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    @Override
    public PractitionerRankResponseVO practitionerRank(PractitionerRankRequestVO requestVO) {
        PractitionerRankResponseVO responseVO = new PractitionerRankResponseVO();
        String mobileNo = requestVO.getMobileNo();
        Integer type = requestVO.getType();
        Integer time = requestVO.getTime();
        Integer platform = requestVO.getPlatform();
        type = (type == null) ? 1 : type;//默认：保费
        time = (time == null) ? 1 : time;//默认：本月
        platform = (platform == null) ? 1 : platform;
        if(!Strings.isNullOrEmpty(mobileNo)){
            //查询该手机号码的经纪人id，是否存在
            PractitionerBasicInfo practitionerBasicInfo = getPractitionerBasicInfo(mobileNo,platform);
            if(practitionerBasicInfo != null){
                String practitionerId = practitionerBasicInfo.getPractitionerId();
                if(!Strings.isNullOrEmpty(practitionerId)){
                    List<PractitionerRankInfo> rankInfoList = getPractitionerRankInfo(time,platform);
                    //按照指定类型排序
                    getPractitionerRankResult(responseVO,rankInfoList,type,practitionerId);
                    responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
                }
            }else{
                responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830001"))); //该经纪人不存在
            }
        }else{
            String [] param = {"mobileNo"};
            responseVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001", param)));
        }
        return responseVO;
    }

    private List<PractitionerRankInfo> getPractitionerRankInfo(Integer time, Integer platform) {
        List<PractitionerRankInfo> rankInfoList;
        if(platform == 1){
            Long practitionerTypeId = 28L;
            rankInfoList = aclPractitionerDALService.getPractitionerRankInfoForOnline(time,practitionerTypeId);
            //特殊人员处理
            String mobileSpecialStr = mdCodeDALService.findCodeByType("special_practitioner_mobile");
            if(!Strings.isNullOrEmpty(mobileSpecialStr)){
                List<String> mobileSpecials = Arrays.asList(mobileSpecialStr.split(","));
                List<PractitionerRankInfo> rankInfoListSpecials = aclPractitionerDALService.getPractitionerRankInfoForSpecials(mobileSpecials,time);
                rankInfoList.addAll(rankInfoListSpecials);
            }
        }else{
            rankInfoList = aclPractitionerDALService.getPractitionerRankInfoForOffline(time);
        }
        return rankInfoList;
    }

    private PractitionerBasicInfo getPractitionerBasicInfo(String mobileNo, Integer platform) {
        PractitionerBasicInfo practitionerBasicInfo;
        if(platform == 1){
            practitionerBasicInfo = aclPractitionerDALService.getPractitionerBasicInfoForOnline(mobileNo);
            if(practitionerBasicInfo != null){
                Long practitionerId = practitionerBasicInfo.getPractitionerIdForOnline();
                if(practitionerId != null){
                    practitionerBasicInfo.setPractitionerId(practitionerId.toString());
                }
            }
        }else{
            practitionerBasicInfo = aclPractitionerDALService.getPractitionerBasicInfoForOffline(mobileNo);
        }
        return practitionerBasicInfo;
    }

    private void getPractitionerRankResult(PractitionerRankResponseVO responseVO, List<PractitionerRankInfo> rankInfoList, Integer type, String practitionerId) {
        PractitionerInfoForAchievement practitionerInfo = new PractitionerInfoForAchievement(0D,0D,0);
        List<AclCustomerFortuneStatistics> rankList = new ArrayList<>();
        if(!rankInfoList.isEmpty()){
            //排序---1-保费，2-佣金，3-件数
            if(2 == type){
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyc).reversed());
            }else if(3 == type){
                rankInfoList.sort(Comparator.comparingInt(PractitionerRankInfo::getCount).reversed());
            }else{
                rankInfoList.sort(Comparator.comparingDouble(PractitionerRankInfo::getFyp).reversed());
            }
            AclCustomerFortuneStatistics fortuneStatistics;
            int rank = 1;
            Long practitionerIdForOnLine;
            String practitionerIdItem;
            for(PractitionerRankInfo practitionerItem : rankInfoList){
                //更新对象里面的内容，将PractitionerIdForOnLine里的信息赋值到PractitionerId
                practitionerIdForOnLine = practitionerItem.getPractitionerIdForOnLine();
                if(practitionerIdForOnLine != null){
                    practitionerItem.setPractitionerId(practitionerIdForOnLine.toString());
                }
                practitionerIdItem = practitionerItem.getPractitionerId();
                if(rank <= 10){//排名
                    fortuneStatistics = new AclCustomerFortuneStatistics();
                    BeanUtils.copyProperties(practitionerItem,fortuneStatistics);
                    fortuneStatistics.setSubordinateSystemName(practitionerItem.getSpcDivName());
                    fortuneStatistics.setRank(rank);
                    rankList.add(fortuneStatistics);
                }
                if(practitionerId.equals(practitionerIdItem)){//赋值
                    BeanUtils.copyProperties(practitionerItem,practitionerInfo);
                    practitionerInfo.setRank(rank);
                    if(rank > 10){
                        break;
                    }
                }
                rank ++;
            }
        }
        responseVO.setPractitionerInfo(practitionerInfo);
        responseVO.setRank(rankList);
    }

    @Override
    public SettingQueryResponseVO settingQuery(SettingQueryRequestVO requestVO) {
        SettingQueryResponseVO responseVO = new SettingQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();//入参经纪人id
        //需要查询的信息 1.自我介绍 2.我的设置 3.头像 4.个人微信二位码 5.生活照
        //1.2均在ag_acl_practitioner表中查询
        AclPractitioner practitioner = aclPractitionerDALService.findPractitionerById(practitionerId);
        String bioIntro = practitioner.getBioIntro();//经纪人个人介绍
        Integer isMobileShow = practitioner.getIsMobileShow();
        Integer isNameShow = practitioner.getIsNameShow();
        //3.4.5在ag_acl_file_upload中查询
        //target_type 1=从业人员practioner表, 2=员工user表,  3=客户customer表, 4=渠道客户channel表
        //target_use_for 文件用途 1=头像 2=生活照 3=证照 4=毕业证书 5=营业登记证 6.咨询定制方案 7.客户身份证正面照片 8.客户身份证反面照片 9.个人微信二维码
        //查询ag_acl_file_upload中isActive=1&&target_type=1&&target_id=practitionerId的信息
        AclFileUpload fileUpload = new AclFileUpload();
        fileUpload.setIsActive(1);
        fileUpload.setTargetType(1);
        fileUpload.setTargetId(practitionerId);
        List<AclFileUpload> fileUploads = aclFileUploadDALService.findByAclFileUpload(fileUpload);
        //筛选出头像
        BeanPropertyValueEqualsPredicate predicateClause  = new BeanPropertyValueEqualsPredicate("targetUseFor",1);
        List<AclFileUpload> headImgs = (List<AclFileUpload>) CollectionUtils.select(fileUploads,predicateClause);
        //头像至多一张
        String headImgUrl = null;
        if (!headImgs.isEmpty()){
            headImgUrl = headImgs.get(0).getFilePath();
        }
        //筛选出生活照
        predicateClause  = new BeanPropertyValueEqualsPredicate("targetUseFor",2);
        List<AclFileUpload> lifeImgs = (List<AclFileUpload>) CollectionUtils.select(fileUploads,predicateClause);
        List<LifeImg> lifeImgUrls = new ArrayList<>();
        for (AclFileUpload lifeImg: lifeImgs){
            LifeImg info = new LifeImg();
            info.setId(lifeImg.getId());
            info.setLifeImgUrl(lifeImg.getFilePath());
            lifeImgUrls.add(info);
        }
        //筛选出二维码
        predicateClause  = new BeanPropertyValueEqualsPredicate("targetUseFor",9);
        List<AclFileUpload> wxQRImgs = (List<AclFileUpload>) CollectionUtils.select(fileUploads,predicateClause);
        String wxQRImgUrl = null;
        if (!wxQRImgs.isEmpty()){
            wxQRImgUrl = wxQRImgs.get(0).getFilePath();
        }
        //返回参数
        responseVO.setPractitionerId(practitionerId);
        responseVO.setBioIntro(bioIntro);
        responseVO.setIsMobileShow(isMobileShow);
        responseVO.setIsNameShow(isNameShow);
        responseVO.setHeadImgUrl(headImgUrl);
        responseVO.setLifeImgUrls(lifeImgUrls);
        responseVO.setWxQRImgUrl(wxQRImgUrl);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public ImgDeleteResponseVO imgDelete(ImgDeleteRequestVO requestVO) {
        ImgDeleteResponseVO responseVO = new ImgDeleteResponseVO();
        Long fileId = requestVO.getFileId();
        AclFileUpload fileUpload = new AclFileUpload();
        fileUpload.setId(fileId);
        fileUpload.setIsActive(0);
        aclFileUploadDALService.updateFileUpload(fileUpload);
        responseVO.setPractitionerId(requestVO.getPractitionerId());
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    @Transactional
    public SettingSaveResponseVO settingSave(SettingSaveRequestVO requestVO) throws Exception {
        SettingSaveResponseVO responseVO = new SettingSaveResponseVO();
        //入参判断
        CommonResult commonResult = paramCheck(requestVO);
        if (!commonResult.isSuccess()){
            responseVO.setCommonResult(commonResult);
            return responseVO;
        }
        //保存经纪人自我介绍及设置
        practitionerMySettingSave(requestVO);
        String settingSave = requestVO.getSettingSave();
        if (settingSave.equalsIgnoreCase("img")){
            String message;
            //保存头像
            message = practitionerHeadImgSave(requestVO);
            if (!CommonUtil.isNullOrBlank(message)){
                responseVO.setCommonResult(new CommonResult(false,message));
                return responseVO;
            }
            //保存生活照
            message = practitionerLifeImgSave(requestVO);
            if (!CommonUtil.isNullOrBlank(message)){
                responseVO.setCommonResult(new CommonResult(false,message));
                return responseVO;
            }
            //保存二维码
            message = practitionerWXQRImgSave(requestVO);
            if (!CommonUtil.isNullOrBlank(message)){
                responseVO.setCommonResult(new CommonResult(false,message));
                return responseVO;
            }

        }
        responseVO.setCommonResult(commonResult);
        return responseVO;
    }

    @Override
    public MediaGetRespVO mediaGet(MediaGetReqVO requestVO) {
        MediaGetRespVO mediaGetRespVO=new MediaGetRespVO();
        String message=ZHBErrorConfig.getErrorInfo("800000");
        String mediaId = requestVO.getMediaId();
        String accessToken = wechatService.obtainToken(new TokenRequest());
        System.out.println("accessToken:"+accessToken);
        TicketRequest ticketRequest = new TicketRequest();
        ticketRequest.setAccessToken(accessToken);
        String jsapiTicket = wechatService.obtainTicket(ticketRequest);
        System.out.println("jsapiTicket:"+jsapiTicket);
        String ImgUrl= "https://api.weixin.qq.com/cgi-bin/media/get?access_token="+accessToken+"&media_id="+mediaId;
        String scale = requestVO.getScale();
        //判断上传尺寸是否符合要求
        if(!CommonUtil.isNullOrBlank(scale)){
            Map<String,Object> input = HttpUtil.getInput(ImgUrl);
            if (!(boolean)input.get("success")){
                mediaGetRespVO.setCommonResult(new CommonResult(false, (String)input.get("message")));
                return mediaGetRespVO;
            }
            InputStream inputStream = (InputStream) input.get("is");
            //判断图像尺寸
            Image img = null;
            try {
                img = ImageIO.read(inputStream);
            } catch (IOException e) {
                e.printStackTrace();
            }
            if (img == null || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
                mediaGetRespVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830003")));
                return mediaGetRespVO;
            }else {
                double width = img.getWidth(null);
                double height = img.getHeight(null);
                double value =height/width;
                Double scaleDouble = Double.valueOf(scale);
                if (value !=scaleDouble) {
                    if (scaleDouble == 1){
                        //上传头像尺寸比例为1:1
                        mediaGetRespVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830005")));
                        return mediaGetRespVO;
                    }else if(scaleDouble ==0.75) {
                        mediaGetRespVO.setCommonResult(new CommonResult(false, ZHBErrorConfig.getErrorInfo("830004")));
                        return mediaGetRespVO;
                    }
                }
            }
        }
//		System.out.println("ImgUrl:"+ImgUrl);
        mediaGetRespVO.setImgUrl(ImgUrl);
        mediaGetRespVO.setCommonResult(new CommonResult(true, message));
        return mediaGetRespVO;
    }

    @Override
    public OwnOpportunityQueryResponseVO ownOpportunityQuery(OwnOpportunityQueryRequestVO requestVO) {
        //查询自己的商机列表
        OwnOpportunityQueryResponseVO responseVO = new OwnOpportunityQueryResponseVO();
        Long practitionerId = requestVO.getPractitionerId();
        //经纪人查询通过自己分享成为自己商机的客户
        AclPractitioner practitioner = aclPractitionerDALService.findPractitionerById(practitionerId);
        Long customerId = practitioner.getCustomerId();
        //查询自己的分享码，仅银盾服务产品
        List<AclCustomerShare> aclCustomerShareList = aclCustomerShareDALService.findByCustomerIdAndInsurerId(customerId,888L);
        List<String> customerShareCodes = new ArrayList<>();
        for ( AclCustomerShare aclCustomerShare:aclCustomerShareList ) {
            customerShareCodes.add(aclCustomerShare.getShareCode());
        }
        //此map存放customerId及订单id
        Map<Long,Long> opportunityDateMap = new HashMap<>();
        if (!customerShareCodes.isEmpty()){
            //通过shareCodeId查询成交的订单
            List<PoOrder> poOrderList = poOrderDALService.findByStatusAndShareCodeInGroupByCustomerId(3,customerShareCodes);
            //便利order，查询商机客户，及服务订单id
            for (PoOrder poOrder:poOrderList) {
                if (poOrder.getCustomerId().longValue() == customerId.longValue()){
                    continue;
                }
                opportunityDateMap.put(poOrder.getCustomerId(), poOrder.getId());
            }
        }
        List<OwnOpportunityInfo> ownOpportunityInfos = aclPractitionerDALService.ownOpportunityQuery(practitionerId);
        for (OwnOpportunityInfo info : ownOpportunityInfos){
            info.setOrderId(opportunityDateMap.get(info.getOpportunityId()));
        }
        responseVO.setOwnOpportunityInfos(ownOpportunityInfos);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    @Override
    public OwnOpportunityDetailQueryResponseVO ownOpportunityDetailQuery(OwnOpportunityDetailQueryRequestVO requestVO) {
        OwnOpportunityDetailQueryResponseVO responseVO = new OwnOpportunityDetailQueryResponseVO();
        //商机客户基本信息
        OpportunityBasicInformationInfo basicInformationInfo = getOpportunityBasicInformation(requestVO);
        //调查问卷答案，咨询服务
        OpportunityConsultationInfo opportunityConsultationInfo = getOpportunityConsultation(requestVO);
        //商机跟进ag_survey_analysis_sales_record表差字段
        List<OpportunityRecordInfo> opportunityRecordInfos = getOpportunityRecords(requestVO);
        responseVO.setOpportunityRecordInfos(opportunityRecordInfos);
        responseVO.setOpportunityBasicInformationInfo(basicInformationInfo);
        responseVO.setOpportunityConsultationInfo(opportunityConsultationInfo);
        responseVO.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return responseVO;
    }

    /**
     * 商机客户基本信息
     * @param requestVO
     * @return
     */
    private OpportunityBasicInformationInfo getOpportunityBasicInformation(OwnOpportunityDetailQueryRequestVO requestVO) {
        OpportunityBasicInformationInfo info = new OpportunityBasicInformationInfo();
        Long customerId = requestVO.getOpportunityId();
        Long practitionerId = requestVO.getPractitionerId();
        AclCustomer customer = aclCustomerDALService.findByCustomerId(customerId);
        info.setOpportunityId(customerId);
        info.setName(customer.getName());
        info.setAge(customer.getAge());
        info.setGender(customer.getGender());
        info.setMobileNo(customer.getMobileNo());
        info.setWeChat(customer.getWechatNo());
        info.setOtherContacts(customer.getOtherContacts());
        info.setZodiacTypeId(customer.getZodiacTypeId());
        if (!CommonUtil.isNullOrZero(customer.getZodiacTypeId())){
            MdDropOptions mdDropOption = mdDropOptionsDALService.findByDropOptionId(Long.valueOf(customer.getZodiacTypeId()));
            info.setZodiacType(mdDropOption.getDropOptionName());
        }
        info.setBloodTypeId(customer.getBloodTypeId());
        if (!CommonUtil.isNullOrZero(customer.getBloodTypeId())){
            MdDropOptions mdDropOption = mdDropOptionsDALService.findByDropOptionId(Long.valueOf(customer.getBloodTypeId()));
            info.setBloodType(mdDropOption.getDropOptionName());
        }
        String mktCampaign = customer.getMktCampaign();
        if (!CommonUtil.isNullOrBlank(mktCampaign)){
            String mktCampaignId = mktCampaign.split(",")[0];
            MdMkCampaign mdMkCampaign = mdMkCampaignDALService.findByMktCampaignId(Long.valueOf(mktCampaignId));
            info.setSourceChannel(mdMkCampaign.getName());
        } else {
            MktLeadsPool pool = mktLeadsPoolDALService.findByCustomerId(customerId);
            if(pool!=null){
                Integer sourceFrom = pool.getSourceFrom();
                if (!CommonUtil.isNullOrZero(sourceFrom)){
                    MdDropOptions dropOption = mdDropOptionsDALService.findByDropOptionId(Long.valueOf(sourceFrom));
                    info.setSourceChannel(dropOption.getDropOptionName());
                }
            }
        }
        info.setAddress(customer.getAddress());
        MktLeadsAssignedTrack mktLeadsAssignedTrack = new MktLeadsAssignedTrack();
        mktLeadsAssignedTrack.setPractitionerId(practitionerId);
        mktLeadsAssignedTrack.setCustomerId(customerId);
        PageHelper.orderBy("created_at DESC");
        List<MktLeadsAssignedTrack> mktLeadsAssignedTracks = mktLeadsAssignedTrackDALService.findByMktLeadsAssignedTrack(mktLeadsAssignedTrack);
        Long opportunityDropOptionId = 0L;
        if (!mktLeadsAssignedTracks.isEmpty()){
            opportunityDropOptionId = mktLeadsAssignedTracks.get(0).getMdDropOptionId();
        }
        info.setMdDropOptionId(opportunityDropOptionId);
        if (!CommonUtil.isNullOrZero(opportunityDropOptionId)){
            MdDropOptions mdDropOption = mdDropOptionsDALService.findByDropOptionId(opportunityDropOptionId);
            info.setMdDropOptionName(mdDropOption.getDropOptionName());
        }
        MktLeadsAssigneds mktLeadsAssigneds = new MktLeadsAssigneds();
        mktLeadsAssigneds.setCustomerId(customerId);
        mktLeadsAssigneds.setAssignedPractitionerId(practitionerId);
        List<MktLeadsAssigneds>  mktLeadsAssignedsList =mktLeadsAssignedsDALService.findByMktLeadsAssigneds(mktLeadsAssigneds);
        mktLeadsAssigneds = mktLeadsAssignedsList.get(0);
        info.setFyc(mktLeadsAssigneds.getFyc());
        info.setFyp(mktLeadsAssigneds.getFyp());
        info.setPieces(mktLeadsAssigneds.getPieces());
        info.setRemark(mktLeadsAssigneds.getRemark());
        info.setTimeToClose(CommonUtil.dateParseString(mktLeadsAssigneds.getTimeToClose(),"yyyy-MM-dd HH:mm:ss"));
        info.setOpportunityDate(CommonUtil.dateParseString(mktLeadsAssigneds.getCreatedAt(),"yyyy-MM-dd HH:mm:ss"));
        info.setOpportunityCustomerTags(OpportunityCustomerTags(customerId));
        return info;
    }

    /**
     * 客户标签查询
     * @param customerId
     * @return
     */
    private List<OpportunityCustomerTag> OpportunityCustomerTags(Long customerId) {
        List<OpportunityCustomerTag> tags = new ArrayList<>();
        ObjectCollectionTagged objectCollectionTagged = new ObjectCollectionTagged();
        objectCollectionTagged.setIsActive(1);
        objectCollectionTagged.setTaggedObjectType(4);
        objectCollectionTagged.setTaggedObjectId(customerId);
        List<ObjectCollectionTagged> taggeds = objectCollectionTaggedDALService.findByObjectCollectionTagged(objectCollectionTagged);
        List<Long> tagIds = new ArrayList<>();
        for (ObjectCollectionTagged tagged: taggeds) {
            tagIds.add(Long.valueOf(tagged.getMdTagId()));
        }
        if (!tagIds.isEmpty()){
            List<MdTag> mdTags = mdTagDALService.findByTagIdIn(tagIds);
            for (MdTag mdTag:mdTags) {
                OpportunityCustomerTag tag = new OpportunityCustomerTag();
                tag.setTagId(mdTag.getId());
                tag.setTagName(mdTag.getTagName());
                tags.add(tag);
            }
        }
        return tags;
    }

    /**
     * 调查问卷答案，咨询服务
     * @param requestVO
     * @return
     */
    private OpportunityConsultationInfo getOpportunityConsultation(OwnOpportunityDetailQueryRequestVO requestVO) {
        OpportunityConsultationInfo info = new OpportunityConsultationInfo();
        Long orderId = requestVO.getOrderId();
        if (CommonUtil.isNullOrZero(orderId)){
            return info;
        }
        info.setOrderId(orderId);
        PoOrder poOrder = poOrderDALService.findByOrderId(requestVO.getOrderId());
        Long planId = poOrder.getPlanId();
        if (planId==453L||planId==464L) {
            info.setIsCompletedQuestionnaire(3L);
        }else {
            AclCustomerMembership membership = aclCustomerMembershipDALService.findByOrderId(requestVO.getOrderId());
            info.setIsCompletedQuestionnaire( (membership.getApproveDate() != null) ? 3L : 1L);
        }
        info.setOpportunitySurveyAnswersList(findSurveyAnswers(requestVO));
        return info;
    }

    /**
     * 问卷答案
     * @param requestVO
     * @return
     */
    private List<OpportunitySurveyAnswers> findSurveyAnswers(OwnOpportunityDetailQueryRequestVO requestVO) {
        Long customerId = requestVO.getOpportunityId();
        Long orderId = requestVO.getOrderId();
        SurveyCustomerAnswers surveyCustomerAnswersQuery=new SurveyCustomerAnswers();
        surveyCustomerAnswersQuery.setOrderId(orderId);
        surveyCustomerAnswersQuery.setCustomerId(customerId);
        List<SurveyCustomerAnswers> surveyCustomerAnswersList = surveyCustomerAnswersDALService.findByObjGroupByOrderBy(surveyCustomerAnswersQuery,null,null);
        List<SurveyCustomerAnswers> surveyQuestionsList = surveyCustomerAnswersDALService.findByObjGroupByOrderBy(surveyCustomerAnswersQuery,"question_name","id");
        List<OpportunitySurveyAnswers> req=new ArrayList<>();
        for (SurveyCustomerAnswers surveyQuestions : surveyQuestionsList) {
            String questionName = surveyQuestions.getQuestionName();
            BeanPropertyValueEqualsPredicate predicateClause = new BeanPropertyValueEqualsPredicate( "questionName", questionName);
            List<SurveyCustomerAnswers> mainRisks = (List<SurveyCustomerAnswers>) CollectionUtils.select(surveyCustomerAnswersList, predicateClause);
            OpportunitySurveyAnswers surveyAnswers=new OpportunitySurveyAnswers();
            surveyAnswers.setQuestionName(surveyQuestions.getQuestionName());
            List<String> optionNameList=new ArrayList<>();
            for (SurveyCustomerAnswers surveyCustomerAnswers : mainRisks) {
                if (surveyCustomerAnswers.getOptionName() != null) {
                    optionNameList.add(surveyCustomerAnswers.getOptionName());
                }
                if (surveyCustomerAnswers.getCustomerInput() != null){
                    optionNameList.add(surveyCustomerAnswers.getCustomerInput());
                }
            }
            surveyAnswers.setOptionName(optionNameList);
            req.add(surveyAnswers);
        }
        return req;
    }

    private List<OpportunityRecordInfo> getOpportunityRecords(OwnOpportunityDetailQueryRequestVO requestVO) {
        Long practitionerId = requestVO.getPractitionerId();
        Long customerId = requestVO.getOpportunityId();
        List<OpportunityRecordInfo> infos = new ArrayList<>();
        MktLeadsAssignedTrack mktLeadsAssignedTrack = new MktLeadsAssignedTrack();
        mktLeadsAssignedTrack.setPractitionerId(practitionerId);
        mktLeadsAssignedTrack.setCustomerId(customerId);
        PageHelper.orderBy("created_at DESC , updated_at DESC");
        List<MktLeadsAssignedTrack> mktLeadsAssignedTracks = mktLeadsAssignedTrackDALService.findByMktLeadsAssignedTrack(mktLeadsAssignedTrack);
        List<MdDropOptions> dropOptionsList = mdDropOptionsDALService.findByDropMasterCode("bizchance_promotion_action");
        for (MktLeadsAssignedTrack track : mktLeadsAssignedTracks) {
            OpportunityRecordInfo info = new OpportunityRecordInfo();
            CommonUtil.simpleObjectCopy(track, info);
            info.setOpportunityId(track.getCustomerId());
            info.setNoticeDate(CommonUtil.dateParseString(track.getCreatedAt(), "yyyy-MM-dd"));
            BeanPropertyValueEqualsPredicate predicate = new BeanPropertyValueEqualsPredicate("id", track.getMdDropOptionId());
            List<MdDropOptions> select = (List<MdDropOptions>)CollectionUtils.select(dropOptionsList, predicate);
            if (!select.isEmpty()){
                info.setMdDropOptionName(select.get(0).getDropOptionName());
            }
            infos.add(info);
        }
        return infos;
    }

    public RecruitResponseVO recruit(RecruitRequestVO requestVO) {
        RecruitResponseVO responseVO = new RecruitResponseVO();
        String name = requestVO.getName();
        String mobileNo = requestVO.getMobileNo();
        Long practitionerId = requestVO.getPractitionerId();
        if(!Strings.isNullOrEmpty(name) && !Strings.isNullOrEmpty(mobileNo) && practitionerId != null){
            if(mobileNo.length() != 11 || mobileNo.startsWith("1")){
                RegisterRequestVO register = new RegisterRequestVO();
                register.setMobileNo(mobileNo);
                register.setName(name);
                //将增员对象进行注册
                RegisterResponseVO registerResp = customerService.register(register);
                Long customerId = registerResp.getCustomerId();
                //判断是否已经为银盾经纪人
                AclPractitioner practitioner = aclPractitionerDALService.findByCustomerIdIsActive(customerId,1);
                if(practitioner == null){
                    //判断该增员是否已存在
                    Long potentialId = requestVO.getPotentialId();
                    List<AclPractitionerPotential> practitionerPotentialList = aclPractitionerPotentialDALService.findByMobileNo(mobileNo,1);
                    if(potentialId != null || practitionerPotentialList.isEmpty()){
                        AclPractitionerPotential practitionerPotential = new AclPractitionerPotential();
                        BeanUtils.copyProperties(requestVO,practitionerPotential);
                        practitionerPotential.setCustomerId(customerId);
                        practitionerPotential.setPractitionerAssignedIds(practitionerId.toString());
                        practitionerPotential.setCreatedAt(new Date());
                        practitionerPotential.setCreatedBy(practitionerId);
                        practitionerPotential.setCreatorType(2);
                        practitionerPotential.setIsActive(1);
                        if(potentialId != null){
                            practitionerPotential.setId(potentialId);
                        }
                        aclPractitionerPotentialDALService.save(practitionerPotential);
                        potentialId = practitionerPotential.getId();
                        //如果已经分配团队长，则在追踪表中增加记录
                        List<Long> practitionerPotentialIdList = new ArrayList<>();
                        practitionerPotentialIdList.add(potentialId);
                        addPractitionerPotentialTrack(practitionerPotentialIdList, practitionerId);

                        responseVO.setPotentialCustomerId(customerId);
                        responseVO.setPotentialId(potentialId);
                        responseVO.setCommonResult(new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000")));
                    }else{
                        responseVO.setPotentialCustomerId(customerId);
                        responseVO.setPotentialId(practitionerPotentialList.get(0).getId());
                        responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("830011")));
                    }
                }else{
                    responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("830010")));
                }
            }else{
                String [] paras = {mobileNo};
                responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("630001",paras)));
            }
        }else{
            String [] paras = {"name,mobileNo,practitionerId"};
            responseVO.setCommonResult(new CommonResult(false,ZHBErrorConfig.getErrorInfo("610002",paras)));
        }
        return responseVO;
    }

    private void addPractitionerPotentialTrack(List<Long> practitionerPotentialIdList, Long practitionerId) {
        if (practitionerId != null && !practitionerPotentialIdList.isEmpty()) {
            List<AclPractitionerPotentialAssignedTrack> potentialAssignedTrackList = new ArrayList<>();
            AclPractitionerPotentialAssignedTrack potentialAssignedTrack;
            for (Long potentialId : practitionerPotentialIdList) {
                potentialAssignedTrack = new AclPractitionerPotentialAssignedTrack();
                potentialAssignedTrack.setPractitionerPotentialId(potentialId);
                potentialAssignedTrack.setPractitionerAssignedId(practitionerId);
                potentialAssignedTrack.setTrackStatusId(112L);//待跟进
                potentialAssignedTrack.setIsActive(1);
                potentialAssignedTrack.setIsLasted(1);
                potentialAssignedTrack.setCreatedAt(new Date());
                potentialAssignedTrack.setCreatedBy(practitionerId);
                potentialAssignedTrack.setCreatorType(2);
                potentialAssignedTrackList.add(potentialAssignedTrack);
            }
            aclPractitionerPotentialAssignedTrackDALService.saveAll(potentialAssignedTrackList);
        }

    }

    @Override
    public AddRecruitTrackResponseVO addRecruitTrack(AddRecruitTrackRequestVO requestVO) {
        return null;
    }

    @Override
    public RecruitTrackQueryResponseVO recruitTrackQuery(RecruitTrackQueryRequestVO requestVO) {
        return null;
    }

    @Override
    public RecruitListResponseVO recruitListQuery(RecruitListRequestVO requestVO) {
        return null;
    }

    @Override
    public OwnOpportunityBasicInformationSaveResponseVO ownOpportunityBasicInformationSave(OwnOpportunityBasicInformationSaveRequestVO requestVO) {
        OwnOpportunityBasicInformationSaveResponseVO resp = new OwnOpportunityBasicInformationSaveResponseVO();
        Long leadsAssignedId = requestVO.getLeadsAssignedId();
        Long customerId = requestVO.getOpportunityId();
        if (CommonUtil.isNullOrZero(leadsAssignedId)){
            //判断是否为经纪人自己创建商机
            CommonResult commonResult = isCreateOpportunity(requestVO);
            if (!commonResult.isSuccess()){
                resp.setCommonResult(commonResult);
                return resp;
            }
            customerId = requestVO.getOpportunityId();
        }

        //保存基础信息
        saveCustomerInfo(customerId,requestVO);
        //保存/激活新的标签
        saveCustomerTag(customerId,requestVO.getOpportunityCustomerTags());
        //更新预设值
        saveLeadsAssigneds(requestVO);
        resp.setLeadsAssignedId(requestVO.getLeadsAssignedId());
        resp.setOpportunityId(customerId);
        resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return resp;
    }

    private CommonResult isCreateOpportunity(OwnOpportunityBasicInformationSaveRequestVO requestVO) {
        Long customerId;
        //当指派id为null时,认为是保存新的商机
        //校验商机号码,手机号码对应的customer是否存在
        String mobileNo = requestVO.getMobileNo();
        AclCustomer aclCustomer = aclCustomerDALService.findByMobileNo(mobileNo);
        //判断是否通过手机号码找到客户
        if (aclCustomer!=null){
            MktLeadsAssigneds mktLeadsAssigneds = new MktLeadsAssigneds();
            mktLeadsAssigneds.setCustomerId(aclCustomer.getId());
            List<MktLeadsAssigneds> mktLeadsAssignedsList = mktLeadsAssignedsDALService.findByMktLeadsAssigneds(mktLeadsAssigneds);
            if (!mktLeadsAssignedsList.isEmpty()){
                for (MktLeadsAssigneds info :mktLeadsAssignedsList){
                    Long assignedPractitionerId = info.getAssignedPractitionerId();
                    if (assignedPractitionerId.equals(requestVO.getAssignedPractitionerId())){
                        break;
                    }
                }
                return new CommonResult(false,ZHBErrorConfig.getErrorInfo("830014"));
            }
        }else {
            //此人为第一次进来
            //帮其经行注册
            DESTypeHandler jpaCryptoConverter = new DESTypeHandler();
            aclCustomer = new AclCustomer();
            aclCustomer.setRole(2);//1= Staff 2=Customer 3=Partner
            aclCustomer.setAccountId(createAccountId(mobileNo));
            aclCustomer.setLogin(mobileNo);
            aclCustomer.setMobileNo(jpaCryptoConverter.encode(mobileNo));
            aclCustomer.setCusLevel(1);
            aclCustomer.setName(requestVO.getName());
            aclCustomer.setIsActive(1);
            aclCustomer.setRoleId(3L);
            aclCustomer.setWithdrawType(0);
            aclCustomer.setCreatedAt(new Date());
            aclCustomer.setCreatedBy(-1L);
            aclCustomer.setUpdatedAt(new Date());
            aclCustomer.setUpdatedBy(-1L);
            aclCustomer.setChannelReferralRateId(3L);
            aclCustomerDALService.save(aclCustomer);
        }
        customerId = aclCustomer.getId();
        //查询此customer是否在pool中
        MktLeadsPool pool = mktLeadsPoolDALService.findByCustomerId(customerId);
        if (pool == null){
            //线索池为空时,保存线索池
            pool = new MktLeadsPool();
            pool.setCustomerId(customerId);
            pool.setHasAssigned(1);
            pool.setSourceFrom(requestVO.getSourceFrom());
            pool.setIsActive(1);
            pool.setAddedAt(new Date());
            pool.setAddedBy(-1L);
            mktLeadsPoolDALService.save(pool);
        }
        //获取线索库id
        Long poolId = pool.getId();
        //保存至指派表
        MktLeadsAssigneds assigneds = new MktLeadsAssigneds();
        assigneds.setAssignedPractitionerId(requestVO.getAssignedPractitionerId());
        assigneds.setCustomerId(customerId);
        assigneds.setIsActive(1);
        assigneds.setCreatedAt(new Date());
        assigneds.setCreatedBy(-1L);
        assigneds.setUpdatedAt(new Date());
        assigneds.setUpdatedBy(-1L);
        mktLeadsAssignedsDALService.save(assigneds);
        requestVO.setOpportunityId(customerId);
        requestVO.setLeadsAssignedId(assigneds.getId());
        return new CommonResult(true,ZHBErrorConfig.getErrorInfo("800000"));
    }

    private String createAccountId(String mobileNo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String sub = null;
        if(mobileNo != null && !"".equals(mobileNo)){
            sub = mobileNo.substring(mobileNo.length()-6);
        }
        return "C_"+sub+"_"+sdf.format(new Date());
    }

    private void saveCustomerInfo(Long customerId, OwnOpportunityBasicInformationSaveRequestVO requestVO) {
        AclCustomer customer = aclCustomerDALService.findById(customerId);
        DESTypeHandler jpaCryptoConverter = new DESTypeHandler();
        String mobileNo = customer.getMobileNo();
        customer.setMobileNo(jpaCryptoConverter.encode(mobileNo));
        customer.setName(requestVO.getName());
        customer.setBirthDate(CommonUtil.stringParseDate(requestVO.getBirthDate(),"yyyy-MM-dd"));
        customer.setGender(requestVO.getGender());
        customer.setAddress(requestVO.getAddress());
        customer.setAge(requestVO.getAge());
        customer.setWechatNo(requestVO.getWeChat());
        customer.setOtherContacts(requestVO.getOtherContacts());
        customer.setZodiacTypeId(requestVO.getZodiacTypeId());
        customer.setBloodTypeId(requestVO.getBloodTypeId());
        aclCustomerDALService.update(customer);
    }

    private void saveLeadsAssigneds(OwnOpportunityBasicInformationSaveRequestVO requestVO) {
        Long leadsAssignedId = requestVO.getLeadsAssignedId();
        MktLeadsAssigneds mktLeadsAssigneds = mktLeadsAssignedsDALService.findByLeadsAssignedId(leadsAssignedId);
        mktLeadsAssigneds.setFyc(requestVO.getFyc());
        mktLeadsAssigneds.setFyp(requestVO.getFyp());
        mktLeadsAssigneds.setPieces(requestVO.getPieces());
        mktLeadsAssigneds.setTimeToClose(CommonUtil.stringParseDate(requestVO.getTimeToClose(),"yyyy-MM-dd"));
        mktLeadsAssigneds.setRemark(requestVO.getRemark());
        mktLeadsAssignedsDALService.updateMktLeadsAssigneds(mktLeadsAssigneds);
    }

    private void saveCustomerTag(Long customerId ,List<OpportunityCustomerTag> opportunityCustomerTags) {
        //保存标签
        //此人的原有标签全部至0
        ObjectCollectionTagged tagged = new ObjectCollectionTagged();
        tagged.setTaggedObjectType(4);
        tagged.setTaggedObjectId(customerId);
        List<ObjectCollectionTagged> taggedList = objectCollectionTaggedDALService.findByObjectCollectionTagged(tagged);
        for (ObjectCollectionTagged tag:taggedList) {
            tag.setIsActive(0);
            objectCollectionTaggedDALService.updateObjectCollectionTagged(tag);
        }
        for (OpportunityCustomerTag tag:opportunityCustomerTags) {
            tagged = new ObjectCollectionTagged();
            tagged.setTaggedObjectType(4);
            tagged.setTaggedObjectId(customerId);
            tagged.setMdTagId(tag.getTagId().intValue());
            List<ObjectCollectionTagged> taggeds = objectCollectionTaggedDALService.findByObjectCollectionTagged(tagged);
            if (taggeds.isEmpty()){
                //保存
                tagged.setIsActive(1);
                tagged.setRecommendOrder(1);
                tagged.setDisplayOrder(1);
                tagged.setCreatedBy(-1L);
                tagged.setCreatedAt(new Date());
                tagged.setUpdatedBy(-1L);
                tagged.setUpdatedAt(new Date());
                objectCollectionTaggedDALService.saveObjectCollectionTagged(tagged);
            }else {
                //更新
                tagged = taggeds.get(0);
                tagged.setIsActive(1);
                tagged.setUpdatedBy(-1L);
                tagged.setUpdatedAt(new Date());
                objectCollectionTaggedDALService.updateObjectCollectionTagged(tagged);
            }
        }
    }

    @Override
    public OwnOpportunityRecordSaveResponseVO ownOpportunityRecordSave(OwnOpportunityRecordSaveRequestVO requestVO) {
        OwnOpportunityRecordSaveResponseVO resp = new OwnOpportunityRecordSaveResponseVO();
        CommonResult commonResult = check(requestVO);
        if (!commonResult.isSuccess()){
            resp.setCommonResult(commonResult);
            return resp;
        }

        MktLeadsAssignedTrack track = new MktLeadsAssignedTrack();
        CommonUtil.simpleObjectCopy(requestVO,track);
        track.setCustomerId(requestVO.getOpportunityId());
        track.setCreatedBy(-1L);
        track.setCreatedAt(CommonUtil.stringParseDate(requestVO.getNoticeDate()+" 00:00:00", "yyyy-MM-dd HH:mm:ss"));
        track.setUpdatedBy(-1L);
        track.setUpdatedAt((new Date()));
        MdDropOptions dropOtions = mdDropOptionsDALService.findByDropOptionId(requestVO.getMdDropOptionId());
        track.setTrackScore(dropOtions.getDropOptionScore());
        if (CommonUtil.isNullOrZero(requestVO.getId())){
            //保存
            mktLeadsAssignedTrackDALService.saveTrack(track);
        }else {
            //更新
            mktLeadsAssignedTrackDALService.updateTrack(track);
        }
        resp.setOpportunityId(requestVO.getOpportunityId());
        resp.setCommonResult(new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000")));
        return resp;
    }

    private CommonResult check(OwnOpportunityRecordSaveRequestVO requestVO) {
        String noticeDate = requestVO.getNoticeDate();
        if (CommonUtil.isNullOrBlank(noticeDate)){
            return new CommonResult(false, ZHBErrorConfig.getErrorInfo("830012"));
        }
        String salesNotice = requestVO.getSalesNotice();
        if (CommonUtil.isNullOrBlank(salesNotice)){
            return new CommonResult(false, ZHBErrorConfig.getErrorInfo("830013"));
        }
        return new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000"));
    }

    private CommonResult paramCheck(SettingSaveRequestVO requestVO) {
        //检查入参判断
        Long practitionerId = requestVO.getPractitionerId();
        if (CommonUtil.isNullOrZero(practitionerId)){
            String[] params = {"practitionerId"};
            return new CommonResult(false, ZHBErrorConfig.getErrorInfo("610001",params));
        }
        //生活照至多三张
        List<String> lifeImgUrls = requestVO.getLifeImgUrls();
        if (lifeImgUrls != null){
            if (!lifeImgUrls.isEmpty()){
                AclFileUpload aclFileUpload = new AclFileUpload();
                aclFileUpload.setTargetType(1);
                aclFileUpload.setTargetId(practitionerId);
                aclFileUpload.setTargetUseFor(2);
                aclFileUpload.setIsActive(1);
                List<AclFileUpload> fileUploads = aclFileUploadDALService.findByAclFileUpload(aclFileUpload);
                if (!fileUploads.isEmpty()){
                    int size = lifeImgUrls.size()+fileUploads.size();
                    if (size>=4){
                        return new CommonResult(false, ZHBErrorConfig.getErrorInfo("830006"));
                    }
                }
            }
        }
        return new CommonResult(true, ZHBErrorConfig.getErrorInfo("800000"));
    }

    private void practitionerMySettingSave(SettingSaveRequestVO requestVO) {
        //修改个人设置，个人介绍
        String settingSave = requestVO.getSettingSave();
        if (settingSave.equalsIgnoreCase("isShow")||settingSave.equalsIgnoreCase("intro")){
            Long practitionerId = requestVO.getPractitionerId();
            AclPractitioner practitioner = aclPractitionerDALService.findPractitionerById(practitionerId);
            if (settingSave.equalsIgnoreCase("intro")){
                practitioner.setBioIntro(requestVO.getBioIntro());
            }else if (settingSave.equalsIgnoreCase("isShow")){
                practitioner.setIsNameShow(requestVO.getIsNameShow());
                practitioner.setIsMobileShow(requestVO.getIsMobileShow());
            }
            aclPractitionerDALService.updatePractitioner(practitioner);
        }
    }

    private String practitionerHeadImgSave(SettingSaveRequestVO requestVO) throws Exception {
        String headImgUrl = requestVO.getHeadImgUrl();
        if (CommonUtil.isNullOrBlank(headImgUrl)){
            //如果头像没有地址，则认为没有上传
            return null;
        }
        //上传图片
        return uploadImage(headImgUrl,requestVO.getPractitionerId(),1);
    }

    private String practitionerLifeImgSave(SettingSaveRequestVO requestVO) throws Exception {
        List<String> lifeImgUrls = requestVO.getLifeImgUrls();
        StringBuilder message = new StringBuilder(" ");
        int i = 1;
        for (String lifeImgUrl: lifeImgUrls){
            String resp = uploadImage(lifeImgUrl, requestVO.getPractitionerId(), 2);
            if (!CommonUtil.isNullOrBlank(resp)){
                message.append(i).append(",");
            }
            i++;
        }
        if (!CommonUtil.isNullOrBlank(message.toString())){
            return "此次上传第"+message+"张图片尺寸不符合要求!!";
        }
        return null;
    }

    private String practitionerWXQRImgSave(SettingSaveRequestVO requestVO) throws Exception{
        String wxQRImgUrl = requestVO.getWxQRImgUrl();
        if (CommonUtil.isNullOrBlank(wxQRImgUrl)){
            //如果头像没有地址，则认为没有上传
            return null;
        }
        //上传图片
        return uploadImage(wxQRImgUrl,requestVO.getPractitionerId(),9);
    }

    private String uploadImage(String headImgUrl, Long practitionerId,Integer targetUseFor) throws Exception{
        Map<String, Object> input = HttpUtil.getInput(headImgUrl);
        if (!(boolean)input.get("success")){
            if (targetUseFor==1){
                //地址转流失败
                return ZHBErrorConfig.getErrorInfo("830007");
            }else if(targetUseFor==2){
                return ZHBErrorConfig.getErrorInfo("830008");
            }else if(targetUseFor==9){
                return ZHBErrorConfig.getErrorInfo("830009");
            }
        }
        //获取头像流
        InputStream inputStream = (InputStream) input.get("is");
        //判断图像尺寸
        BufferedImage img = ImageIO.read(inputStream);
        if (img == null || img.getWidth(null) <= 0 || img.getHeight(null) <= 0) {
            return ZHBErrorConfig.getErrorInfo("830003");
        }
//        else {
//            double width = img.getWidth(null);
//            double height = img.getHeight(null);
//            double value =height/width;
//            ByteArrayOutputStream os = new ByteArrayOutputStream();
//            ImageIO.write(img, "jpg", os);
//            inputStream = new ByteArrayInputStream(os.toByteArray());
//            if (value !=1&&(targetUseFor == 1 || targetUseFor == 9)){
//                //上传头像尺寸比例为1:1
//                return ZHBErrorConfig.getErrorInfo("830005");
//            }else if(value !=0.75 && targetUseFor == 2){
//                return ZHBErrorConfig.getErrorInfo("830004");
//            }
//        }
        //上传图片至阿里云
        String prefix = "broker/"+practitionerId+"/";
        String originalFilename = generateKey(targetUseFor);
        String key = prefix + originalFilename;
        String putFileToOss = ossService.putFileToOss(null,key,inputStream);
        //将之前头像设置为不启用
        if (targetUseFor==1||targetUseFor==9){
            updateImgOld(practitionerId,targetUseFor);
        }
        //保存到数据库
        AclPractitioner practitioner = aclPractitionerDALService.findPractitionerById(practitionerId);
        AclFileUpload aclFileUpload = new AclFileUpload();
        aclFileUpload.setTargetType(1);
        aclFileUpload.setTargetId(practitioner.getId());
        String practitionerCode = practitioner.getPractitionerCode();
        aclFileUpload.setTargetNo(practitionerCode);
        aclFileUpload.setFileType("jpg");
        aclFileUpload.setFileName(originalFilename);
        aclFileUpload.setFilePath(putFileToOss);
        aclFileUpload.setTargetUseFor(targetUseFor);
        aclFileUpload.setFileSize(String.valueOf(inputStream.available()));
        aclFileUpload.setOssKey(key);
        aclFileUpload.setIsActive(1);
        aclFileUpload.setUploadedAt(new Date());
        aclFileUpload.setUploadedBy(-1L);
        aclFileUpload.setTargetSeq(getTargetSeq(practitioner.getId(),targetUseFor));
        aclFileUploadDALService.saveFileUpload(aclFileUpload);
        return null;
    }
    private String generateKey(int targetUseFor) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        return targetUseFor+sdf.format(new Date()) + CommonUtil.getRandomNum(3)+".jpg";
    }

    private void updateImgOld(Long practitionerId, int targetUseFor) {
        AclFileUpload aclFileUpload = new AclFileUpload();
        aclFileUpload.setTargetId(practitionerId);
        aclFileUpload.setTargetType(1);
        aclFileUpload.setIsActive(1);
        aclFileUpload.setTargetUseFor(targetUseFor);
        List<AclFileUpload> uploads = aclFileUploadDALService.findByAclFileUpload(aclFileUpload);
        if (!uploads.isEmpty()){
            for (AclFileUpload fileUpload :uploads){
                fileUpload.setIsActive(0);
                aclFileUploadDALService.updateFileUpload(fileUpload);
            }
        }
    }

    private Integer getTargetSeq(Long practitionerId, Integer targetUseFor) {
        AclFileUpload aclFileUpload = new AclFileUpload();
        aclFileUpload.setTargetType(1);
        aclFileUpload.setTargetId(practitionerId);
        aclFileUpload.setTargetUseFor(targetUseFor);
        List<AclFileUpload> aclFileUploadList = aclFileUploadDALService.findByAclFileUpload(aclFileUpload);
        return aclFileUploadList.size()+1;
    }
}
