package com.yd.dal.service.marketing.Impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yd.dal.entity.marketing.MktAnnouncement;
import com.yd.dal.entity.marketing.MktLeadsAssignedTrack;
import com.yd.dal.mapper.marketing.MktAnnouncementMapper;
import com.yd.dal.service.marketing.MktAnnouncementDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Service("mktAnnouncementDALService")
public class MktAnnouncementDALServiceImpl implements MktAnnouncementDALService {
    @Resource
    private MktAnnouncementMapper mktAnnouncementMapper;

    @Override
    public MktAnnouncement findById(Long id) {
        return mktAnnouncementMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<MktAnnouncement> findByType(Long announcementType) {
        MktAnnouncement info = new MktAnnouncement();
        info.setAnnouncementType(announcementType);
        info.setIsActive(1);
        PageHelper.orderBy("seq asc , created_at desc");
        Page<MktAnnouncement> mktAnnouncementPageInfo = mktAnnouncementMapper.selectByObj(info);
        PageInfo<MktAnnouncement> pageInfo = new PageInfo<>(mktAnnouncementPageInfo);
        List<MktAnnouncement> list = pageInfo.getList();
        return list;
    }

    @Override
    public List<MktAnnouncement> findByIsActiveAndAnnouncementAtBefore(int isActive, Date date) {
    	List<MktAnnouncement> listTop = mktAnnouncementMapper.findByIsActiveAndAnnouncementAtBeforeTop(isActive,date);
    	List<MktAnnouncement> list = mktAnnouncementMapper.findByIsActiveAndAnnouncementAtBefore(isActive,date);
    	listTop.addAll(list);
        return listTop;
    }
}
