package com.yd.dal.entity.salary;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * ag_acl_salary
 * @author 
 */
public class AgAclSalary implements Serializable {
    /**
     * serial id
     */
    private Long id;

    /**
     * practitioner_id
     */
    private Long practitionerId;

    /**
     * 从业人员编号
     */
    private String practitionerCode;

    /**
     * 薪资年月
     */
    private String yearMonth;

    /**
     * 薪资类别(1=个人销售A; 2=销售管理B; 3=其他加扣款C)
     */
    private Integer salaryType;

    /**
     * 薪资code
     */
    private String salaryCode;

    /**
     * 薪资名称
     */
    private String salaryName;

    /**
     * 金额
     */
    private BigDecimal amount;

    /**
     * 税额
     */
    private BigDecimal tax;

    /**
     * 税后金额
     */
    private BigDecimal afterTaxAmount;

    /**
     * FK ag_acl_life_practitioner_salary.id
     */
    private Long lifePractitionerSalaryId;

    /**
     * 1=active 2=inactive
     */
    private Integer isActive;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createdAt;

    /**
     * FK ag_acl_user.id
     */
    private Long createdBy;

    /**
     * 修改时间
     */
    private Date updatedAt;

    /**
     * FK ag_acl_user.id
     */
    private Long updatedBy;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPractitionerId() {
        return practitionerId;
    }

    public void setPractitionerId(Long practitionerId) {
        this.practitionerId = practitionerId;
    }

    public String getPractitionerCode() {
        return practitionerCode;
    }

    public void setPractitionerCode(String practitionerCode) {
        this.practitionerCode = practitionerCode;
    }

    public String getYearMonth() {
        return yearMonth;
    }

    public void setYearMonth(String yearMonth) {
        this.yearMonth = yearMonth;
    }

    public Integer getSalaryType() {
        return salaryType;
    }

    public void setSalaryType(Integer salaryType) {
        this.salaryType = salaryType;
    }

    public String getSalaryCode() {
        return salaryCode;
    }

    public void setSalaryCode(String salaryCode) {
        this.salaryCode = salaryCode;
    }

    public String getSalaryName() {
        return salaryName;
    }

    public void setSalaryName(String salaryName) {
        this.salaryName = salaryName;
    }

    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }

    public BigDecimal getAfterTaxAmount() {
        return afterTaxAmount;
    }

    public void setAfterTaxAmount(BigDecimal afterTaxAmount) {
        this.afterTaxAmount = afterTaxAmount;
    }

    public Long getLifePractitionerSalaryId() {
        return lifePractitionerSalaryId;
    }

    public void setLifePractitionerSalaryId(Long lifePractitionerSalaryId) {
        this.lifePractitionerSalaryId = lifePractitionerSalaryId;
    }

    public Integer getIsActive() {
        return isActive;
    }

    public void setIsActive(Integer isActive) {
        this.isActive = isActive;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Long getCreatedBy() {
        return createdBy;
    }

    public void setCreatedBy(Long createdBy) {
        this.createdBy = createdBy;
    }

    public Date getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Long getUpdatedBy() {
        return updatedBy;
    }

    public void setUpdatedBy(Long updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        AgAclSalary other = (AgAclSalary) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getPractitionerId() == null ? other.getPractitionerId() == null : this.getPractitionerId().equals(other.getPractitionerId()))
            && (this.getPractitionerCode() == null ? other.getPractitionerCode() == null : this.getPractitionerCode().equals(other.getPractitionerCode()))
            && (this.getYearMonth() == null ? other.getYearMonth() == null : this.getYearMonth().equals(other.getYearMonth()))
            && (this.getSalaryType() == null ? other.getSalaryType() == null : this.getSalaryType().equals(other.getSalaryType()))
            && (this.getSalaryCode() == null ? other.getSalaryCode() == null : this.getSalaryCode().equals(other.getSalaryCode()))
            && (this.getSalaryName() == null ? other.getSalaryName() == null : this.getSalaryName().equals(other.getSalaryName()))
            && (this.getAmount() == null ? other.getAmount() == null : this.getAmount().equals(other.getAmount()))
            && (this.getTax() == null ? other.getTax() == null : this.getTax().equals(other.getTax()))
            && (this.getAfterTaxAmount() == null ? other.getAfterTaxAmount() == null : this.getAfterTaxAmount().equals(other.getAfterTaxAmount()))
            && (this.getLifePractitionerSalaryId() == null ? other.getLifePractitionerSalaryId() == null : this.getLifePractitionerSalaryId().equals(other.getLifePractitionerSalaryId()))
            && (this.getIsActive() == null ? other.getIsActive() == null : this.getIsActive().equals(other.getIsActive()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
            && (this.getCreatedAt() == null ? other.getCreatedAt() == null : this.getCreatedAt().equals(other.getCreatedAt()))
            && (this.getCreatedBy() == null ? other.getCreatedBy() == null : this.getCreatedBy().equals(other.getCreatedBy()))
            && (this.getUpdatedAt() == null ? other.getUpdatedAt() == null : this.getUpdatedAt().equals(other.getUpdatedAt()))
            && (this.getUpdatedBy() == null ? other.getUpdatedBy() == null : this.getUpdatedBy().equals(other.getUpdatedBy()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getPractitionerId() == null) ? 0 : getPractitionerId().hashCode());
        result = prime * result + ((getPractitionerCode() == null) ? 0 : getPractitionerCode().hashCode());
        result = prime * result + ((getYearMonth() == null) ? 0 : getYearMonth().hashCode());
        result = prime * result + ((getSalaryType() == null) ? 0 : getSalaryType().hashCode());
        result = prime * result + ((getSalaryCode() == null) ? 0 : getSalaryCode().hashCode());
        result = prime * result + ((getSalaryName() == null) ? 0 : getSalaryName().hashCode());
        result = prime * result + ((getAmount() == null) ? 0 : getAmount().hashCode());
        result = prime * result + ((getTax() == null) ? 0 : getTax().hashCode());
        result = prime * result + ((getAfterTaxAmount() == null) ? 0 : getAfterTaxAmount().hashCode());
        result = prime * result + ((getLifePractitionerSalaryId() == null) ? 0 : getLifePractitionerSalaryId().hashCode());
        result = prime * result + ((getIsActive() == null) ? 0 : getIsActive().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        result = prime * result + ((getCreatedBy() == null) ? 0 : getCreatedBy().hashCode());
        result = prime * result + ((getUpdatedAt() == null) ? 0 : getUpdatedAt().hashCode());
        result = prime * result + ((getUpdatedBy() == null) ? 0 : getUpdatedBy().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", id=").append(id);
        sb.append(", practitionerId=").append(practitionerId);
        sb.append(", practitionerCode=").append(practitionerCode);
        sb.append(", yearMonth=").append(yearMonth);
        sb.append(", salaryType=").append(salaryType);
        sb.append(", salaryCode=").append(salaryCode);
        sb.append(", salaryName=").append(salaryName);
        sb.append(", amount=").append(amount);
        sb.append(", tax=").append(tax);
        sb.append(", afterTaxAmount=").append(afterTaxAmount);
        sb.append(", lifePractitionerSalaryId=").append(lifePractitionerSalaryId);
        sb.append(", isActive=").append(isActive);
        sb.append(", remark=").append(remark);
        sb.append(", createdAt=").append(createdAt);
        sb.append(", createdBy=").append(createdBy);
        sb.append(", updatedAt=").append(updatedAt);
        sb.append(", updatedBy=").append(updatedBy);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}