package com.yd.dal.entity.agms.fortune;

import com.yd.util.CommonUtil;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author xxy
 */
public class CustomerFortuneStatisticalInfo {
    private Long customerId;
    private String mobileNo;
    private String customerName;
    private String customerIdNo;
    private Long customerIdTypeId;
    private String customerBirthdate;
    private Integer customerGender;
    /**
     * 历史累积财富
     */
    private BigDecimal accumulatedFortune;
    /**
     * 剩余总财富
     */
    private BigDecimal totalFortune;
    /**
     * 可提现财富
     */
    private BigDecimal cashableFortune;
    /**
     * 暂不可提现财富
     */
    private BigDecimal uncashableFortune;
    /**
     * 已提现财富
     */
    private BigDecimal drawnFortune;
    /**
     * 已退保财富
     */
    private BigDecimal cancelledFortune;
    /**
     * 提现中
     */
    private BigDecimal processing;
    /**
     * 今年已提现金额
     */
    private BigDecimal yearDrawnFortune;
    /**
     * 净资产
     */
    private BigDecimal netAssets;


    /**
     * 获取
     *
     * @return customerId
     */
    public Long getCustomerId() {
        return this.customerId;
    }

    /**
     * 设置
     *
     * @param customerId
     */
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    /**
     * 获取
     *
     * @return mobileNo
     */
    public String getMobileNo() {
        return this.mobileNo;
    }

    /**
     * 设置
     *
     * @param mobileNo
     */
    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    /**
     * 获取
     *
     * @return customerName
     */
    public String getCustomerName() {
        return this.customerName;
    }

    /**
     * 设置
     *
     * @param customerName
     */
    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    /**
     * 获取
     *
     * @return customerIdNo
     */
    public String getCustomerIdNo() {
        return this.customerIdNo;
    }

    /**
     * 设置
     *
     * @param customerIdNo
     */
    public void setCustomerIdNo(String customerIdNo) {
        this.customerIdNo = customerIdNo;
    }

    /**
     * 获取
     *
     * @return customerIdTypeId
     */
    public Long getCustomerIdTypeId() {
        return this.customerIdTypeId;
    }

    /**
     * 设置
     *
     * @param customerIdTypeId
     */
    public void setCustomerIdTypeId(Long customerIdTypeId) {
        this.customerIdTypeId = customerIdTypeId;
    }

    /**
     * 获取
     *
     * @return customerBirthdate
     */
    public String getCustomerBirthdate() {
        return this.customerBirthdate;
    }

    /**
     * 设置
     *
     * @param customerBirthdate
     */
    public void setCustomerBirthdate(String customerBirthdate) {
        this.customerBirthdate = customerBirthdate;
    }

    /**
     * 获取
     *
     * @return customerGender
     */
    public Integer getCustomerGender() {
        return this.customerGender;
    }

    /**
     * 设置
     *
     * @param customerGender
     */
    public void setCustomerGender(Integer customerGender) {
        this.customerGender = customerGender;
    }

    /**
     * 获取 历史累积财富
     *
     * @return accumulatedFortune 历史累积财富
     */
    public BigDecimal getAccumulatedFortune() {
        return CommonUtil.isNullOrZero(this.accumulatedFortune)? BigDecimal.ZERO: this.accumulatedFortune;
    }

    /**
     * 设置 历史累积财富
     *
     * @param accumulatedFortune 历史累积财富
     */
    public void setAccumulatedFortune(BigDecimal accumulatedFortune) {
        this.accumulatedFortune = accumulatedFortune;
    }

    /**
     * 获取 剩余总财富
     *
     * @return totalFortune 剩余总财富
     */
    public BigDecimal getTotalFortune() {
        return CommonUtil.isNullOrZero(this.totalFortune)? BigDecimal.ZERO: this.totalFortune;
    }

    /**
     * 设置 剩余总财富
     *
     * @param totalFortune 剩余总财富
     */
    public void setTotalFortune(BigDecimal totalFortune) {
        this.totalFortune = totalFortune;
    }

    /**
     * 获取 可提现财富
     *
     * @return cashableFortune 可提现财富
     */
    public BigDecimal getCashableFortune() {
        return CommonUtil.isNullOrZero(this.cashableFortune)? BigDecimal.ZERO: this.cashableFortune;
    }

    /**
     * 设置 可提现财富
     *
     * @param cashableFortune 可提现财富
     */
    public void setCashableFortune(BigDecimal cashableFortune) {
        this.cashableFortune = cashableFortune;
    }

    /**
     * 获取 暂不可提现财富
     *
     * @return uncashableFortune 暂不可提现财富
     */
    public BigDecimal getUncashableFortune() {
        return CommonUtil.isNullOrZero(this.uncashableFortune)? BigDecimal.ZERO: this.uncashableFortune;
    }

    /**
     * 设置 暂不可提现财富
     *
     * @param uncashableFortune 暂不可提现财富
     */
    public void setUncashableFortune(BigDecimal uncashableFortune) {
        this.uncashableFortune = uncashableFortune;
    }

    /**
     * 获取 已提现财富
     *
     * @return drawnFortune 已提现财富
     */
    public BigDecimal getDrawnFortune() {
        return CommonUtil.isNullOrZero(this.drawnFortune)? BigDecimal.ZERO: this.drawnFortune;
    }

    /**
     * 设置 已提现财富
     *
     * @param drawnFortune 已提现财富
     */
    public void setDrawnFortune(BigDecimal drawnFortune) {
        this.drawnFortune = drawnFortune;
    }

    /**
     * 获取 已退保财富
     *
     * @return cancelledFortune 已退保财富
     */
    public BigDecimal getCancelledFortune() {
        return CommonUtil.isNullOrZero(this.cancelledFortune)? BigDecimal.ZERO: this.cancelledFortune;
    }

    /**
     * 设置 已退保财富
     *
     * @param cancelledFortune 已退保财富
     */
    public void setCancelledFortune(BigDecimal cancelledFortune) {
        this.cancelledFortune = cancelledFortune;
    }

    /**
     * 获取 提现中
     *
     * @return processing 提现中
     */
    public BigDecimal getProcessing() {
        return CommonUtil.isNullOrZero(this.processing)? BigDecimal.ZERO: this.processing;
    }

    /**
     * 设置 提现中
     *
     * @param processing 提现中
     */
    public void setProcessing(BigDecimal processing) {
        this.processing = processing;
    }

    /**
     * 获取 今年已提现金额
     *
     * @return yearDrawnFortune 今年已提现金额
     */
    public BigDecimal getYearDrawnFortune() {
        return CommonUtil.isNullOrZero(this.yearDrawnFortune)? BigDecimal.ZERO: this.yearDrawnFortune;
    }

    /**
     * 设置 今年已提现金额
     *
     * @param yearDrawnFortune 今年已提现金额
     */
    public void setYearDrawnFortune(BigDecimal yearDrawnFortune) {
        this.yearDrawnFortune = yearDrawnFortune;
    }

    /**
     * 获取 净资产
     *
     * @return netAssets 净资产
     */
    public BigDecimal getNetAssets() {
        return CommonUtil.isNullOrZero(this.netAssets)? BigDecimal.ZERO: this.netAssets;
    }

    /**
     * 设置 净资产
     *
     * @param netAssets 净资产
     */
    public void setNetAssets(BigDecimal netAssets) {
        this.netAssets = netAssets;
    }
}
