package com.yd.rmi.ali.send.service;

import org.springframework.stereotype.Service;

import java.util.List;

@Service("sendService")
public interface SendService {

	/**
	 * 发送Email和SMS综合接口
	 * @param category 【邮件】填写email，【短信】则填写sms
	 * @param number 【邮箱】--邮箱号，【短信】--手机号
	 * @param type 【邮箱】信件类型【填3】：1-单封邮件发送，2-批量邮件发送，3-SMTP邮件发送，【短信】格式为：1-验证码短信，2-支付提醒短信，3-承保成功短信，4-生日祝福短信，5-续保提现短信，0-临时短信，6-蒙哥方案分析完成短信
	 * @param content 【邮箱】则为邮箱的正文部分，【短信】则为替换短信模板中变量的JSON字符串，如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为  "{\"name\":\""+name+"\",\"code\":\""+code+"\"}";
	 * @param templateCode 【邮箱】--不填，【短信】--短信模板代码
	 * @param subject 【邮箱】--邮箱标题，【短信】--签名信息，最惠比、银盾保险经纪、安吉保、银盾保险在线
	 * @param ccAddress 【邮箱】--抄送的账户，【短信】--不填
	 * @param contentSummary 内容概要
	 * @param useFor 该短信和邮件主要是为了什么发送的，1=订单 2=提现 3=客户意见 4=汽车问卷 5=活动 6=wordpress 7=生日快乐 99=其他'
	 * @param useForId 相应的主键ID，如：订单id等
	 */
	void sendEmailOrSMS(String category,String number,String type,String content,String templateCode,String subject,String[] ccAddress,String contentSummary,Integer useFor,Long useForId);

	/**
	 * 发送短信
	 * @param mobile 手机号
	 * @param type 格式为：1-验证码短信，2-支付提醒短信，3-承保成功短信，4-生日祝福短信，5-续保提现短信，0-临时短信，6-蒙哥方案分析完成短信
	 * @param content 则为替换短信模板中变量的JSON字符串，如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为  "{\"name\":\""+name+"\",\"code\":\""+code+"\"}";
	 * @param templateCode 短信模板代码
	 * @param subject 签名信息，最惠比、银盾保险经纪、最惠比、银盾保险经纪、安吉保、银盾保险在线
	 * @param contentSummary 内容概要
	 * @param useFor 该短信和邮件主要是为了什么发送的，1=订单 2=提现 3=客户意见 4=汽车问卷 5=活动 6=wordpress 7=生日快乐 99=其他'
	 * @param useForId 相应的主键ID，如：订单id等
	 */
	 void sendSMS(String mobile, String type, String content, String templateCode, String subject, String contentSummary, Integer useFor, Long useForId);

	void sendEmail(String category, String number, String content, String subject, String[] ccAddress, String contentSummary, Integer useFor, List<String> attachmentFiles);

	boolean sendEmail(String email, String messageText, String subject, String[] ccAddresses);
}
