package com.yd.api.agms;

import com.yd.api.agms.service.AgmsStatisticsService;
import com.yd.api.agms.vo.statistics.FinancialStatisticsRequestVO;
import com.yd.api.agms.vo.statistics.FinancialStatisticsResponseVO;
import com.yd.api.agms.vo.statistics.LeadsStatisticsRequestVO;
import com.yd.api.agms.vo.statistics.LeadsStatisticsResponseVO;
import com.yd.api.result.JsonResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

@Controller
@RestController
@RequestMapping("/agms")
public class AgmsController {
    @Autowired
    private AgmsStatisticsService agmsStatisticsService;

    /**
     * AGMS -- 财务管理报表
     * @param requestVO 请求数据
     * @return 响应数据
     */
    @RequestMapping("/financialPredictStatistics")
    public Object financialPredictStatistics(@RequestBody FinancialStatisticsRequestVO requestVO, HttpServletResponse response){
        JsonResult result = new JsonResult();
        FinancialStatisticsResponseVO responseVO = agmsStatisticsService.financialPredictStatistics(requestVO,response);
        result.addResult(responseVO);
        result.setData(responseVO);
        return result;
    }

    /**
     * AGMS -- 商机统计报表
     * @param requestVO
     * @return
     */
    @RequestMapping(value="/leadsStatistics")
    public Object leadsStatistics(@RequestBody LeadsStatisticsRequestVO requestVO,HttpServletResponse response) {
        JsonResult result = new JsonResult();
        LeadsStatisticsResponseVO responseVO = agmsStatisticsService.leadsStatistics(requestVO,response);
        result.setData(responseVO);
        result.addResult(responseVO);
        return result;
    }
}
