package com.yd.dal.service.marketing.Impl;

import com.yd.api.agms.vo.statistics.LeadsStatisticsInfo;
import com.yd.dal.entity.leads.LeadsStatusInfo;
import com.yd.dal.entity.marketing.MktLeadsPool;
import com.yd.dal.mapper.marketing.MktLeadsPoolMapper;
import com.yd.dal.service.marketing.MktLeadsPoolDALService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("mktLeadsPoolDALService")
public class MktLeadsPoolDALServiceImpl implements MktLeadsPoolDALService {
    @Resource
    private MktLeadsPoolMapper mktLeadsPoolMapper;

    @Override
    public MktLeadsPool findByCustomerId(Long customerId) {
        return mktLeadsPoolMapper.findByCustomerId(customerId);
    }

    @Override
    public void save(MktLeadsPool pool) {
        mktLeadsPoolMapper.insertSelective(pool);
    }

    @Override
    public List<LeadsStatisticsInfo> findALLByDate(String leadsStartTime, String leadsEndTime) {
        return mktLeadsPoolMapper.findALLByDate(leadsStartTime,leadsEndTime);
    }

    @Override
    public List<LeadsStatisticsInfo> findIsAssignByDate(String leadsStartTime, String leadsEndTime) {
        return mktLeadsPoolMapper.findIsAssignByDate(leadsStartTime,leadsEndTime);
    }

    @Override
    public List<LeadsStatisticsInfo> findIsNotAssignByDate(String leadsStartTime, String leadsEndTime) {
        return mktLeadsPoolMapper.findIsNotAssignByDate(leadsStartTime,leadsEndTime);
    }

    @Override
    public List<LeadsStatisticsInfo> findIsAssignLeads() {
        return mktLeadsPoolMapper.findIsAssignLeads();
    }

    @Override
    public Map<Long, Long> findLeadsStatusMap() {
        Map<Long, Long> leadsMap = new HashMap<>();
        List<LeadsStatusInfo> leadsStatusInfoList = mktLeadsPoolMapper.findLeadsStatusMap();
        leadsStatusInfoList.forEach(i->leadsMap.put(i.getLeadsCustomerId(),i.getLeadsStatusId()));
        return leadsMap;
    }
}
